/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.editing;

import java.io.InputStream;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.readline.Variable;
import org.jboss.aesh.readline.VariableValues;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.readline.editing.Emacs;
import org.jboss.aesh.util.Config;
import org.jboss.aesh.util.LoggerUtil;

public class InputrcParser {
    private static final Pattern quotePattern = Pattern.compile("^\"");
    private static final Pattern metaPattern = Pattern.compile("^(\\\\M|M|Meta)-");
    private static final Pattern controlPattern = Pattern.compile("^(\\\\C|C|Control)-");
    private static final Logger LOGGER = LoggerUtil.getLogger(InputrcParser.class.getName());
    private static final Pattern variablePattern = Pattern.compile("^set\\s+(\\S+)\\s+(\\S+)$");
    private static final Pattern keyQuoteNamePattern = Pattern.compile("(^\"\\\\\\S+)(\":\\s+)(\\S+)");
    private static final Pattern keyNamePattern = Pattern.compile("(^\\S+)(:\\s+)(\\S+)");

    protected static EditMode parseInputrc(InputStream inputStream) {
        return InputrcParser.parseInputrc(inputStream, EditModeBuilder.builder());
    }

    protected static EditMode parseInputrc(InputStream inputStream, EditModeBuilder editMode) {
        if (inputStream == null) {
            LOGGER.warning("input stream is null, defaulting to emacs mode");
            return new Emacs();
        }
        Pattern commentPattern = Pattern.compile("^#.*");
        Pattern startConstructs = Pattern.compile("^\\$if");
        Pattern endConstructs = Pattern.compile("^\\$endif");
        Scanner scanner = new Scanner(inputStream).useDelimiter(Config.getLineSeparator());
        boolean constructMode = false;
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.trim().length() < 1 || commentPattern.matcher(line).matches()) continue;
            if (startConstructs.matcher(line).matches()) {
                constructMode = true;
                continue;
            }
            if (endConstructs.matcher(line).matches()) {
                constructMode = false;
                continue;
            }
            if (constructMode) continue;
            Matcher variableMatcher = variablePattern.matcher(line);
            if (variableMatcher.matches()) {
                Variable variable = Variable.findVariable(variableMatcher.group(1));
                if (variable == null) continue;
                InputrcParser.parseVariables(variable, variableMatcher.group(2), editMode);
                continue;
            }
            if (!Config.isOSPOSIXCompatible()) continue;
            Matcher keyQuoteMatcher = keyQuoteNamePattern.matcher(line);
            if (keyQuoteMatcher.matches()) {
                editMode.addAction(InputrcParser.mapQuoteKeys(keyQuoteMatcher.group(1)), keyQuoteMatcher.group(3));
                continue;
            }
            Matcher keyMatcher = keyNamePattern.matcher(line);
            if (!keyMatcher.matches()) continue;
            editMode.addAction(InputrcParser.mapKeys(keyMatcher.group(1)), keyMatcher.group(3));
        }
        return editMode.create();
    }

    protected static void parseLine(String line, EditModeBuilder editMode) {
        Matcher variableMatcher = variablePattern.matcher(line);
        if (variableMatcher.matches()) {
            Variable variable = Variable.findVariable(variableMatcher.group(1));
            if (variable != null) {
                InputrcParser.parseVariables(variable, variableMatcher.group(2), editMode);
            }
        } else if (Config.isOSPOSIXCompatible()) {
            Matcher keyQuoteMatcher = keyQuoteNamePattern.matcher(line);
            if (keyQuoteMatcher.matches()) {
                editMode.addAction(InputrcParser.mapQuoteKeys(keyQuoteMatcher.group(1)), keyQuoteMatcher.group(3));
            } else {
                Matcher keyMatcher = keyNamePattern.matcher(line);
                if (keyMatcher.matches()) {
                    editMode.addAction(InputrcParser.mapKeys(keyMatcher.group(1)), keyMatcher.group(3));
                }
            }
        }
    }

    private static void parseVariables(Variable variable, String value, EditModeBuilder editMode) {
        if (VariableValues.getValuesByVariable(variable).size() > 0) {
            if (VariableValues.getValuesByVariable(variable).contains(value)) {
                editMode.addVariable(variable, value);
            } else {
                LOGGER.warning("Variable: " + (Object)((Object)variable) + " do not allow value: " + value);
            }
        } else {
            editMode.addVariable(variable, value);
        }
    }

    public static int[] mapKeys(String keys) {
        boolean meta = false;
        boolean control = false;
        String randomKeys = null;
        String rest = keys;
        while (rest != null) {
            String[] split;
            if (metaPattern.matcher(rest).find()) {
                meta = true;
                split = metaPattern.split(rest);
                if (split.length > 1) {
                    rest = split[1];
                    continue;
                }
                rest = null;
                continue;
            }
            if (controlPattern.matcher(rest).find()) {
                control = true;
                split = controlPattern.split(rest);
                if (split.length > 1) {
                    rest = split[1];
                    continue;
                }
                rest = null;
                continue;
            }
            randomKeys = rest;
            rest = null;
        }
        return InputrcParser.mapRandomKeys(randomKeys, control, meta);
    }

    public static int[] mapQuoteKeys(String keys) {
        if (keys != null && keys.length() > 1) {
            return InputrcParser.mapKeys(keys.substring(1));
        }
        return null;
    }

    private static int[] mapRandomKeys(String randomKeys, boolean control, boolean meta) {
        int[] out;
        if (randomKeys == null) {
            throw null;
        }
        int pos = 0;
        if (meta) {
            out = new int[randomKeys.length() + 1];
            out[0] = 27;
            pos = 1;
        } else {
            out = new int[randomKeys.length()];
        }
        int[] random = control ? InputrcParser.convertRandomControlKeys(randomKeys) : InputrcParser.convertRandomKeys(randomKeys);
        int i = 0;
        while (i < random.length) {
            out[pos] = random[i];
            ++i;
            ++pos;
        }
        return out;
    }

    private static int[] convertRandomKeys(String random) {
        int[] converted = new int[random.length()];
        for (int i = 0; i < random.length(); ++i) {
            converted[i] = random.charAt(i);
        }
        return converted;
    }

    private static int[] convertRandomControlKeys(String random) {
        int length = random.length();
        int[] tmpArray = new int[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int converted = InputrcParser.lookupControlKey(Character.toLowerCase(random.charAt(i)));
            if (converted == -1) {
                LOGGER.warning("ERROR parsing " + random + " keys to aesh. Check your inputrc. Ignoring entry!");
                continue;
            }
            tmpArray[index++] = converted;
        }
        if (index != length) {
            int[] trimmedArray = new int[index];
            for (int i = 0; i < index; ++i) {
                trimmedArray[i] = tmpArray[i];
            }
            return trimmedArray;
        }
        return tmpArray;
    }

    private static int lookupControlKey(char c) {
        switch (c) {
            case '@': {
                return 0;
            }
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'j': {
                return 10;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 12;
            }
            case 'm': {
                return 13;
            }
            case 'n': {
                return 14;
            }
            case 'o': {
                return 15;
            }
            case 'p': {
                return 16;
            }
            case 'q': {
                return 17;
            }
            case 'r': {
                return 18;
            }
            case 's': {
                return 19;
            }
            case 't': {
                return 20;
            }
            case 'u': {
                return 21;
            }
            case 'v': {
                return 22;
            }
            case 'w': {
                return 23;
            }
            case 'x': {
                return 24;
            }
            case 'y': {
                return 25;
            }
            case 'z': {
                return 26;
            }
            case '[': {
                return 27;
            }
            case '?': {
                return Config.isOSPOSIXCompatible() ? 127 : 8;
            }
        }
        return -1;
    }
}

