/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.history;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.readline.history.History;
import org.jboss.aesh.readline.history.SearchDirection;

public class InMemoryHistory
extends History {
    private final List<String> historyList;
    private int lastId = 0;
    private String current;
    private SearchDirection searchDirection = SearchDirection.REVERSE;
    private final int maxSize;
    private String lastSearchArgument;

    public InMemoryHistory() {
        this(500);
    }

    public InMemoryHistory(int maxSize) {
        this.maxSize = maxSize == -1 ? Integer.MAX_VALUE : maxSize;
        this.historyList = new ArrayList<String>();
        this.current = "";
    }

    @Override
    public void push(String entry) {
        if (this.isEnabled() && entry != null && entry.trim().length() > 0) {
            if (this.historyList.size() > 0 && this.historyList.get(this.historyList.size() - 1).equals(entry.trim())) {
                this.lastId = this.size();
                return;
            }
            if (this.historyList.size() >= this.maxSize) {
                this.historyList.remove(0);
            }
            this.historyList.add(entry.trim());
            this.lastId = this.size();
        }
    }

    @Override
    public void push(int[] entry) {
        this.push(Parser.fromCodePoints(entry));
    }

    @Override
    public String find(String search) {
        int index = this.historyList.indexOf(search);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    @Override
    public String get(int index) {
        return this.historyList.get(index);
    }

    @Override
    public int[] getAsInts(int index) {
        return this.historyList.get(index).chars().toArray();
    }

    @Override
    public int size() {
        return this.historyList.size();
    }

    @Override
    public void setSearchDirection(SearchDirection direction) {
        if (this.searchDirection != direction) {
            this.searchDirection = direction;
            this.lastSearchArgument = null;
            this.lastId = 0;
        }
    }

    @Override
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    @Override
    public String getPreviousFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastId > 0) {
            return this.get(--this.lastId);
        }
        return this.get(this.lastId);
    }

    @Override
    public String getNextFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastId < this.size() - 1) {
            return this.get(++this.lastId);
        }
        if (this.lastId == this.size() - 1) {
            ++this.lastId;
            return this.getCurrent();
        }
        return this.getCurrent();
    }

    @Override
    public String search(String search) {
        if (this.searchDirection == SearchDirection.REVERSE) {
            return this.searchReverse(search);
        }
        return this.searchForward(search);
    }

    private String searchReverse(String search) {
        if (this.lastId <= 0 || this.lastId > this.size() - 1) {
            this.lastId = this.size() - 1;
        } else if (this.lastSearchArgument != null && this.lastSearchArgument.equals(search)) {
            --this.lastId;
        }
        while (this.lastId >= 0) {
            if (this.historyList.get(this.lastId).contains(search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastId);
            }
            --this.lastId;
        }
        return null;
    }

    private String searchForward(String search) {
        if (this.lastId >= this.size()) {
            this.lastId = 0;
        } else if (this.lastSearchArgument != null && this.lastSearchArgument.equals(search)) {
            ++this.lastId;
        }
        while (this.lastId < this.size()) {
            if (this.historyList.get(this.lastId).contains(search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastId);
            }
            ++this.lastId;
        }
        return null;
    }

    @Override
    public void setCurrent(String line) {
        this.current = line;
    }

    @Override
    public String getCurrent() {
        return this.current;
    }

    @Override
    public List<String> getAll() {
        return this.historyList;
    }

    @Override
    public void clear() {
        this.lastId = 0;
        this.historyList.clear();
        this.current = "";
    }

    @Override
    public void stop() {
    }
}

