/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.impl.CygwinPty;
import org.jboss.aesh.terminal.impl.ExecPty;
import org.jboss.aesh.terminal.impl.ExternalTerminal;
import org.jboss.aesh.terminal.impl.PosixSysTerminal;
import org.jboss.aesh.terminal.impl.Pty;
import org.jboss.aesh.terminal.impl.WinSysTerminal;
import org.jboss.aesh.terminal.utils.OSUtils;

public final class TerminalBuilder {
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private String encoding;
    private Boolean system;
    private boolean nativeSignals = true;

    public static Terminal console() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system) {
        this.system = system;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder type(String type) {
        this.type = type;
        return this;
    }

    public TerminalBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public Terminal build() throws IOException {
        String encoding;
        String name = this.name;
        if (name == null) {
            name = "Aesh console";
        }
        if ((encoding = this.encoding) == null) {
            encoding = Charset.defaultCharset().name();
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && (this.in == null || this.in == System.in) && (this.out == null || this.out == System.out)) {
            if (OSUtils.IS_CYGWIN) {
                String type = this.type;
                if (type == null) {
                    type = System.getenv("TERM");
                }
                Pty pty = CygwinPty.current();
                return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals);
            }
            if (OSUtils.IS_WINDOWS) {
                return new WinSysTerminal(name, this.nativeSignals);
            }
            if (OSUtils.IS_HPUX) {
                return new ExternalTerminal(name, this.type, System.in, System.out, encoding);
            }
            String type = this.type;
            if (type == null) {
                type = System.getenv("TERM");
            }
            Pty pty = null;
            try {
                pty = ExecPty.current();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (pty != null) {
                return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals);
            }
            return new ExternalTerminal(name, type, System.in, System.out, encoding);
        }
        return new ExternalTerminal(name, this.type, this.in, this.out, encoding);
    }
}

