/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal.utils;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.utils.Curses;
import org.jboss.aesh.terminal.utils.InfoCmp;

public class InfoCmpHelper {
    private static boolean initialized = false;
    private static Set<InfoCmp.Capability> bools = new HashSet<InfoCmp.Capability>();
    private static Map<InfoCmp.Capability, Integer> ints = new HashMap<InfoCmp.Capability, Integer>();
    private static Map<InfoCmp.Capability, String> strings = new HashMap<InfoCmp.Capability, String>();

    public static int[] getCurrentTranslatedCapabilityAsInts(String cap, int[] defaultValue) {
        String s = InfoCmpHelper.getCurrentTranslatedCapability(cap, Parser.fromCodePoints(defaultValue));
        if (s.length() == 0) {
            return defaultValue;
        }
        return s.codePoints().toArray();
    }

    public static String getCurrentTranslatedCapability(String cap, String defaultValue) {
        try {
            String capStr;
            InfoCmp.Capability capability;
            if (!initialized) {
                String term = System.getenv("TERM");
                if (term == null) {
                    term = "xterm-256color";
                }
                String infocmp = InfoCmp.getInfoCmp(term);
                InfoCmp.parseInfoCmp(infocmp, bools, ints, strings);
                initialized = true;
            }
            if ((capability = InfoCmp.Capability.byName(cap)) != null && (capStr = strings.get((Object)capability)) != null) {
                StringWriter sw = new StringWriter();
                Curses.tputs(sw, capStr, new Object[0]);
                return sw.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

