/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.tty.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.io.Decoder;
import org.jboss.aesh.io.Encoder;
import org.jboss.aesh.terminal.Attributes;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalBuilder;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.LoggerUtil;

public class TerminalConnection
implements Connection {
    private Terminal terminal;
    private static final Logger LOGGER = LoggerUtil.getLogger(TerminalConnection.class.getName());
    private Consumer<Size> sizeHandler;
    private Decoder decoder;
    private Consumer<int[]> stdOut;
    private Consumer<int[]> inputHandler;
    private Attributes attributes;
    private Consumer<Signal> eventHandler;
    private volatile boolean reading = true;
    private Consumer<Void> closeHandler;

    public TerminalConnection(InputStream inputStream, OutputStream outputStream) {
        try {
            this.init(TerminalBuilder.builder().streams(inputStream, outputStream).nativeSignals(true).name("Aesh console").build());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TerminalConnection() {
        this(System.in, System.out);
    }

    public TerminalConnection(Terminal terminal) {
        this.init(terminal);
    }

    private void init(Terminal term) {
        this.terminal = term;
        this.terminal.handle(Signal.INT, s -> {
            if (this.getSignalHandler() != null) {
                this.getSignalHandler().accept(s);
            } else {
                LOGGER.info("No signal handler is registered, lets stop");
                this.close();
            }
        });
        this.terminal.handle(Signal.WINCH, s -> {
            if (this.getSizeHandler() != null) {
                this.getSizeHandler().accept(this.size());
            }
        });
        this.decoder = new Decoder(StandardCharsets.UTF_8, this.inputHandler);
        this.stdOut = new Encoder(StandardCharsets.UTF_8, this::write);
    }

    public void startNonBlockingReader() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> {
            Thread inputThread = Executors.defaultThreadFactory().newThread(runnable);
            inputThread.setName("Aesh InputStream Reader");
            inputThread.setDaemon(true);
            return inputThread;
        });
        executorService.execute(() -> this.startBlockingReader());
    }

    public void startBlockingReader() {
        try {
            this.reading = true;
            byte[] bBuf = new byte[1024];
            this.attributes = this.terminal.enterRawMode();
            while (this.reading) {
                int read = this.terminal.input().read(bBuf);
                if (read > 0) {
                    this.decoder.write(bBuf, 0, read);
                    continue;
                }
                if (read >= 0) continue;
                if (this.getCloseHandler() != null) {
                    this.getCloseHandler().accept(null);
                }
                this.close();
                return;
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Failed while reading, exiting", ioe);
            if (this.getCloseHandler() != null) {
                this.getCloseHandler().accept(null);
            }
            this.close();
        }
    }

    public boolean isReading() {
        return this.reading;
    }

    public void stopReading() {
        this.reading = false;
    }

    private void write(byte[] data) {
        try {
            this.terminal.output().write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String terminalType() {
        return this.terminal.getName();
    }

    @Override
    public Size size() {
        return this.terminal.getSize();
    }

    @Override
    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    @Override
    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    @Override
    public Consumer<Signal> getSignalHandler() {
        return this.eventHandler;
    }

    @Override
    public void setSignalHandler(Consumer<Signal> handler) {
        this.eventHandler = handler;
    }

    @Override
    public Consumer<int[]> getStdinHandler() {
        return this.inputHandler;
    }

    @Override
    public void setStdinHandler(Consumer<int[]> handler) {
        this.inputHandler = handler;
        this.decoder.setConsumer(this.inputHandler);
    }

    @Override
    public Consumer<int[]> stdoutHandler() {
        return this.stdOut;
    }

    @Override
    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    @Override
    public void close() {
        try {
            this.stopReading();
            if (this.attributes != null && this.terminal != null) {
                this.terminal.setAttributes(this.attributes);
                this.terminal.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

