/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.Arrays;
import java.util.logging.Logger;
import org.aesh.readline.Prompt;
import org.aesh.util.LoggerUtil;
import org.aesh.util.Parser;

public class BufferString {
    private static final Logger LOGGER = LoggerUtil.getLogger(BufferString.class.getName());
    private int cursor = 0;
    private StringBuilder line;
    private Prompt prompt;
    private int delta;
    private boolean disablePrompt = false;
    private boolean multiLine = false;
    private StringBuilder multiLineBuffer;
    private static boolean ansi = true;
    private static final int TAB = 4;

    protected BufferString(boolean ansi) {
        this(ansi, null);
    }

    protected BufferString(boolean ansi, Prompt prompt) {
        BufferString.ansi = ansi;
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.line = new StringBuilder();
        this.delta = 0;
    }

    protected BufferString(Prompt prompt) {
        this(true, prompt);
    }

    protected void reset(Prompt prompt) {
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.cursor = 0;
        this.line = new StringBuilder();
        this.delta = 0;
        this.multiLine = false;
        this.multiLineBuffer = null;
    }

    public void reset() {
        if (this.prompt == null) {
            this.prompt = new Prompt("");
        }
        this.cursor = 0;
        this.line = new StringBuilder();
        this.delta = 0;
        this.multiLine = false;
        this.multiLineBuffer = null;
    }

    protected void updatePrompt(Prompt prompt) {
        if (this.line.length() > 0) {
            this.prompt = prompt;
        } else {
            this.reset(prompt);
        }
    }

    protected int length() {
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return 1;
        }
        return this.line.length();
    }

    public int totalLength() {
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return this.disablePrompt ? 1 : this.getPrompt().getLength() + 1;
        }
        return this.disablePrompt ? this.line.length() + 1 : this.line.length() + this.getPrompt().getLength() + 1;
    }

    public int getCursor() {
        return this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000' ? 0 : this.cursor;
    }

    protected int getCursorWithPrompt() {
        if (this.disablePrompt) {
            return this.getCursor() + 1;
        }
        return this.getCursor() + this.getPrompt().getLength() + 1;
    }

    public Prompt getPrompt() {
        if (!this.isMultiLine()) {
            return this.prompt;
        }
        return new Prompt("> ");
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean m) {
        this.multiLine = m;
    }

    public void updateMultiLineBuffer() {
        String newLine;
        if (this.multiLineBuffer == null) {
            this.multiLineBuffer = new StringBuilder();
        }
        if ((newLine = this.line.toString()).endsWith(" \\")) {
            this.multiLineBuffer.append(newLine.substring(0, newLine.length() - 1));
        } else {
            this.multiLineBuffer.append(newLine);
        }
        this.line = new StringBuilder();
        this.cursor = 0;
    }

    public String getMultiLineBuffer() {
        return this.multiLineBuffer.toString();
    }

    public boolean isMasking() {
        return this.prompt.isMasking();
    }

    public void disablePrompt(boolean disable) {
        this.disablePrompt = disable;
    }

    protected boolean isPromptDisabled() {
        return this.disablePrompt;
    }

    protected char[] move(int move, int termWidth) {
        return this.move(move, termWidth, false);
    }

    protected char[] move(int move, int termWidth, boolean viMode) {
        int newRow;
        LOGGER.info("moving: " + move + ", width: " + termWidth + ", buffer: " + this.getLine());
        move = this.moveCursor(move, viMode);
        int currentRow = this.getCursorWithPrompt() / termWidth;
        if (currentRow > 0 && this.getCursorWithPrompt() % termWidth == 0) {
            --currentRow;
        }
        if ((newRow = (move + this.getCursorWithPrompt()) / termWidth) > 0 && (move + this.getCursorWithPrompt()) % termWidth == 0) {
            --newRow;
        }
        int row = newRow - currentRow;
        this.setCursor(this.getCursor() + move);
        if (this.prompt.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return new char[0];
        }
        int cursor = this.getCursorWithPrompt() % termWidth;
        if (cursor == 0 && this.getCursorWithPrompt() > 0) {
            cursor = termWidth;
        }
        if (row > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(BufferString.printAnsi(row + "B")).append(BufferString.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        if (row < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(BufferString.printAnsi(Math.abs(row) + "A")).append(BufferString.printAnsi(cursor + "G"));
            return sb.toString().toCharArray();
        }
        LOGGER.info("staying at same row " + move);
        if (move < 0) {
            return BufferString.printAnsi(Math.abs(move) + "D");
        }
        if (move > 0) {
            LOGGER.info("returning: " + Arrays.toString(BufferString.printAnsi(move + "C")));
            return BufferString.printAnsi(move + "C");
        }
        return new char[0];
    }

    private short[] moveToColumn(short column, short direction) {
        short[] out = new short[]{27, 91, column, direction};
        return out;
    }

    private short[] moveToRowAndColumn(short row, short rowCommand, short column) {
        short[] out = new short[]{27, 91, row, rowCommand, 27, 91, column, 71};
        return out;
    }

    public static char[] printAnsi(String out) {
        return BufferString.printAnsi(out.toCharArray());
    }

    public static char[] printAnsi(char ... out) {
        if (!ansi) {
            return new char[0];
        }
        int length = 0;
        for (char c : out) {
            if (c == '\t') {
                length += 4;
                continue;
            }
            ++length;
        }
        char[] ansi = new char[length + 2];
        ansi[0] = 27;
        ansi[1] = 91;
        int counter = 0;
        for (char anOut : out) {
            if (anOut == '\t') {
                Arrays.fill(ansi, counter + 2, counter + 2 + 4, ' ');
                counter += 3;
            } else {
                ansi[counter + 2] = anOut;
            }
            ++counter;
        }
        return ansi;
    }

    private int moveCursor(int move, boolean viMode) {
        if (this.getCursor() == 0 && move <= 0) {
            return 0;
        }
        if (viMode ? this.getCursor() == this.length() - 1 && move > 0 : this.getCursor() == this.length() && move > 0) {
            return 0;
        }
        if (this.getCursor() + move <= 0) {
            return -this.getCursor();
        }
        if (viMode) {
            if (this.getCursor() + move > this.length() - 1) {
                return this.length() - 1 - this.getCursor();
            }
        } else if (this.getCursor() + move > this.length()) {
            return this.length() - this.getCursor();
        }
        return move;
    }

    protected char[] getLineFrom(int position) {
        return this.line.substring(position).toCharArray();
    }

    public String getLine() {
        if (!this.prompt.isMasking()) {
            return this.line.toString();
        }
        if (this.line.length() > 0 && this.prompt.getMask().charValue() != '\u0000') {
            return String.format("%" + this.line.length() + "s", "").replace(' ', this.prompt.getMask().charValue());
        }
        return "";
    }

    public String getLineNoMask() {
        return this.line.toString();
    }

    protected void setLine(String line) {
        this.delta = line.length() - this.line.length();
        this.line = new StringBuilder(line);
        this.cursor = line.length();
    }

    public String getMultiLine() {
        if (this.multiLine) {
            return this.getMultiLineBuffer() + this.getLine();
        }
        return this.getLine();
    }

    public int getMultiCursor() {
        if (this.multiLine) {
            return this.multiLineBuffer.length() + this.getCursor();
        }
        return this.getCursor();
    }

    public void delete(int start, int end) {
        this.delta = start - end;
        this.line.delete(start, end);
    }

    protected void insert(int start, String in) {
        this.line.insert(start, in);
    }

    public String getLineWithPrompt() {
        return Parser.fromCodePoints(this.getPrompt().getPromptAsString()) + this.line;
    }

    public void write(char c) {
        this.line.insert(this.cursor++, c);
        this.delta = 1;
    }

    public void write(String str) {
        assert (str != null);
        if (this.line.length() == 0) {
            this.line.append(str);
        } else {
            this.line.insert(this.getCursor(), str);
        }
        this.cursor += str.length();
        this.delta = str.length();
    }

    protected void clear() {
        this.line = new StringBuilder();
        this.delta = 0;
    }

    public int getDelta() {
        return this.delta;
    }

    protected boolean changeCase() {
        char c = this.getLine().charAt(this.getCursor());
        if (Character.isLetter(c)) {
            if (Character.isLowerCase(c)) {
                this.line.setCharAt(this.getCursor(), Character.toUpperCase(c));
            } else {
                this.line.setCharAt(this.getCursor(), Character.toLowerCase(c));
            }
            return true;
        }
        return false;
    }

    protected void replaceChar(char rChar) {
        this.line.setCharAt(this.getCursor(), rChar);
    }

    public void replaceChar(char rChar, int pos) {
        if (pos > -1 && pos < this.line.length()) {
            this.line.setCharAt(pos, rChar);
        }
    }

    protected boolean containRedirection() {
        return this.line.indexOf(">") > -1;
    }

    protected int getRedirectionPosition() {
        return this.line.indexOf(">");
    }
}

