/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.logging.Logger;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.ActionEvent;
import org.aesh.readline.action.KeyAction;
import org.aesh.terminal.Key;
import org.aesh.util.Config;
import org.aesh.util.LoggerUtil;

public class Complete
implements ActionEvent {
    private boolean askForCompletion = false;
    private KeyAction key;
    private static Logger LOGGER = LoggerUtil.getLogger(Complete.class.getName());

    @Override
    public String name() {
        return "complete";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (this.askForCompletion) {
            this.askForCompletion = false;
            if (this.key == Key.y) {
                inputProcessor.getBuffer().getCompleter().complete(inputProcessor);
            } else {
                inputProcessor.getBuffer().getCompleter().setAskDisplayCompletion(false);
                inputProcessor.getBuffer().getUndoManager().clear();
                inputProcessor.getBuffer().writeOut(Config.CR);
                inputProcessor.getBuffer().drawLine();
            }
        } else if (inputProcessor.getBuffer().getCompleter() != null) {
            LOGGER.info("trying to complete...");
            inputProcessor.getBuffer().getCompleter().complete(inputProcessor);
            if (inputProcessor.getBuffer().getCompleter().doAskDisplayCompletion()) {
                this.askForCompletion = true;
            }
        }
    }

    @Override
    public void input(Action action, KeyAction key) {
        if (this.askForCompletion) {
            this.key = key;
        }
    }

    @Override
    public boolean keepFocus() {
        return this.askForCompletion;
    }
}

