/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.impl.CygwinPty;
import org.aesh.terminal.impl.ExecPty;
import org.aesh.terminal.impl.ExternalTerminal;
import org.aesh.terminal.impl.PosixSysTerminal;
import org.aesh.terminal.impl.Pty;
import org.aesh.terminal.impl.WinSysTerminal;
import org.aesh.terminal.utils.OSUtils;

public final class TerminalBuilder {
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private String encoding;
    private Boolean system;
    private boolean nativeSignals = true;

    public static Terminal console() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    private TerminalBuilder apply(Consumer<TerminalBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public TerminalBuilder name(String name) {
        return this.apply(c -> {
            c.name = name;
        });
    }

    public TerminalBuilder input(InputStream in) {
        return this.apply(c -> {
            c.in = in;
        });
    }

    public TerminalBuilder output(OutputStream out) {
        return this.apply(c -> {
            c.out = out;
        });
    }

    public TerminalBuilder system(boolean system) {
        return this.apply(c -> {
            c.system = system;
        });
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        return this.apply(c -> {
            c.nativeSignals = nativeSignals;
        });
    }

    public TerminalBuilder type(String type) {
        return this.apply(c -> {
            c.type = type;
        });
    }

    public TerminalBuilder encoding(String encoding) {
        return this.apply(c -> {
            c.encoding = encoding;
        });
    }

    public Terminal build() throws IOException {
        String encoding;
        String name = this.name;
        if (name == null) {
            name = "Aesh console";
        }
        if ((encoding = this.encoding) == null) {
            encoding = Charset.defaultCharset().name();
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && (this.in == null || this.in == System.in) && (this.out == null || this.out == System.out)) {
            if (OSUtils.IS_CYGWIN) {
                String type = this.type;
                if (type == null) {
                    type = System.getenv("TERM");
                }
                Pty pty = CygwinPty.current();
                return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals);
            }
            if (OSUtils.IS_WINDOWS) {
                try {
                    return new WinSysTerminal(name, this.nativeSignals);
                }
                catch (IOException e) {
                    return new ExternalTerminal(name, this.type, this.in, this.out, encoding);
                }
            }
            if (OSUtils.IS_HPUX) {
                return new ExternalTerminal(name, this.type, System.in, System.out, encoding);
            }
            String type = this.type;
            if (type == null) {
                type = System.getenv("TERM");
            }
            Pty pty = null;
            try {
                pty = ExecPty.current();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (pty != null) {
                return new PosixSysTerminal(name, type, pty, encoding, this.nativeSignals);
            }
            return new ExternalTerminal(name, type, System.in, System.out, encoding);
        }
        return new ExternalTerminal(name, this.type, this.in, this.out, encoding);
    }
}

