/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.tty;

import java.util.List;
import java.util.function.Consumer;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.Readline;
import org.jboss.aesh.readline.completion.Completion;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.tty.Capability;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.Parser;
import org.junit.Assert;

public class TestConnection
implements Connection {
    private Consumer<Size> sizeHandler;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> stdinHandler;
    private Consumer<int[]> stdOutHandler;
    private Consumer<Void> closeHandler;
    private StringBuilder bufferBuilder;
    private String out;
    private TestReadline readline;
    private Size size;
    private Prompt prompt = new Prompt(": ");

    public TestConnection() {
        this(EditModeBuilder.builder().create(), null);
    }

    public TestConnection(EditMode editMode) {
        this(editMode, null);
    }

    public TestConnection(List<Completion> completions) {
        this(EditModeBuilder.builder().create(), completions);
    }

    public TestConnection(EditMode editMode, List<Completion> completions) {
        this(editMode, completions, null);
    }

    public TestConnection(EditMode editMode, List<Completion> completions, Size size) {
        this(editMode, completions, size, null);
    }

    public TestConnection(EditMode editMode, List<Completion> completions, Size size, Prompt prompt) {
        if (editMode == null) {
            editMode = EditModeBuilder.builder().create();
        }
        this.bufferBuilder = new StringBuilder();
        this.stdOutHandler = ints -> this.bufferBuilder.append(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
        this.size = size == null ? new Size(80, 20) : size;
        if (prompt != null) {
            this.prompt = prompt;
        }
        this.readline = new TestReadline(editMode);
        if (completions != null) {
            this.readline(completions);
        } else {
            this.readline();
        }
    }

    public void readline() {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out -> {
            this.out = out;
        });
    }

    public void readline(List<Completion> completions) {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out -> {
            this.out = out;
        }, completions);
    }

    public void clearOutputBuffer() {
        if (this.bufferBuilder.length() > 0) {
            this.bufferBuilder.delete(0, this.bufferBuilder.length());
        }
    }

    public String getOutputBuffer() {
        return this.bufferBuilder.toString();
    }

    public String getPrompt() {
        return Parser.fromCodePoints((int[])this.prompt.getPromptAsString());
    }

    public void setPrompt(Prompt prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
    }

    public String getLine() {
        return this.out;
    }

    public String terminalType() {
        return "fooTerm";
    }

    public Size size() {
        return this.size;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.signalHandler = handler;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.stdinHandler = handler;
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdOutHandler;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void close() {
        this.closeHandler.accept(null);
    }

    public void openBlocking() {
    }

    public void openNonBlocking() {
    }

    public void stopReading() {
    }

    public void suspend() {
    }

    public boolean suspended() {
        return false;
    }

    public void awake() {
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public void assertBuffer(String expected) {
        Assert.assertEquals((Object)expected, (Object)Parser.stripAwayAnsiCodes((String)this.readline.getBuffer()));
    }

    public void assertLine(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.out);
    }

    public void read(int ... data) {
        this.stdinHandler.accept(data);
    }

    public void read(Key key) {
        this.stdinHandler.accept(key.getKeyValues());
    }

    public void read(String data) {
        this.stdinHandler.accept(Parser.toCodePoints((String)data));
    }

    class TestReadline
    extends Readline {
        TestReadline() {
        }

        TestReadline(EditMode editMode) {
            super(editMode);
        }

        public String getBuffer() {
            return this.getInputProcessor().getBuffer().getBuffer().asString();
        }
    }
}

