/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.action.mappings;

import org.jboss.aesh.readline.ConsoleBuffer;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.action.Action;
import org.jboss.aesh.util.Config;
import org.jboss.aesh.util.Parser;

public class Enter
implements Action {
    private static final String ENDS_WITH_BACKSLASH = " \\";

    @Override
    public String name() {
        return "accept-line";
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        ConsoleBuffer consoleBuffer = inputProcessor.getBuffer();
        consoleBuffer.getUndoManager().clear();
        boolean isCurrentLineEnding = true;
        if (!consoleBuffer.getBuffer().isMasking()) {
            if (consoleBuffer.getBuffer().asString().endsWith(ENDS_WITH_BACKSLASH)) {
                consoleBuffer.getBuffer().setMultiLine(true);
                consoleBuffer.getBuffer().updateMultiLineBuffer();
                inputProcessor.getBuffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (Parser.doesStringContainOpenQuote(consoleBuffer.getBuffer().asString())) {
                consoleBuffer.getBuffer().setMultiLine(true);
                consoleBuffer.getBuffer().updateMultiLineBuffer();
                inputProcessor.getBuffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (inputProcessor.getBuffer().getHistory().isEnabled()) {
                if (consoleBuffer.getBuffer().isMultiLine()) {
                    inputProcessor.getBuffer().getHistory().push(consoleBuffer.getBuffer().getMultiLine());
                } else {
                    inputProcessor.getBuffer().getHistory().push(consoleBuffer.getBuffer().getMultiLine());
                }
            }
        }
        if (isCurrentLineEnding) {
            consoleBuffer.moveCursor(consoleBuffer.getBuffer().length());
        }
        if (isCurrentLineEnding) {
            inputProcessor.setReturnValue(consoleBuffer.getBuffer().getMultiLine());
            consoleBuffer.getBuffer().reset();
        } else {
            consoleBuffer.drawLine();
        }
    }
}

