/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.action.mappings;

import java.util.logging.Logger;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.action.Action;
import org.jboss.aesh.readline.action.KeyAction;
import org.jboss.aesh.readline.action.SearchAction;
import org.jboss.aesh.readline.action.mappings.BackwardChar;
import org.jboss.aesh.readline.action.mappings.DeletePrevChar;
import org.jboss.aesh.readline.action.mappings.Enter;
import org.jboss.aesh.readline.action.mappings.ForwardChar;
import org.jboss.aesh.readline.action.mappings.ForwardSearchHistory;
import org.jboss.aesh.readline.action.mappings.Interrupt;
import org.jboss.aesh.readline.action.mappings.NextHistory;
import org.jboss.aesh.readline.action.mappings.PrevHistory;
import org.jboss.aesh.readline.action.mappings.ReverseSearchHistory;
import org.jboss.aesh.readline.history.SearchDirection;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.IntArrayBuilder;
import org.jboss.aesh.util.LoggerUtil;
import org.jboss.aesh.util.Parser;

abstract class SearchHistory
implements SearchAction {
    private SearchAction.Status status = SearchAction.Status.SEARCH_NOT_STARTED;
    private IntArrayBuilder searchArgument;
    private int[] searchResult;
    private SearchAction.Status defaultAction;
    private static final int[] REVERSE_SEARCH_TEXT = Parser.toCodePoints("(reverse-i-search) `");
    private static final int[] FORWARD_SEARCH_TEXT = Parser.toCodePoints("(forward-i-search) `");
    private static final int[] DIVIDER = Parser.toCodePoints("': ");
    private static final Logger LOGGER = LoggerUtil.getLogger(SearchHistory.class.getName());

    SearchHistory(SearchAction.Status defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public void input(Action action, KeyAction key) {
        if (action == null && Key.isPrintable(key.buffer().array())) {
            if (this.searchArgument == null) {
                this.searchArgument = new IntArrayBuilder(1);
            }
            this.status = this.defaultAction;
            this.searchArgument.append(key.buffer().array()[0]);
        } else if (action instanceof Interrupt) {
            this.status = SearchAction.Status.SEARCH_INTERRUPT;
        } else if (action instanceof Enter) {
            this.status = SearchAction.Status.SEARCH_END;
        } else if (action instanceof ReverseSearchHistory) {
            this.status = SearchAction.Status.SEARCH_PREV;
        } else if (action instanceof ForwardSearchHistory) {
            this.status = SearchAction.Status.SEARCH_NEXT;
        } else if (action instanceof DeletePrevChar) {
            this.status = SearchAction.Status.SEARCH_DELETE;
        } else if (action instanceof PrevHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_PREV;
        } else if (action instanceof NextHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_NEXT;
        } else if (action instanceof ForwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_RIGHT;
        } else if (action instanceof BackwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_LEFT;
        } else {
            if (key == Key.ESC) {
                this.status = SearchAction.Status.SEARCH_EXIT;
            }
            if (Key.isPrintable(key.buffer().array())) {
                if (this.searchArgument == null) {
                    this.searchArgument = new IntArrayBuilder(1);
                }
                this.status = this.defaultAction;
                this.searchArgument.append(key.buffer().array()[0]);
            }
        }
    }

    @Override
    public boolean keepFocus() {
        return this.status == SearchAction.Status.SEARCH_INPUT || this.status == SearchAction.Status.SEARCH_PREV || this.status == SearchAction.Status.SEARCH_NEXT || this.status == SearchAction.Status.SEARCH_DELETE;
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        if (this.status == SearchAction.Status.SEARCH_INTERRUPT) {
            inputProcessor.getBuffer().replace(new int[0]);
            this.searchArgument = null;
            this.searchResult = null;
        } else {
            switch (this.status) {
                case SEARCH_PREV: {
                    if (inputProcessor.getBuffer().getHistory().getSearchDirection() != SearchDirection.REVERSE) {
                        inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.REVERSE);
                    }
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    int[] tmpResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toArray());
                    if (tmpResult == null) {
                        this.searchArgument.deleteLastEntry();
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NEXT: {
                    if (inputProcessor.getBuffer().getHistory().getSearchDirection() != SearchDirection.FORWARD) {
                        inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.FORWARD);
                    }
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    int[] tmpResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toArray());
                    if (tmpResult == null) {
                        this.searchArgument.deleteLastEntry();
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NOT_STARTED: {
                    this.status = SearchAction.Status.SEARCH_PREV;
                    inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.REVERSE);
                    if (inputProcessor.getBuffer().getBuffer().length() <= 0) break;
                    this.searchArgument = new IntArrayBuilder(inputProcessor.getBuffer().getBuffer().getMultiLine());
                    this.searchResult = inputProcessor.getBuffer().getHistory().search(inputProcessor.getBuffer().getBuffer().getMultiLine());
                    break;
                }
                case SEARCH_DELETE: {
                    if (this.searchArgument == null || this.searchArgument.size() <= 0) break;
                    this.searchArgument.deleteLastEntry();
                    this.searchResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toArray());
                    break;
                }
                case SEARCH_END: {
                    if (this.searchResult != null) {
                        inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
                        inputProcessor.getBuffer().replace(this.searchResult);
                        inputProcessor.getBuffer().getHistory().push(inputProcessor.getBuffer().getBuffer().getMultiLine());
                        inputProcessor.getBuffer().getBuffer().reset();
                        inputProcessor.setReturnValue(this.searchResult);
                        break;
                    }
                    inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
                    inputProcessor.getBuffer().replace(new int[0]);
                    break;
                }
                case SEARCH_EXIT: {
                    if (this.searchResult != null) {
                        inputProcessor.getBuffer().replace(this.searchResult);
                        break;
                    }
                    inputProcessor.getBuffer().replace(new int[0]);
                    break;
                }
                case SEARCH_MOVE_NEXT: {
                    this.searchResult = inputProcessor.getBuffer().getHistory().getNextFetch();
                    inputProcessor.getBuffer().replace(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_PREV: {
                    this.searchResult = inputProcessor.getBuffer().getHistory().getPreviousFetch();
                    inputProcessor.getBuffer().replace(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_RIGHT: {
                    inputProcessor.getBuffer().replace(this.searchResult);
                }
                case SEARCH_MOVE_LEFT: {
                    inputProcessor.getBuffer().replace(this.searchResult);
                }
            }
            if (!this.keepFocus()) {
                this.searchArgument = null;
                this.searchResult = null;
                if (this.status != SearchAction.Status.SEARCH_END) {
                    this.moveCursorAtExit(inputProcessor);
                }
            } else if (this.searchArgument == null || this.searchArgument.size() == 0) {
                if (this.searchResult != null) {
                    this.printSearch(new int[0], this.searchResult, inputProcessor);
                } else {
                    this.printSearch(new int[0], new int[0], inputProcessor);
                }
            } else if (this.searchResult != null && this.searchResult.length > 0) {
                this.printSearch(this.searchArgument.toArray(), this.searchResult, inputProcessor);
            }
        }
    }

    private void printSearch(int[] searchTerm, int[] result, InputProcessor inputProcessor) {
        int cursor = Parser.arrayIndexOf(result, searchTerm);
        IntArrayBuilder builder = inputProcessor.getBuffer().getHistory().getSearchDirection() == SearchDirection.REVERSE ? new IntArrayBuilder(REVERSE_SEARCH_TEXT) : new IntArrayBuilder(FORWARD_SEARCH_TEXT);
        builder.append(searchTerm).append(DIVIDER);
        cursor += builder.size();
        builder.append(result);
        inputProcessor.getBuffer().getBuffer().disablePrompt(true);
        inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
        inputProcessor.getBuffer().writeOut(ANSI.CURSOR_START);
        inputProcessor.getBuffer().writeOut(ANSI.ERASE_WHOLE_LINE);
        inputProcessor.getBuffer().replace(builder.toArray());
        inputProcessor.getBuffer().moveCursor(cursor - inputProcessor.getBuffer().getBuffer().getCursor());
        inputProcessor.getBuffer().getBuffer().disablePrompt(false);
    }

    private void moveCursorAtExit(InputProcessor inputProcessor) {
        if (this.status == SearchAction.Status.SEARCH_MOVE_RIGHT) {
            inputProcessor.getBuffer().moveCursor(inputProcessor.getBuffer().getBuffer().length());
        }
    }
}

