/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.editing;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.aesh.readline.action.Action;
import org.jboss.aesh.readline.action.ActionEvent;
import org.jboss.aesh.readline.action.KeyAction;
import org.jboss.aesh.readline.action.mappings.ActionMapper;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.Variable;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.LoggerUtil;

public class Vi
implements EditMode {
    private EditMode.Status status = EditMode.Status.EDIT;
    private Action previousAction;
    private ActionEvent currentAction;
    private Map<Key, ActionStatus> actions = new EnumMap<Key, ActionStatus>(Key.class);
    private Map<KeyAction, ActionStatus> keyEventActions;
    private Map<Key, ActionStatusGroup> actionGroups;
    private Map<Variable, String> variables = new HashMap<Variable, String>();
    private static final Logger LOGGER = LoggerUtil.getLogger(Vi.class.getName());

    Vi() {
        this.keyEventActions = new HashMap<KeyAction, ActionStatus>();
        this.actionGroups = new EnumMap<Key, ActionStatusGroup>(Key.class);
    }

    @Override
    public void addAction(int[] input, String action) {
        Key key = Key.getKey(input);
        if (key != null) {
            this.addAction(key, action);
        } else {
            this.keyEventActions.put(this.createKeyEvent(input), new ActionStatus(ActionMapper.mapToAction(action), EditMode.Status.EDIT, EditMode.Status.EDIT));
        }
    }

    @Override
    public void addVariable(Variable variable, String value) {
        this.variables.put(variable, value);
    }

    @Override
    public String getVariableValue(Variable variable) {
        return this.variables.get((Object)variable);
    }

    public Vi addAction(Key key, String action) {
        return this.addAction(key, action, EditMode.Status.EDIT);
    }

    public Vi addAction(Key key, String action, EditMode.Status status) {
        this.actions.put(key, new ActionStatus(ActionMapper.mapToAction(action), status, EditMode.Status.EDIT));
        return this;
    }

    public Vi addAction(Key key, String action, EditMode.Status status, EditMode.Status after) {
        this.actions.put(key, new ActionStatus(ActionMapper.mapToAction(action), status, after));
        return this;
    }

    @Override
    public Vi addAction(Key key, Action action) {
        return this.addAction(key, action, EditMode.Status.EDIT);
    }

    public Vi addAction(Key key, Action action, EditMode.Status status) {
        this.actions.put(key, new ActionStatus(action, status, EditMode.Status.EDIT));
        return this;
    }

    public Vi addAction(Key key, Action action, EditMode.Status status, EditMode.Status after) {
        this.actions.put(key, new ActionStatus(action, status, after));
        return this;
    }

    public Vi addAction(Key key, Action action, EditMode.Status status, EditMode.Status after, EditMode.Status actionStatus) {
        this.actions.put(key, new ActionStatus(action, status, after, actionStatus));
        return this;
    }

    public Vi addActionGroup(Key key, ActionStatusGroup group) {
        this.actionGroups.put(key, group);
        return this;
    }

    @Override
    public void updateIgnoreEOF(int eof) {
    }

    @Override
    public EditMode.Mode getMode() {
        return EditMode.Mode.VI;
    }

    @Override
    public KeyAction[] keys() {
        ArrayList keys = new ArrayList(this.actions.size() + this.keyEventActions.size() + this.actionGroups.size());
        this.actions.keySet().forEach(keys::add);
        this.actionGroups.keySet().forEach(keys::add);
        this.keyEventActions.keySet().forEach(keys::add);
        return keys.toArray(new KeyAction[keys.size()]);
    }

    @Override
    public EditMode.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EditMode.Status status) {
        this.status = status;
    }

    @Override
    public Action parse(KeyAction event) {
        if (this.currentAction != null) {
            if (this.currentAction.keepFocus()) {
                this.currentAction.input(this.getAction(event), event);
                return this.currentAction;
            }
            this.currentAction = null;
        }
        return this.getAction(event);
    }

    @Override
    public boolean isInChainedAction() {
        return this.currentAction != null;
    }

    private Action getAction(KeyAction event) {
        LOGGER.info("got event:" + event);
        ActionStatus newStatus = this.getActionStatus(event);
        LOGGER.info("ActionStatus: " + newStatus);
        if (newStatus == null) {
            return null;
        }
        LOGGER.info("current status: " + (Object)((Object)this.status));
        if (newStatus.getCurrentStatus() == this.status) {
            if (newStatus.getAction() instanceof ActionEvent) {
                this.currentAction = (ActionEvent)newStatus.getAction();
                this.currentAction.input(newStatus.getAction(), event);
            } else {
                if (newStatus.nextStatus == EditMode.Status.REPEAT) {
                    return this.previousAction;
                }
                if (this.status == EditMode.Status.DELETE || newStatus.actionStatus == EditMode.Status.DELETE || newStatus.actionStatus == EditMode.Status.CHANGE) {
                    this.previousAction = newStatus.getAction();
                }
                this.status = newStatus.nextStatus;
                LOGGER.info("new status is: " + (Object)((Object)this.status));
            }
            LOGGER.info("returning action: " + newStatus.getAction());
            return newStatus.getAction();
        }
        return null;
    }

    private void parseKeyEvent(Key event) {
        if (Key.ESC == event) {
            this.status = this.searchMode() ? EditMode.Status.EDIT : EditMode.Status.COMMAND;
        } else if (Key.ENTER == event || Key.ENTER_2 == event || Key.CTRL_J == event || Key.CTRL_K == event) {
            this.status = EditMode.Status.EDIT;
        }
    }

    private ActionStatus getActionStatus(KeyAction event) {
        if (event instanceof Key) {
            ActionStatus actionStatus = this.actions.get(event);
            if (actionStatus != null) {
                return actionStatus;
            }
            ActionStatusGroup group = this.actionGroups.get(event);
            if (group != null) {
                return group.getByCurrentStatus(this.status);
            }
            return null;
        }
        return this.parseKeyEventActions(event);
    }

    private ActionStatus parseKeyEventActions(KeyAction event) {
        for (KeyAction key : this.keyEventActions.keySet()) {
            boolean isEquals = true;
            if (key.length() != event.length()) continue;
            for (int i = 0; i < key.length() && isEquals; ++i) {
                if (key.getCodePointAt(i) == event.getCodePointAt(i)) continue;
                isEquals = false;
            }
            if (!isEquals) continue;
            return this.keyEventActions.get(key);
        }
        return null;
    }

    private boolean deleteMode() {
        return this.status == EditMode.Status.DELETE;
    }

    private boolean changeMode() {
        return this.status == EditMode.Status.CHANGE;
    }

    private boolean replaceMode() {
        return this.status == EditMode.Status.REPLACE;
    }

    private boolean yankMode() {
        return this.status == EditMode.Status.YANK;
    }

    private boolean searchMode() {
        return this.status == EditMode.Status.SEARCH;
    }

    private boolean editMode() {
        return this.status == EditMode.Status.EDIT;
    }

    static final class ActionStatus {
        private final Action action;
        private final EditMode.Status currentStatus;
        private final EditMode.Status nextStatus;
        private final EditMode.Status actionStatus;

        ActionStatus(String action, EditMode.Status status, EditMode.Status nextStatus) {
            this.action = ActionMapper.mapToAction(action);
            this.currentStatus = status;
            this.nextStatus = nextStatus;
            this.actionStatus = EditMode.Status.COMMAND;
        }

        ActionStatus(Action action, EditMode.Status status, EditMode.Status nextStatus) {
            this.action = action;
            this.currentStatus = status;
            this.nextStatus = nextStatus;
            this.actionStatus = EditMode.Status.COMMAND;
        }

        ActionStatus(Action action, EditMode.Status status, EditMode.Status nextStatus, EditMode.Status actionStatus) {
            this.action = action;
            this.currentStatus = status;
            this.nextStatus = nextStatus;
            this.actionStatus = actionStatus;
        }

        public Action getAction() {
            return this.action;
        }

        public EditMode.Status getCurrentStatus() {
            return this.currentStatus;
        }

        public EditMode.Status getNextStatus() {
            return this.nextStatus;
        }

        public EditMode.Status getActionStatus() {
            return this.actionStatus;
        }

        public String toString() {
            return "ActionStatus{action=" + this.action + ", currentStatus=" + (Object)((Object)this.currentStatus) + ", nextStatus=" + (Object)((Object)this.nextStatus) + '}';
        }
    }

    static final class ActionStatusGroup {
        private final ActionStatus[] actionStatuses;

        ActionStatusGroup(ActionStatus[] statues) {
            this.actionStatuses = statues;
        }

        ActionStatus getByCurrentStatus(EditMode.Status currentStatus) {
            for (ActionStatus status : this.actionStatuses) {
                if (status.getCurrentStatus() != currentStatus) continue;
                return status;
            }
            return null;
        }
    }
}

