/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aesh.readline.history.History;
import org.jboss.aesh.readline.history.SearchDirection;
import org.jboss.aesh.util.Parser;

public class InMemoryHistory
extends History {
    private final List<int[]> historyList;
    private int lastId = 0;
    private int[] current;
    private SearchDirection searchDirection = SearchDirection.REVERSE;
    private final int maxSize;
    private int[] lastSearchArgument;

    public InMemoryHistory() {
        this(500);
    }

    public InMemoryHistory(int maxSize) {
        this.maxSize = maxSize == -1 ? Integer.MAX_VALUE : maxSize;
        this.historyList = new ArrayList<int[]>();
        this.current = new int[0];
    }

    @Override
    public void push(int[] entry) {
        if (this.isEnabled() && entry != null && !Parser.isTrimmedArrayEmpty(entry)) {
            if (this.historyList.size() > 0 && Arrays.equals(this.historyList.get(this.historyList.size() - 1), entry)) {
                this.lastId = this.size();
                return;
            }
            if (this.historyList.size() >= this.maxSize) {
                this.historyList.remove(0);
            }
            this.historyList.add(entry);
            this.lastId = this.size();
        }
    }

    @Override
    public int[] find(int[] search) {
        int index = this.historyList.indexOf(search);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    @Override
    public int[] get(int index) {
        return this.historyList.get(index);
    }

    @Override
    public int size() {
        return this.historyList.size();
    }

    @Override
    public void setSearchDirection(SearchDirection direction) {
        if (this.searchDirection != direction) {
            this.searchDirection = direction;
            this.lastSearchArgument = null;
            this.lastId = 0;
        }
    }

    @Override
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    @Override
    public int[] getPreviousFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastId > 0) {
            return this.get(--this.lastId);
        }
        return this.get(this.lastId);
    }

    @Override
    public int[] getNextFetch() {
        if (this.size() < 1) {
            return null;
        }
        if (this.lastId < this.size() - 1) {
            return this.get(++this.lastId);
        }
        if (this.lastId == this.size() - 1) {
            ++this.lastId;
            return this.getCurrent();
        }
        return this.getCurrent();
    }

    @Override
    public int[] search(int[] search) {
        if (this.searchDirection == SearchDirection.REVERSE) {
            return this.searchReverse(search);
        }
        return this.searchForward(search);
    }

    private int[] searchReverse(int[] search) {
        if (this.lastId <= 0 || this.lastId > this.size() - 1) {
            this.lastId = this.size() - 1;
        } else if (this.lastSearchArgument != null && Arrays.equals(this.lastSearchArgument, search)) {
            --this.lastId;
        }
        while (this.lastId >= 0) {
            if (Parser.arrayContains(this.historyList.get(this.lastId), search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastId);
            }
            --this.lastId;
        }
        return null;
    }

    private int[] searchForward(int[] search) {
        if (this.lastId >= this.size()) {
            this.lastId = 0;
        } else if (this.lastSearchArgument != null && Arrays.equals(this.lastSearchArgument, search)) {
            ++this.lastId;
        }
        while (this.lastId < this.size()) {
            if (Parser.arrayContains(this.historyList.get(this.lastId), search)) {
                this.lastSearchArgument = search;
                return this.get(this.lastId);
            }
            ++this.lastId;
        }
        return null;
    }

    @Override
    public void setCurrent(int[] line) {
        this.current = line;
    }

    @Override
    public int[] getCurrent() {
        return this.current;
    }

    @Override
    public List<int[]> getAll() {
        return this.historyList;
    }

    @Override
    public void clear() {
        this.lastId = 0;
        this.historyList.clear();
        this.current = new int[0];
    }

    @Override
    public void stop() {
    }
}

