/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal.impl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.terminal.Attributes;
import org.jboss.aesh.terminal.impl.CygwinPty;
import org.jboss.aesh.terminal.impl.Pty;
import org.jboss.aesh.terminal.utils.ExecHelper;
import org.jboss.aesh.terminal.utils.OSUtils;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.LoggerUtil;

public class ExecPty
implements Pty {
    private static final Logger LOGGER = LoggerUtil.getLogger(CygwinPty.class.getName());
    private final String name;

    public static Pty current() throws IOException {
        try {
            LOGGER.info("getting pty: " + OSUtils.TTY_COMMAND);
            Process p = new ProcessBuilder(OSUtils.TTY_COMMAND).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
            String result = ExecHelper.waitAndCapture(p).trim();
            if (p.exitValue() != 0) {
                throw new IOException("Not a tty");
            }
            LOGGER.info("result: " + result);
            return new ExecPty(result);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e);
        }
    }

    protected ExecPty(String name) {
        this.name = name;
    }

    @Override
    public void close() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getMasterInput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getMasterOutput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getSlaveInput() throws IOException {
        return new FileInputStream(this.getName());
    }

    @Override
    public OutputStream getSlaveOutput() throws IOException {
        return new FileOutputStream(this.getName());
    }

    @Override
    public Attributes getAttr() throws IOException {
        String cfg = this.doGetConfig();
        if (OSUtils.IS_HPUX) {
            return null;
        }
        return ExecPty.doGetAttr(cfg);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttr(Attributes attr) throws IOException {
        void var7_16;
        Attributes current = this.getAttr();
        ArrayList<String> commands = new ArrayList<String>();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            if (attr.getInputFlag(inputFlag) == current.getInputFlag(inputFlag)) continue;
            commands.add((attr.getInputFlag(inputFlag) ? inputFlag.name() : "-" + inputFlag.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            if (attr.getOutputFlag((Attributes.OutputFlag)enum_) == current.getOutputFlag((Attributes.OutputFlag)enum_)) continue;
            commands.add((attr.getOutputFlag((Attributes.OutputFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            if (attr.getControlFlag((Attributes.ControlFlag)enum_) == current.getControlFlag((Attributes.ControlFlag)enum_)) continue;
            commands.add((attr.getControlFlag((Attributes.ControlFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            if (attr.getLocalFlag((Attributes.LocalFlag)enum_) == current.getLocalFlag((Attributes.LocalFlag)enum_)) continue;
            commands.add((attr.getLocalFlag((Attributes.LocalFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        String undef = System.getProperty("os.name").toLowerCase().startsWith("hp") ? "^-" : "undef";
        Attributes.ControlChar[] controlCharArray = Attributes.ControlChar.values();
        int n = controlCharArray.length;
        boolean bl = false;
        while (var7_16 < n) {
            Attributes.ControlChar cchar = controlCharArray[var7_16];
            if (attr.getControlChar(cchar) != current.getControlChar(cchar)) {
                String str = "";
                int v = attr.getControlChar(cchar);
                commands.add(cchar.name().toLowerCase().substring(1));
                if (cchar == Attributes.ControlChar.VMIN || cchar == Attributes.ControlChar.VTIME) {
                    commands.add(Integer.toBinaryString(v));
                } else if (v == 0) {
                    commands.add(undef);
                } else {
                    if (v >= 128) {
                        v -= 128;
                        str = str + "M-";
                    }
                    if (v < 32 || v == 127) {
                        v ^= 0x40;
                        str = str + "^";
                    }
                    str = str + (char)v;
                    commands.add(str);
                }
            }
            ++var7_16;
        }
        if (!commands.isEmpty()) {
            commands.add(0, OSUtils.STTY_COMMAND);
            commands.add(1, OSUtils.STTY_F_OPTION);
            commands.add(2, this.getName());
            ExecPty.exec(commands.toArray(new String[commands.size()]));
        }
    }

    @Override
    public Size getSize() throws IOException {
        String cfg = this.doGetConfig();
        return ExecPty.doGetSize(cfg);
    }

    protected String doGetConfig() throws IOException {
        if (OSUtils.IS_HPUX) {
            return ExecPty.exec("ttytype", "-s");
        }
        return ExecPty.exec(OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "-a");
    }

    static Attributes doGetAttr(String cfg) throws IOException {
        Boolean value;
        Attributes attributes = new Attributes();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            value = ExecPty.doGetFlag(cfg, inputFlag);
            if (value == null) continue;
            attributes.setInputFlag(inputFlag, value);
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setOutputFlag((Attributes.OutputFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setControlFlag((Attributes.ControlFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            value = ExecPty.doGetFlag(cfg, enum_);
            if (value == null) continue;
            attributes.setLocalFlag((Attributes.LocalFlag)enum_, value);
        }
        for (Enum enum_ : Attributes.ControlChar.values()) {
            Matcher matcher;
            String name = enum_.name().toLowerCase().substring(1);
            if ("reprint".endsWith(name)) {
                name = "(?:reprint|rprnt)";
            }
            if (!(matcher = Pattern.compile("[\\s;]" + name + "\\s*=\\s*(.+?)[\\s;]").matcher(cfg)).find()) continue;
            attributes.setControlChar((Attributes.ControlChar)enum_, ExecPty.parseControlChar(matcher.group(1).toUpperCase()));
        }
        return attributes;
    }

    private static Boolean doGetFlag(String cfg, Enum<?> flag) {
        Matcher matcher = Pattern.compile("(?:^|[\\s;])(\\-?" + flag.name().toLowerCase() + ")(?:[\\s;]|$)").matcher(cfg);
        return matcher.find() ? Boolean.valueOf(!matcher.group(1).startsWith("-")) : null;
    }

    static int parseControlChar(String str) {
        if ("<UNDEF>".equals(str)) {
            return -1;
        }
        if ("DEL".equalsIgnoreCase(str)) {
            return 127;
        }
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        return str.charAt(0);
    }

    static Size doGetSize(String cfg) throws IOException {
        return new Size(ExecPty.doGetInt("columns", cfg), ExecPty.doGetInt("rows", cfg));
    }

    static int doGetInt(String name, String cfg) throws IOException {
        String[] patterns;
        for (String pattern : patterns = new String[]{"\\b([0-9]+)\\s+" + name + "\\b", "\\b" + name + "\\s+([0-9]+)\\b", "\\b" + name + "\\s*=\\s*([0-9]+)\\b"}) {
            Matcher matcher = Pattern.compile(pattern).matcher(cfg);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        throw new IOException("Unable to parse " + name);
    }

    private static String exec(String ... cmd) throws IOException {
        assert (cmd != null && cmd[0].length() > 0);
        try {
            LOGGER.log(Level.INFO, "Running: " + Arrays.toString(cmd));
            Process p = new ProcessBuilder(cmd).start();
            String result = ExecHelper.waitAndCapture(p);
            LOGGER.log(Level.INFO, "Result: " + result);
            if (p.exitValue() != 0) {
                throw new IOException("Error executing '" + String.join((CharSequence)" ", cmd) + "': " + result);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e);
        }
    }
}

