/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management;

import io.fabric8.patch.management.BundleUpdate;
import io.fabric8.patch.management.FeatureUpdate;
import io.fabric8.patch.management.PatchData;
import io.fabric8.patch.management.Pending;
import io.fabric8.patch.management.impl.Activator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.ParseException;

public class PatchResult {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String DATE = "date";
    private static final String BUNDLES = "bundle";
    private static final String BUNDLE_UPDATES = "update";
    private static final String SYMBOLIC_NAME = "symbolic-name";
    private static final String NEW_VERSION = "new-version";
    private static final String NEW_LOCATION = "new-location";
    private static final String OLD_VERSION = "old-version";
    private static final String OLD_LOCATION = "old-location";
    private static final String STATE = "state";
    private static final String START_LEVEL = "start-level";
    private static final String INDEPENDENT = "independent";
    private static final String FEATURE_UPDATES = "feature-update";
    private static final String FEATURE_NAME = "name";
    private static final String FEATURE_NEW_REPOSITORY = "new-repository";
    private static final String FEATURE_OLD_REPOSITORY = "old-repository";
    private static final String VERSIONS = "version";
    private static final String KARAF_BASE = "base";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private final PatchData patchData;
    private boolean simulation;
    private long date;
    private Pending pending = null;
    private List<BundleUpdate> bundleUpdates = new LinkedList<BundleUpdate>();
    private List<FeatureUpdate> featureUpdates = new LinkedList<FeatureUpdate>();
    private List<String> versions = new LinkedList<String>();
    private List<String> karafBases = new LinkedList<String>();
    private Map<String, PatchResult> childPatches = new HashMap<String, PatchResult>();
    private PatchResult parent;

    public PatchResult(PatchData patchData) {
        this.patchData = patchData;
    }

    public PatchResult(PatchData patchData, boolean simulation, long date, List<BundleUpdate> bundleUpdates, List<FeatureUpdate> featureUpdates) {
        this(patchData, simulation, date, bundleUpdates, featureUpdates, null);
    }

    public PatchResult(PatchData patchData, boolean simulation, long date, List<BundleUpdate> bundleUpdates, List<FeatureUpdate> featureUpdates, PatchResult parent) {
        this.patchData = patchData;
        this.simulation = simulation;
        this.date = date;
        if (bundleUpdates != null) {
            this.bundleUpdates.addAll(bundleUpdates);
        }
        if (featureUpdates != null) {
            this.featureUpdates.addAll(featureUpdates);
        }
        this.parent = parent;
    }

    public static PatchResult load(PatchData patchData, InputStream inputStream) throws IOException {
        return PatchResult.load(patchData, inputStream, true);
    }

    public static PatchResult load(PatchData patchData, InputStream inputStream, boolean processChildren) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        IOUtils.closeQuietly(inputStream);
        return PatchResult.load(patchData, props, processChildren);
    }

    public static PatchResult load(PatchData patchData, Properties props) {
        return PatchResult.load(patchData, props, true);
    }

    public static PatchResult load(final PatchData patchData, Properties props, boolean processChildren) {
        long date = Long.parseLong(props.getProperty(DATE));
        ArrayList<BundleUpdate> bupdates = new ArrayList<BundleUpdate>();
        int count = Integer.parseInt(props.getProperty("update.count", "0"));
        for (int i = 0; i < count; ++i) {
            String _startLevel;
            String prefix = "update." + Integer.toString(i) + ".";
            String sn = props.getProperty(prefix + SYMBOLIC_NAME);
            String nv = props.getProperty(prefix + NEW_VERSION);
            String nl = props.getProperty(prefix + NEW_LOCATION);
            String ov = props.getProperty(prefix + OLD_VERSION);
            String ol = props.getProperty(prefix + OLD_LOCATION);
            int state = -1;
            int startLevel = -1;
            String _state = props.getProperty(prefix + STATE);
            if (_state != null && !"".equals(_state)) {
                try {
                    state = Integer.parseInt(_state);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((_startLevel = props.getProperty(prefix + START_LEVEL)) != null && !"".equals(_startLevel)) {
                try {
                    startLevel = Integer.parseInt(_startLevel);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            BundleUpdate bundleUpdate = new BundleUpdate(sn, nv, nl, ov, ol, startLevel, state);
            if (props.getProperty(prefix + INDEPENDENT) != null) {
                bundleUpdate.setIndependent(Boolean.parseBoolean(props.getProperty(prefix + INDEPENDENT)));
            }
            bupdates.add(bundleUpdate);
        }
        ArrayList<FeatureUpdate> fupdates = new ArrayList<FeatureUpdate>();
        count = Integer.parseInt(props.getProperty("feature-update.count", "0"));
        for (int i = 0; i < count; ++i) {
            String n = props.getProperty("feature-update." + Integer.toString(i) + "." + FEATURE_NAME);
            String nr = props.getProperty("feature-update." + Integer.toString(i) + "." + FEATURE_NEW_REPOSITORY);
            String nv = props.getProperty("feature-update." + Integer.toString(i) + "." + NEW_VERSION);
            String or = props.getProperty("feature-update." + Integer.toString(i) + "." + FEATURE_OLD_REPOSITORY);
            String ov = props.getProperty("feature-update." + Integer.toString(i) + "." + OLD_VERSION);
            fupdates.add(new FeatureUpdate(n, or, ov, nr, nv));
        }
        ArrayList<String> versions = new ArrayList<String>();
        count = Integer.parseInt(props.getProperty("version.count", "0"));
        for (int i = 0; i < count; ++i) {
            versions.add(props.getProperty("version." + Integer.toString(i)));
        }
        ArrayList<String> karafBases = new ArrayList<String>();
        count = Integer.parseInt(props.getProperty("base.count", "0"));
        for (int i = 0; i < count; ++i) {
            karafBases.add(props.getProperty("base." + Integer.toString(i)));
        }
        final PatchResult result = new PatchResult(patchData, false, date, bupdates, fupdates);
        result.getVersions().addAll(versions);
        result.getKarafBases().addAll(karafBases);
        if (processChildren) {
            patchData.getPatchLocation().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (!pathname.isFile()) {
                        return false;
                    }
                    String prefix = patchData.getId() + ".";
                    String suffix = ".patch.result";
                    if (pathname.getName().equals(patchData.getId() + suffix)) {
                        return false;
                    }
                    if (!pathname.getName().startsWith(prefix) || !pathname.getName().endsWith(suffix)) {
                        return false;
                    }
                    String childId = pathname.getName().substring(0, pathname.getName().length() - suffix.length());
                    childId = childId.substring(prefix.length());
                    try {
                        result.addChildResult(childId, PatchResult.load(patchData, new FileInputStream(pathname), false));
                    }
                    catch (IOException e) {
                        Activator.log2(2, "Can't load patch result from \"" + pathname + "\"");
                    }
                    return false;
                }
            });
        }
        return result;
    }

    public void store() throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(this.patchData.getPatchLocation(), this.patchData.getId() + ".patch.result"));
        this.storeTo(fos);
        fos.close();
        if (this.pending != null) {
            FileUtils.write(new File(this.patchData.getPatchLocation(), this.patchData.getId() + ".patch.pending"), this.pending.toString());
        }
        for (String child : this.childPatches.keySet()) {
            PatchResult pr = this.childPatches.get(child);
            fos = new FileOutputStream(new File(this.patchData.getPatchLocation(), this.patchData.getId() + "." + child + ".patch.result"));
            pr.storeTo(fos);
            fos.close();
            if (pr.pending == null) continue;
            FileUtils.write(new File(this.patchData.getPatchLocation(), this.patchData.getId() + "." + child + ".patch.pending"), pr.pending.toString());
        }
    }

    public void storeTo(OutputStream out) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        pw.write("# generated file, do not modify\n");
        pw.write("# Installation results for patch \"" + this.patchData.getId() + "\"\n");
        pw.write("date = " + Long.toString(this.getDate()) + "\n");
        pw.write("update.count = " + Integer.toString(this.getBundleUpdates().size()) + "\n");
        int i = 0;
        for (BundleUpdate bundleUpdate : this.getBundleUpdates()) {
            String prefix = "update." + Integer.toString(i) + ".";
            pw.write(prefix + SYMBOLIC_NAME + " = " + bundleUpdate.getSymbolicName() + "\n");
            pw.write(prefix + OLD_VERSION + " = " + bundleUpdate.getPreviousVersion() + "\n");
            pw.write(prefix + OLD_LOCATION + " = " + bundleUpdate.getPreviousLocation().replace("\\", "\\\\") + "\n");
            pw.write(prefix + INDEPENDENT + " = " + bundleUpdate.isIndependent() + "\n");
            if (bundleUpdate.getNewVersion() != null) {
                pw.write(prefix + NEW_VERSION + " = " + bundleUpdate.getNewVersion() + "\n");
                pw.write(prefix + NEW_LOCATION + " = " + bundleUpdate.getNewLocation().replace("\\", "\\\\") + "\n");
            }
            if (bundleUpdate.getStartLevel() > -1) {
                pw.write(prefix + START_LEVEL + " = " + bundleUpdate.getStartLevel() + "\n");
            }
            if (bundleUpdate.getState() > -1) {
                pw.write(prefix + STATE + " = " + bundleUpdate.getState() + "\n");
            }
            ++i;
        }
        pw.write("feature-update.count = " + Integer.toString(this.getFeatureUpdates().size()) + "\n");
        i = 0;
        for (FeatureUpdate featureUpdate : this.getFeatureUpdates()) {
            if (featureUpdate.getName() != null) {
                pw.write("feature-update." + Integer.toString(i) + "." + FEATURE_NAME + " = " + featureUpdate.getName() + "\n");
            }
            if (featureUpdate.getNewVersion() != null) {
                pw.write("feature-update." + Integer.toString(i) + "." + NEW_VERSION + " = " + featureUpdate.getNewVersion() + "\n");
                pw.write("feature-update." + Integer.toString(i) + "." + FEATURE_NEW_REPOSITORY + " = " + featureUpdate.getNewRepository() + "\n");
            }
            if (featureUpdate.getPreviousVersion() != null) {
                pw.write("feature-update." + Integer.toString(i) + "." + OLD_VERSION + " = " + featureUpdate.getPreviousVersion() + "\n");
            }
            pw.write("feature-update." + Integer.toString(i) + "." + FEATURE_OLD_REPOSITORY + " = " + featureUpdate.getPreviousRepository() + "\n");
            ++i;
        }
        pw.write("version.count = " + Integer.toString(this.getVersions().size()) + "\n");
        i = 0;
        for (String string : this.getVersions()) {
            pw.write("version." + Integer.toString(i) + " = " + string + "\n");
            ++i;
        }
        pw.write("base.count = " + Integer.toString(this.getKarafBases().size()) + "\n");
        i = 0;
        for (String string : this.getKarafBases()) {
            pw.write("base." + Integer.toString(i) + " = " + string + "\n");
            ++i;
        }
        pw.close();
    }

    public void addChildResult(String instance, PatchResult childResult) {
        this.childPatches.put(instance, childResult);
    }

    public Map<String, PatchResult> getChildPatches() {
        return this.childPatches;
    }

    public PatchResult getParent() {
        return this.parent;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public long getDate() {
        return this.date;
    }

    public List<BundleUpdate> getBundleUpdates() {
        return this.bundleUpdates;
    }

    public List<FeatureUpdate> getFeatureUpdates() {
        return this.featureUpdates;
    }

    public PatchData getPatchData() {
        return this.patchData;
    }

    public Pending isPending() {
        return this.pending;
    }

    public void setPending(Pending pending) {
        this.pending = pending;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getKarafBases() {
        return this.karafBases;
    }
}

