/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.conflicts.ResolverEx;
import io.fabric8.patch.management.impl.Activator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.felix.utils.properties.Properties;

public class PropertiesFileResolver
implements ResolverEx {
    @Override
    public String resolve(File firstChange, File base, File secondChange) {
        return this.resolve(firstChange, base, secondChange, true);
    }

    @Override
    public String resolve(File firstChange, File base, File secondChange, boolean useFirstChangeAsBase) {
        try {
            Change state;
            Properties baseProperties = new Properties(false);
            if (base != null) {
                baseProperties.load(base);
            }
            Properties firstProperties = new Properties(false);
            firstProperties.load(firstChange);
            Properties secondProperties = new Properties(secondChange, false);
            secondProperties.load(secondChange);
            Properties result = useFirstChangeAsBase ? firstProperties : secondProperties;
            Properties otherSource = useFirstChangeAsBase ? secondProperties : firstProperties;
            HashSet<String> keys = new HashSet<String>();
            Enumeration<?> e = result.propertyNames();
            while (e.hasMoreElements()) {
                keys.add((String)e.nextElement());
            }
            for (String key : keys) {
                state = this.kindOfChange(key, baseProperties, result, otherSource);
                switch (state) {
                    case NONE: 
                    case ADDED_BY_US: 
                    case MODIFIED_BY_US: {
                        break;
                    }
                    case DELETED_BY_US: 
                    case BOTH_DELETED: 
                    case ADDED_BY_THEM: {
                        break;
                    }
                    case BOTH_ADDED: {
                        result.put(key, this.specialPropertyMerge(key, firstProperties, secondProperties));
                        break;
                    }
                    case BOTH_MODIFIED: {
                        if (secondProperties.getProperty(key) == null) {
                            result.remove(key);
                            break;
                        }
                        result.put(key, this.specialPropertyMerge(key, firstProperties, secondProperties));
                        break;
                    }
                    case DELETED_BY_THEM: {
                        result.remove(key);
                        break;
                    }
                    case MODIFIED_BY_THEM: {
                        result.put(key, otherSource.getProperty(key));
                    }
                }
            }
            keys.clear();
            e = otherSource.propertyNames();
            while (e.hasMoreElements()) {
                keys.add((String)e.nextElement());
            }
            e = result.propertyNames();
            while (e.hasMoreElements()) {
                String key;
                key = (String)e.nextElement();
                keys.remove(key);
            }
            for (String key : keys) {
                state = this.kindOfChange(key, baseProperties, result, otherSource);
                switch (state) {
                    case NONE: 
                    case ADDED_BY_US: 
                    case MODIFIED_BY_US: 
                    case DELETED_BY_US: 
                    case BOTH_DELETED: 
                    case BOTH_ADDED: 
                    case BOTH_MODIFIED: 
                    case DELETED_BY_THEM: {
                        break;
                    }
                    case ADDED_BY_THEM: 
                    case MODIFIED_BY_THEM: {
                        result.put(key, otherSource.getProperty(key));
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            result.store(baos, null);
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            Activator.log(1, null, "Problem resolving conflict: " + e.getMessage(), e, true);
            return null;
        }
    }

    protected String specialPropertyMerge(String key, Properties firstProperties, Properties secondProperties) {
        return (String)secondProperties.get(key);
    }

    private Change kindOfChange(String key, Properties baseProperties, Properties oursProperties, Properties theirsProperties) {
        String base = baseProperties.getProperty(key);
        String ours = oursProperties.getProperty(key);
        String theirs = theirsProperties.getProperty(key);
        if (base == null) {
            if (ours == null && theirs == null) {
                return Change.NONE;
            }
            if (ours != null && theirs != null) {
                return Change.BOTH_ADDED;
            }
            return ours == null ? Change.ADDED_BY_THEM : Change.ADDED_BY_US;
        }
        if (ours == null && theirs == null) {
            return Change.BOTH_DELETED;
        }
        if (ours == null) {
            return !theirs.equals(base) ? Change.BOTH_MODIFIED : Change.DELETED_BY_US;
        }
        if (theirs == null) {
            return !ours.equals(base) ? Change.BOTH_MODIFIED : Change.DELETED_BY_THEM;
        }
        if (ours.equals(base) && theirs.equals(base)) {
            return Change.NONE;
        }
        if (!ours.equals(base) && !theirs.equals(base)) {
            return Change.BOTH_MODIFIED;
        }
        return ours.equals(base) ? Change.MODIFIED_BY_THEM : Change.MODIFIED_BY_US;
    }

    private static enum Change {
        NONE,
        BOTH_DELETED,
        BOTH_ADDED,
        BOTH_MODIFIED,
        DELETED_BY_US,
        DELETED_BY_THEM,
        ADDED_BY_US,
        ADDED_BY_THEM,
        MODIFIED_BY_US,
        MODIFIED_BY_THEM;

    }
}

