/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javassist.scopedpool.ScopedClassPoolFactory;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectNotificationHandler;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aop.ClassicWeavingStrategy;
import org.jboss.aop.Deployment;
import org.jboss.aop.SuperClassesFirstWeavingStrategy;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.jboss4.JBoss4Integration;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.deployment.AspectManagerServiceMBean;
import org.jboss.aop.hook.JDK14Transformer;
import org.jboss.aop.hook.JDK14TransformerManager;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBeanSupport;

public class AspectManagerService
extends ServiceMBeanSupport
implements AspectManagerServiceMBean,
AspectNotificationHandler {
    Logger log = Logger.getLogger(AspectManagerService.class);
    public static final ObjectName DEFAULT_LOADER_REPOSITORY;
    boolean created = false;
    protected File tmpClassesDir;
    protected boolean enableTransformer = false;
    protected boolean enableLoadtimeWeaving = false;
    protected boolean suppressTransformationErrors = true;
    protected boolean suppressReferenceErrors = true;
    protected String exclude;
    protected String include;
    protected String ignore;
    protected String includedInvisibleAnnotations;
    private String baseXml = "base-aop.xml";
    boolean registerHappensAfterStart;
    boolean hasBeenStarted;
    private JBossIntegration integration;

    public AspectManagerService() {
        AspectManager manager = AspectManager.instance();
        AspectManager.maintainAdvisorMethodInterceptors = true;
    }

    public AspectManagerService(String baseXml) {
        this.baseXml = baseXml;
        this.registerHappensAfterStart = true;
    }

    public JBossIntegration getJBossIntegration() {
        return this.integration;
    }

    public void setJBossIntegration(JBossIntegration integration) {
        this.integration = integration;
    }

    protected ScopedClassPoolFactory createFactory() throws Exception {
        return this.initIntegration().createScopedClassPoolFactory(this.tmpClassesDir);
    }

    protected ClassLoaderValidation createClassLoaderValidation() {
        return this.initIntegration();
    }

    protected JBossIntegration initIntegration() {
        if (this.integration == null) {
            this.integration = new JBoss4Integration();
        }
        return this.integration;
    }

    protected void createService() throws Exception {
        this.initIntegration();
        if (this.hasBeenStarted) {
            return;
        }
        if (this.tmpClassesDir == null) {
            String jbossTmpDir = System.getProperty("jboss.server.temp.dir");
            if (jbossTmpDir == null) {
                jbossTmpDir = System.getProperty("java.io.tmpdir");
            }
            this.tmpClassesDir = new File(jbossTmpDir, "aopdynclasses");
        }
        if (!this.tmpClassesDir.exists() && !this.tmpClassesDir.mkdirs()) {
            throw new FileNotFoundException("Failed to create tmpClassesDir: " + this.tmpClassesDir.getAbsolutePath());
        }
        AspectManager.setClassPoolFactory((ScopedClassPoolFactory)this.createFactory());
        AspectManager.classLoaderValidator = this.createClassLoaderValidation();
        Deployment.searchClasspath = false;
        AspectManager.suppressTransformationErrors = this.suppressTransformationErrors;
        if (this.enableTransformer && this.enableLoadtimeWeaving) {
            throw new RuntimeException("Cannot set both EnableTransformer and EnableLoadtimeWeaving");
        }
        if (this.enableTransformer) {
            this.attachDeprecatedTranslator();
        }
        if (this.enableLoadtimeWeaving) {
            this.attachTranslator();
        }
        this.created = true;
        AspectManager.notificationHandler = this;
        AspectManager.setClassLoaderScopingPolicy((AOPClassLoaderScopingPolicy)this.integration.createAOPClassLoaderScopingPolicy());
        this.baseAop();
    }

    protected void baseAop() {
        if (this.baseXml == null) {
            return;
        }
        this.baseAop(this.baseXml);
    }

    public void baseAop(String xml) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL base = cl.getResource(xml);
        try {
            if (base != null) {
                AspectXmlLoader.deployXML((URL)base);
            } else {
                this.log.warn((Object)("Could not find " + xml + " file in the resources of " + cl));
            }
        }
        catch (Exception e) {
            System.out.println("Error loading " + xml + " file" + e);
        }
    }

    protected void attachDeprecatedTranslator() {
        this.log.warn((Object)"EnableTransformer has been deprecated, please use EnableLoadtimeWeaving.  See docs for more details");
        this.initIntegration().attachDeprecatedTranslator();
    }

    protected void detachDeprecatedTranslator() {
        this.initIntegration().detachDeprecatedTranslator();
    }

    protected void attachTranslator() {
        JDK14TransformerManager.transformer = new JDK14Transformer(){

            public byte[] transform(ClassLoader loader, String classname, byte[] classBytes) {
                try {
                    return AspectManager.instance((ClassLoader)loader).translate(classname, loader, classBytes);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error converting " + classname + " on " + loader, e);
                }
            }
        };
    }

    protected void detachTranslator() {
        JDK14TransformerManager.transformer = null;
    }

    public void attachClass(String classname) {
        Notification msg = new Notification("AOP class attached", this, this.getNextNotificationSequenceNumber());
        msg.setUserData(classname);
        this.sendNotification(msg);
    }

    public boolean getPrune() {
        return AspectManager.getPrune();
    }

    public void setPrune(boolean prune) {
        AspectManager.setPrune((boolean)prune);
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
        ArrayList<String> list = new ArrayList<String>();
        if (exclude != null) {
            StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        AspectManager.instance().setExclude(list);
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
        ArrayList<String> list = new ArrayList<String>();
        if (include != null) {
            StringTokenizer tokenizer = new StringTokenizer(include, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        AspectManager.instance().setInclude(list);
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
        ArrayList<String> list = new ArrayList<String>();
        if (ignore != null) {
            StringTokenizer tokenizer = new StringTokenizer(ignore, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        AspectManager.instance().setIgnore(list);
    }

    public String getIncludedInvisibleAnnotations() {
        return this.includedInvisibleAnnotations;
    }

    public void setIncludedInvisibleAnnotations(String ia) {
        ArrayList<String> iiaList = new ArrayList<String>();
        if (ia != null) {
            for (String inc : ia.split(",")) {
                iiaList.add(inc.trim());
            }
        }
        AspectManager.instance().setIncludedInvisibleAnnotations(iiaList);
    }

    public File getTmpClassesDir() {
        return this.tmpClassesDir;
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.tmpClassesDir = tmpClassesDir;
    }

    public boolean getVerbose() {
        return AspectManager.verbose;
    }

    public void setVerbose(boolean verbose) {
        AspectManager.verbose = verbose;
    }

    public boolean getOptimized() {
        return AspectManager.optimize;
    }

    public void setOptimized(boolean verbose) {
        AspectManager.optimize = verbose;
    }

    public boolean getSuppressTransformationErrors() {
        return this.suppressTransformationErrors;
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.suppressTransformationErrors = suppressTransformationErrors;
        AspectManager.suppressTransformationErrors = suppressTransformationErrors;
    }

    public boolean getSuppressReferenceErrors() {
        return this.suppressReferenceErrors;
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.suppressReferenceErrors = suppressReferenceErrors;
        AspectManager.suppressReferenceErrors = suppressReferenceErrors;
    }

    public boolean getEnableTransformer() {
        return this.enableTransformer;
    }

    public String interceptorFactories() {
        Map factories = AspectManager.instance().getInterceptorFactories();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String aspectDefinitions() {
        Map factories = AspectManager.instance().getAspectDefinitions();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String introductions() {
        Map factories = AspectManager.instance().getInterfaceIntroductions();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String stacks() {
        Map factories = AspectManager.instance().getInterceptorStacks();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String bindings() {
        LinkedHashMap factories = AspectManager.instance().getBindings();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String registeredClassLoaders() {
        Map loaders = AspectManager.getRegisteredCLs();
        StringBuffer buffer = new StringBuffer("");
        for (ClassLoader loader : loaders.keySet()) {
            buffer.append(loader + "<br>");
        }
        return buffer.toString();
    }

    public void setEnableTransformer(boolean enableTransformer) {
        if (this.enableLoadtimeWeaving) {
            this.log.warn((Object)"enabledLoadtimeWeaving alread set");
            return;
        }
        if (this.enableTransformer == enableTransformer) {
            return;
        }
        if (this.getState() == 3) {
            if (enableTransformer) {
                this.attachDeprecatedTranslator();
            } else {
                this.detachDeprecatedTranslator();
            }
        }
        this.enableTransformer = enableTransformer;
    }

    public boolean getEnableLoadtimeWeaving() {
        return this.enableLoadtimeWeaving;
    }

    public void setEnableLoadtimeWeaving(boolean enableTransformer) {
        if (this.enableLoadtimeWeaving == enableTransformer) {
            return;
        }
        if (this.getState() == 3) {
            if (enableTransformer) {
                this.attachTranslator();
            } else {
                this.detachTranslator();
            }
        }
        this.enableLoadtimeWeaving = enableTransformer;
    }

    public String getInstrumentor() {
        return InstrumentorFactory.getInstrumentorName();
    }

    public void setInstrumentor(String instrumentor) {
        InstrumentorFactory.initialise((String)instrumentor);
    }

    public void postRegister(Boolean done) {
        super.postRegister(done);
        if (this.registerHappensAfterStart) {
            try {
                super.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        Class<TransformerCommon> clazz = TransformerCommon.class;
        clazz = SuperClassesFirstWeavingStrategy.class;
        clazz = ClassicWeavingStrategy.class;
        Class<HeirarchicalLoaderRepository3> clazz2 = HeirarchicalLoaderRepository3.class;
        DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    }
}

