/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.AOPDomainRegistry;
import org.jboss.aop.asintegration.jboss5.ScopedVFSClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.plugins.jbosscl.VFSClassLoaderDomainRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyAOPVFSClassLoaderDomainRegistry
extends VFSClassLoaderDomainRegistry
implements AOPDomainRegistry {
    private Map<ClassLoader, ScopedVFSClassLoaderDomain> aopDomainsByClassLoader = new WeakHashMap<ClassLoader, ScopedVFSClassLoaderDomain>();
    private Map<ClassLoaderDomain, List<ScopedVFSClassLoaderDomain>> aopDomainsByClassLoaderDomain = new WeakHashMap<ClassLoaderDomain, List<ScopedVFSClassLoaderDomain>>();
    private Map<ClassLoaderDomain, ReadWriteLock> aopDomainsLocksByClassLoaderDomain = new WeakHashMap<ClassLoaderDomain, ReadWriteLock>();
    private ScopedVFSClassLoaderDomain initDomain = null;

    public List<ScopedVFSClassLoaderDomain> getAOPDomainsForClassLoaderDomain(ClassLoaderDomain domain) {
        List<ScopedVFSClassLoaderDomain> domains = this.aopDomainsByClassLoaderDomain.get(domain);
        if (domains != null) {
            return domains;
        }
        return Collections.emptyList();
    }

    public ReadWriteLock getAOPDomainsLockForClassLoaderDomain(ClassLoaderDomain domain) {
        return this.aopDomainsLocksByClassLoaderDomain.get(domain);
    }

    public synchronized Domain getRegisteredDomain(ClassLoader cl) {
        return (Domain)this.aopDomainsByClassLoader.get(cl);
    }

    public synchronized void setDomain(ScopedVFSClassLoaderDomain domain) {
        this.initDomain = domain;
    }

    protected void validateInitMaps(ClassLoader loader, ClassLoaderDomain loaderDomain, Module module, ClassLoader parentUnitLoader) {
        if (loaderDomain == null && this.initDomain != null) {
            throw new IllegalStateException("Have " + domain + " but no classloader domain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMapsDone(ClassLoader loader, ClassLoaderDomain loaderDomain, Module module, ClassLoader parentUnitLoader) {
        if (this.initDomain != null) {
            this.aopDomainsByClassLoader.put(loader, this.initDomain);
            ReadWriteLock lock = this.aopDomainsLocksByClassLoaderDomain.get(loaderDomain);
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                this.aopDomainsLocksByClassLoaderDomain.put(loaderDomain, lock);
            }
            lock.writeLock().lock();
            try {
                List<ScopedVFSClassLoaderDomain> aopDomains = this.aopDomainsByClassLoaderDomain.get(loaderDomain);
                if (aopDomains == null) {
                    Map<ClassLoaderDomain, List<ScopedVFSClassLoaderDomain>> map = this.aopDomainsByClassLoaderDomain;
                    synchronized (map) {
                        aopDomains = new CopyOnWriteArrayList<ScopedVFSClassLoaderDomain>();
                        if (!aopDomains.contains(loaderDomain)) {
                            this.aopDomainsByClassLoaderDomain.put(loaderDomain, aopDomains);
                        }
                    }
                }
                aopDomains.add(this.initDomain);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    public synchronized void cleanupLoaderDone(ClassLoader loader, ClassLoaderDomain loaderDomain, int domainReferences) {
        if (loaderDomain != null) {
            if (domainReferences == 0) {
                // empty if block
            }
            ScopedVFSClassLoaderDomain aopDomain = this.aopDomainsByClassLoader.remove(loader);
            List<ScopedVFSClassLoaderDomain> aopDomains = this.aopDomainsByClassLoaderDomain.get(loaderDomain);
            if (aopDomains != null) {
                aopDomains.remove(aopDomain);
            }
            if (aopDomain != null) {
                aopDomain.getParent().unsubscribeSubDomain((Domain)aopDomain);
            }
        }
        this.aopDomainsByClassLoader.remove(loader);
    }

    public static void main(String[] args) {
        LegacyAOPVFSClassLoaderDomainRegistry l = new LegacyAOPVFSClassLoaderDomainRegistry();
        System.out.println("Done");
    }
}

