/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;

class SecurityActions {
    private static final Method getClassLoader = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Method method = BaseClassLoaderSource.class.getDeclaredMethod("getClassLoader", new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot get classloader from " + BaseClassLoaderSource.class.getName(), e);
            }
        }
    });

    SecurityActions() {
    }

    public static ClassLoader getParent(ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            return GetParentAction.NON_PRIVILEGED.getParent(loader);
        }
        return GetParentAction.PRIVILEGED.getParent(loader);
    }

    static ClassLoader getClassLoader(BaseClassLoaderSource clSource) {
        try {
            return (ClassLoader)getClassLoader.invoke((Object)clSource, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static interface GetParentAction {
        public static final GetParentAction NON_PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(ClassLoader loader) {
                return loader.getParent();
            }
        };
        public static final GetParentAction PRIVILEGED = new GetParentAction(){

            public ClassLoader getParent(final ClassLoader loader) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            return loader.getParent();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
        };

        public ClassLoader getParent(ClassLoader var1);
    }
}

