/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import junit.framework.Test;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassLoaderWithPackageDependencySanityTestCase
extends JBossClClassPoolTest {
    public ClassLoaderWithPackageDependencySanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassLoaderWithPackageDependencySanityTestCase.suite(ClassLoaderWithPackageDependencySanityTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportNoVersionCheck() throws Exception {
        ClassLoader clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassLoader(rA, "A", builderA, JAR_A_1);
            Class<?> classA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                clB = this.createClassLoader(rB, "B", builderB, JAR_B_1);
                Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, classA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                Class<?> aFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(rB);
            Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, classA1);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertNoClassLoader(rA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheck() throws Exception {
        ClassLoader clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "1.0.0");
            clA = this.createClassLoader(rA, "A", builderA, JAR_A_1);
            Class<?> classA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
                clB = this.createClassLoader(rB, "B", builderB, JAR_B_1);
                Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, classA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                Class<?> aFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(rB);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertNoClassLoader(rA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheckFailed() throws Exception {
        ClassLoader clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "3.0.0");
            clA = this.createClassLoader(rA, "A", builderA, JAR_A_1);
            Class<?> classA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
                try {
                    this.createClassLoader(rB, "B", builderB, JAR_B_1);
                    ClassLoaderWithPackageDependencySanityTestCase.fail((String)"Should not have been able to create loader");
                }
                catch (JBossClClassPoolTest.NoSuchClassLoaderException expected) {
                    // empty catch block
                }
                Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, classA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            }
            finally {
                this.unregisterClassLoader("B");
            }
            Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA, classA1);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSamePackagesDifferentVersions() throws Exception {
        ClassLoader clA1 = null;
        ClassLoader clA2 = null;
        ClassLoader clA3 = null;
        Result rA1 = new Result();
        Result rA2 = new Result();
        Result rA3 = new Result();
        try {
            BundleInfoBuilder builderA1 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "1.0.0");
            clA1 = this.createClassLoader(rA1, "A1", builderA1, JAR_A_1);
            BundleInfoBuilder builderA2 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "2.0.0");
            clA2 = this.createClassLoader(rA2, "A2", builderA2, JAR_A_1);
            BundleInfoBuilder builderA3 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "3.0.0");
            clA3 = this.createClassLoader(rA3, "A3", builderA3, JAR_A_1);
            Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
            Class<?> classA2 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
            Class<?> classA3 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
            this.assertCannotLoadClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", false, (Object)"2.0.0", true));
                clB = this.createClassLoader(rB, "B", builderB, JAR_B_1);
                Class<?> classA11 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA1, classA11);
                Class<?> classA21 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA2, classA21);
                Class<?> classA31 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA3, classA31);
                this.assertCannotLoadClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                Class<?> classAFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA2);
                ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA2, classAFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(rB);
            Class<?> classA11 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
            ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA1, classA11);
            Class<?> classA21 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
            ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA2, classA21);
            Class<?> classA31 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
            ClassLoaderWithPackageDependencySanityTestCase.assertSame(classA3, classA31);
            this.assertCannotLoadClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA3);
            this.unregisterClassLoader(clA2);
            this.unregisterClassLoader(clA1);
            throw throwable;
        }
        this.unregisterClassLoader(clA3);
        this.unregisterClassLoader(clA2);
        this.unregisterClassLoader(clA1);
        this.assertNoClassLoader(rA1);
        this.assertNoClassLoader(rA2);
        this.assertNoClassLoader(rA3);
    }
}

