/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import junit.framework.Test;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassLoaderWithModuleDependencySanityTestCase
extends JBossClClassPoolTest {
    public ClassLoaderWithModuleDependencySanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassLoaderWithModuleDependencySanityTestCase.suite(ClassLoaderWithModuleDependencySanityTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportNoVersionCheck() throws Exception {
        ClassLoader clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassLoader(resultA, "A", builderA, JAR_A_1);
            Class<?> aFromA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA, clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createModule("ModuleB").createRequireModule("ModuleA");
                clB = this.createClassLoader(resultB, "B", builderB, JAR_B_1);
                Class<?> aFromA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA, clA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(aFromA, aFromA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                Class<?> aFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(aFromA, aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            Class<?> aFromA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(aFromA, aFromA1);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertNoClassLoader(resultB);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheck() throws Exception {
        ClassLoader clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA", "1.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassLoader(resultA, "A", builderA, JAR_A_1);
            Class<?> classA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"1.0.0", (Object)"2.0.0")).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassLoader(resultB, "B", builderB, JAR_B_1);
                Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classA, classA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classA, classA1);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(resultB);
            Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classA, classA1);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheckFailed() throws Exception {
        ClassLoader clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA", "3.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassLoader(resultA, "A", builderA, JAR_A_1);
            Class<?> classA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"1.0.0", (Object)"2.0.0")).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                try {
                    this.createClassLoader(resultB, "B", builderB, JAR_B_1);
                    ClassLoaderWithModuleDependencySanityTestCase.fail((String)"Should not have been able to create loader");
                }
                catch (JBossClClassPoolTest.NoSuchClassLoaderException expected) {
                    // empty catch block
                }
                Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classA, classA1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertNoClassLoader(resultB);
            }
            finally {
                this.unregisterClassLoader("B");
            }
            this.assertNoClassLoader(resultB);
            Class<?> classA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classA, classA1);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSamePackages() throws Exception {
        ClassLoader clAModuleX = null;
        ClassLoader clAModuleA = null;
        ClassLoader clAModuleY = null;
        Result rAX = new Result();
        Result rAA = new Result();
        Result rAY = new Result();
        try {
            BundleInfoBuilder builderAX = BundleInfoBuilder.getBuilder().createModule("ModuleX").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleX = this.createClassLoader(rAX, "X", builderAX, JAR_A_1);
            BundleInfoBuilder builderAA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA = this.createClassLoader(rAA, "A", builderAA, JAR_A_1);
            BundleInfoBuilder builderAY = BundleInfoBuilder.getBuilder().createModule("ModuleY").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleY = this.createClassLoader(rAY, "Y", builderAY, JAR_A_1);
            Class<?> classAX = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
            Class<?> classAA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
            Class<?> classAY = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
            this.assertCannotLoadClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassLoader(resultB, "B", builderB, JAR_B_1);
                Class<?> classAX1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAX, classAX1);
                Class<?> classAA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAA, classAA1);
                Class<?> classAY1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAY, classAY1);
                this.assertCannotLoadClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                Class<?> aFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clAModuleA);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(aFromB, classAA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(resultB);
            Class<?> classAX1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAX, classAX1);
            Class<?> classAA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAA, classAA1);
            Class<?> classAY1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAY, classAY1);
            this.assertCannotLoadClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clAModuleY);
            this.unregisterClassLoader(clAModuleA);
            this.unregisterClassLoader(clAModuleX);
            throw throwable;
        }
        this.unregisterClassLoader(clAModuleY);
        this.unregisterClassLoader(clAModuleA);
        this.unregisterClassLoader(clAModuleX);
        this.assertNoClassLoader(rAY);
        this.assertNoClassLoader(rAA);
        this.assertNoClassLoader(rAX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSameNamesDifferentVersions() throws Exception {
        ClassLoader clAModuleA1 = null;
        ClassLoader clAModuleA2 = null;
        ClassLoader clAModuleA3 = null;
        Result rA1 = new Result();
        Result rA2 = new Result();
        Result rA3 = new Result();
        try {
            BundleInfoBuilder builderA1 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "1.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA1 = this.createClassLoader(rA1, "X", builderA1, JAR_A_1);
            BundleInfoBuilder builderA2 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "2.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA2 = this.createClassLoader(rA2, "A", builderA2, JAR_A_1);
            BundleInfoBuilder builderA3 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "3.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA3 = this.createClassLoader(rA3, "Y", builderA3, JAR_A_1);
            Class<?> classAX = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
            Class<?> classAA = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
            Class<?> classAY = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
            this.assertCannotLoadClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoader clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"2.0.0", true, (Object)"3.0.0", false)).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassLoader(rB, "B", builderB, JAR_B_1);
                Class<?> classAX1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAX, classAX1);
                Class<?> classAA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAA, classAA1);
                Class<?> classAY1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAY, classAY1);
                this.assertCannotLoadClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                Class<?> aFromB = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clAModuleA2);
                ClassLoaderWithModuleDependencySanityTestCase.assertSame(aFromB, classAA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertNoClassLoader(rB);
            Class<?> classAX1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAX, classAX1);
            Class<?> classAA1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAA, classAA1);
            Class<?> classAY1 = this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
            ClassLoaderWithModuleDependencySanityTestCase.assertSame(classAY, classAY1);
            this.assertCannotLoadClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clAModuleA3);
            this.unregisterClassLoader(clAModuleA2);
            this.unregisterClassLoader(clAModuleA1);
            throw throwable;
        }
        this.unregisterClassLoader(clAModuleA3);
        this.unregisterClassLoader(clAModuleA2);
        this.unregisterClassLoader(clAModuleA1);
        this.assertNoClassLoader(rA1);
        this.assertNoClassLoader(rA2);
        this.assertNoClassLoader(rA3);
    }
}

