/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.integration.complex.test;

import java.net.URL;
import junit.framework.Test;
import org.jboss.aop.integration.junit.WovenAOPIntegrationTest;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.test.support.MockClassLoaderHelper;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;

public class ComplexImportMultipleVersionsUnitTestCase
extends WovenAOPIntegrationTest {
    private static String PACKAGE_SUPPORT = "org.jboss.test.aop.integration.complex.support";
    private static String PACKAGE_A = PACKAGE_SUPPORT + ".a";
    private static String CLASS_A = PACKAGE_A + ".A";

    public static Test suite() {
        return ComplexImportMultipleVersionsUnitTestCase.suite(ComplexImportMultipleVersionsUnitTestCase.class);
    }

    public ComplexImportMultipleVersionsUnitTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiVersion() throws Exception {
        MockClassLoaderPolicy support1Policy = MockClassLoaderHelper.createMockClassLoaderPolicy((String)"Support1");
        support1Policy.setPathsAndPackageNames(new String[]{PACKAGE_SUPPORT});
        ClassLoader support1 = ComplexImportMultipleVersionsUnitTestCase.createClassLoader(support1Policy);
        try {
            MockClassLoaderPolicy a1Policy = MockClassLoaderHelper.createMockClassLoaderPolicy((String)"A1");
            a1Policy.setPathsAndPackageNames(new String[]{PACKAGE_A});
            a1Policy.setDelegates(this.createDelegates(new ClassLoaderPolicy[]{support1Policy}));
            ClassLoader a1 = ComplexImportMultipleVersionsUnitTestCase.createClassLoader(a1Policy);
            try {
                URL url1 = this.deploy("1", a1);
                try {
                    MockClassLoaderPolicy support2Policy = MockClassLoaderHelper.createMockClassLoaderPolicy((String)"Support2");
                    support2Policy.setPathsAndPackageNames(new String[]{PACKAGE_SUPPORT});
                    ClassLoader support2 = ComplexImportMultipleVersionsUnitTestCase.createClassLoader(support2Policy);
                    try {
                        MockClassLoaderPolicy a2Policy = MockClassLoaderHelper.createMockClassLoaderPolicy((String)"A2");
                        a2Policy.setPathsAndPackageNames(new String[]{PACKAGE_A});
                        a2Policy.setDelegates(this.createDelegates(new ClassLoaderPolicy[]{support2Policy}));
                        ClassLoader a2 = ComplexImportMultipleVersionsUnitTestCase.createClassLoader(a2Policy);
                        System.out.println("--------------> Support1\t" + support1);
                        System.out.println("--------------> A1\t\t" + a1);
                        System.out.println("--------------> Support2\t" + support2);
                        System.out.println("--------------> A2\t\t" + a2);
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.test.aop.integration.complex.support.TestInterceptor");
                        System.out.println("====== " + clazz + " " + clazz.getClassLoader());
                        Class<?> clazz1 = a1.loadClass("org.jboss.test.aop.integration.complex.support.TestInterceptor");
                        System.out.println("====== " + clazz1 + " " + clazz1.getClassLoader());
                        Class<?> clazz2 = a2.loadClass("org.jboss.test.aop.integration.complex.support.TestInterceptor");
                        System.out.println("====== " + clazz2 + " " + clazz2.getClassLoader());
                        try {
                            URL url2 = this.deploy("2", a2);
                            try {
                                Class<?> classA1 = a1.loadClass(CLASS_A);
                                Object instanceA1 = classA1.newInstance();
                                Class<?> classA2 = a2.loadClass(CLASS_A);
                                ComplexImportMultipleVersionsUnitTestCase.assertNotSame(classA2, classA1);
                                classA2.newInstance();
                            }
                            finally {
                                this.undeploy(url2);
                            }
                        }
                        finally {
                            ComplexImportMultipleVersionsUnitTestCase.unregisterClassLoader(a2);
                        }
                    }
                    finally {
                        ComplexImportMultipleVersionsUnitTestCase.unregisterClassLoader(support2);
                    }
                }
                finally {
                    this.undeploy(url1);
                }
            }
            finally {
                ComplexImportMultipleVersionsUnitTestCase.unregisterClassLoader(a1);
            }
        }
        finally {
            ComplexImportMultipleVersionsUnitTestCase.unregisterClassLoader(support1);
        }
    }
}

