/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import junit.framework.Test;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassLoaderWithRepositorySanityTestCase
extends JBossClClassPoolTest {
    public ClassLoaderWithRepositorySanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassLoaderWithRepositorySanityTestCase.suite(ClassLoaderWithRepositorySanityTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobalScope() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        try {
            Class<?> aFromA;
            clA = this.createClassLoader("A", true, JAR_A_1);
            this.assertModule(clA);
            clB = this.createClassLoader("B", true, JAR_B_1);
            this.assertModule(clB);
            try {
                aFromA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
                ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromA);
                Class<?> bFromA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassLoaderWithRepositorySanityTestCase.assertNotNull(bFromA);
                Class<?> aFromB = clB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
                Class<?> bFromB = clB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassLoaderWithRepositorySanityTestCase.assertSame(aFromA, aFromB);
                ClassLoaderWithRepositorySanityTestCase.assertSame(bFromA, bFromB);
                ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clA, (Object)aFromA.getClassLoader());
                ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clB, (Object)bFromB.getClassLoader());
            }
            finally {
                this.unregisterClassLoader(clB);
            }
            aFromA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.assertCannotLoadClass(this.getDefaultDomain(), "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildDomain() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        ClassLoaderDomain childDomain = null;
        ClassLoader clC = null;
        try {
            clA = this.createClassLoader("A", true, JAR_A_1);
            this.assertModule(clA);
            clB = this.createClassLoader("B", true, JAR_B_2);
            this.assertModule(clB);
            clC = this.createChildDomainParentFirstClassLoader("C", "CHILD", true, JAR_C_1);
            this.assertModule(clC);
            childDomain = this.getChildDomainForLoader(clC);
            ClassLoaderWithRepositorySanityTestCase.assertNotNull((Object)childDomain);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)ClassLoaderWithRepositorySanityTestCase.getSystem().getDefaultDomain(), (Object)childDomain.getParent());
            Class<?> aFromA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromA);
            Class<?> bFromB = clB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(bFromB);
            Class<?> cFromC = clC.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(cFromC);
            Class<?> aFromC = clC.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromC);
            Class<?> bFromC = clC.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(bFromC);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromA, aFromC);
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFromB, bFromC);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clA, (Object)aFromA.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clB, (Object)bFromB.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clC, (Object)cFromC.getClassLoader());
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            this.assertCannotLoadClass(clB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            this.unregisterClassLoader(clB);
            this.unregisterClassLoader(clC);
            this.unregisterDomain(childDomain);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.unregisterClassLoader(clB);
        this.unregisterClassLoader(clC);
        this.unregisterDomain(childDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSiblingDomains() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        ClassLoaderDomain domainA = null;
        ClassLoaderDomain domainB = null;
        try {
            clA = this.createChildDomainParentFirstClassLoader("A", "ChildA", true, JAR_A_1);
            this.assertModule(clA);
            clB = this.createChildDomainParentLastClassLoader("B", "ChildB", true, JAR_B_1);
            this.assertModule(clB);
            domainA = this.getChildDomainForLoader(clA);
            ClassLoaderWithRepositorySanityTestCase.assertNotNull((Object)domainA);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)ClassLoaderWithRepositorySanityTestCase.getSystem().getDefaultDomain(), (Object)domainA.getParent());
            domainB = this.getChildDomainForLoader(clB);
            ClassLoaderWithRepositorySanityTestCase.assertNotNull((Object)domainB);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)ClassLoaderWithRepositorySanityTestCase.getSystem().getDefaultDomain(), (Object)domainB.getParent());
            ClassLoaderWithRepositorySanityTestCase.assertNotSame((Object)domainA, (Object)domainB);
            Class<?> clazzA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clA, (Object)clazzA.getClassLoader());
            Class<?> clazzB = clB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clB, (Object)clazzB.getClassLoader());
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadClass(clB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            this.unregisterClassLoader(clB);
            this.unregisterDomain(clA);
            this.unregisterDomain(clB);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
        this.unregisterClassLoader(clB);
        this.unregisterDomain(clA);
        this.unregisterDomain(clB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildWithNewClassesInParent() throws Exception {
        ClassLoader clGlobal = null;
        ClassLoader clScoped = null;
        try {
            clScoped = this.createChildDomainParentFirstClassLoader("SCOPED", "SCOPED", true, JAR_B_1);
            this.assertModule(clScoped);
            this.assertCannotLoadClass(clScoped, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            clGlobal = this.createClassLoader("GLOBAL", true, JAR_A_1);
            this.assertModule(clScoped);
            this.assertModule(clGlobal);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromChild);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromParent);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromChild, aFromParent);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clGlobal);
            this.unregisterClassLoader(clScoped);
            this.unregisterDomain(clScoped);
            throw throwable;
        }
        this.unregisterClassLoader(clGlobal);
        this.unregisterClassLoader(clScoped);
        this.unregisterDomain(clScoped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithParentDelegation() throws Exception {
        ClassLoader clGlobal = null;
        ClassLoader clScoped = null;
        try {
            clGlobal = this.createClassLoader("GLOBAL", true, JAR_A_1);
            clScoped = this.createChildDomainParentFirstClassLoader("SCOPED", "SCOPED", true, JAR_B_1);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromParent);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromChild);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFromChild);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clGlobal);
            this.unregisterClassLoader(clScoped);
            this.unregisterDomain(clScoped);
            throw throwable;
        }
        this.unregisterClassLoader(clGlobal);
        this.unregisterClassLoader(clScoped);
        this.unregisterDomain(clScoped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithNoParentDelegation() throws Exception {
        ClassLoader clGlobal = null;
        ClassLoader clScoped = null;
        try {
            clGlobal = this.createClassLoader("GLOBAL", true, JAR_A_1);
            clScoped = this.createChildDomainParentLastClassLoader("CHILD", "CHILD", true, JAR_A_1);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromParent);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotNull(aFromChild);
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(aFromParent, aFromChild);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clScoped, (Object)aFromChild.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clGlobal);
            this.unregisterClassLoader(clScoped);
            this.unregisterDomain(clScoped);
            throw throwable;
        }
        this.unregisterClassLoader(clGlobal);
        this.unregisterClassLoader(clScoped);
        this.unregisterDomain(clScoped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUcl() throws Exception {
        ClassLoader clGlobal = null;
        ClassLoader clChildA = null;
        ClassLoader clChildB = null;
        try {
            clGlobal = this.createClassLoader("GLOBAL", true, JAR_A_1);
            clChildA = this.createChildURLClassLoader(clGlobal, JAR_B_1);
            Class<?> aFromA = clChildA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clGlobal, (Object)aFromA.getClassLoader());
            Class<?> bFromA = clChildA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clChildA, (Object)bFromA.getClassLoader());
            clChildB = this.createChildURLClassLoader(clGlobal, JAR_A_2);
            Class<?> aFromB = clChildB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clGlobal, (Object)aFromB.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clGlobal);
            this.unregisterClassLoader(clChildA);
            this.unregisterClassLoader(clChildB);
            throw throwable;
        }
        this.unregisterClassLoader(clGlobal);
        this.unregisterClassLoader(clChildA);
        this.unregisterClassLoader(clChildB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeploySibling() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        try {
            try {
                clA = this.createClassLoader("A", true, JAR_A_1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                clB = this.createClassLoader("B", true, JAR_B_1);
                Class<?> bFromA = clA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassLoaderWithRepositorySanityTestCase.assertSame((Object)clB, (Object)bFromA.getClassLoader());
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clA);
            throw throwable;
        }
        this.unregisterClassLoader(clA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeployParentDomainClassLoader() throws Exception {
        ClassLoader globalA = null;
        ClassLoader globalB = null;
        ClassLoader child = null;
        try {
            try {
                globalA = this.createClassLoader("A", true, JAR_A_1);
                this.assertCannotLoadClass(globalA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                child = this.createChildDomainParentLastClassLoader("C", "C", true, JAR_C_1);
                this.assertCannotLoadClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                globalB = this.createClassLoader("B", true, JAR_B_1);
                Class<?> bFromChild = child.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                Class<?> bFromA = globalA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassLoaderWithRepositorySanityTestCase.assertSame((Object)globalB, (Object)bFromA.getClassLoader());
                ClassLoaderWithRepositorySanityTestCase.assertSame(bFromA, bFromChild);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(globalB);
                throw throwable;
            }
            this.unregisterClassLoader(globalB);
            this.assertCannotLoadClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(globalA);
            this.unregisterClassLoader(child);
            this.unregisterDomain(this.getChildDomainForLoader(child));
            throw throwable;
        }
        this.unregisterClassLoader(globalA);
        this.unregisterClassLoader(child);
        this.unregisterDomain(this.getChildDomainForLoader(child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassLoaderlWithParentClassLoader() throws Exception {
        ClassLoader parent = this.createChildURLClassLoader(null, JAR_B_1);
        ClassLoader global = null;
        try {
            global = this.createChildDomainParentFirstClassLoader("A", "A", true, parent, JAR_A_1);
            Class<?> aFromGlobal = global.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)global, (Object)aFromGlobal.getClassLoader());
            Class<?> bFromGlobal = global.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)parent, (Object)bFromGlobal.getClassLoader());
            Class<?> bFromParent = parent.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFromGlobal, bFromParent);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(global);
            this.unregisterClassLoader(parent);
            this.unregisterDomain(global);
            throw throwable;
        }
        this.unregisterClassLoader(global);
        this.unregisterClassLoader(parent);
        this.unregisterDomain(global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassLoaderWithParentClassLoaderAndSameClassInDomain() throws Exception {
        ClassLoader parent = this.createChildURLClassLoader(null, JAR_B_1);
        ClassLoader globalA = null;
        ClassLoader globalB = null;
        ClassLoader globalC = null;
        try {
            String domain = "CHILD";
            globalA = this.createChildDomainParentFirstClassLoader("A", "CHILD", true, parent, JAR_A_1);
            Class<?> aFromGlobal = globalA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)globalA, (Object)aFromGlobal.getClassLoader());
            Class<?> bFromGlobalA = globalA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)parent, (Object)bFromGlobalA.getClassLoader());
            globalB = this.createChildDomainParentFirstClassLoader("B", "CHILD", true, parent, JAR_B_2);
            Class<?> bFromParent = parent.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)parent, (Object)bFromParent.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFromGlobalA, bFromParent);
            Class<?> bFromGlobalB = globalB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFromGlobalB, bFromParent);
            globalC = this.createChildDomainParentLastClassLoader("C", "CHILD2", true, parent, JAR_B_2);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", globalC);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(globalA);
            this.unregisterClassLoader(globalB);
            this.unregisterClassLoader(globalC);
            this.unregisterClassLoader(parent);
            this.unregisterDomain(globalA);
            this.unregisterDomain(globalC);
            throw throwable;
        }
        this.unregisterClassLoader(globalA);
        this.unregisterClassLoader(globalB);
        this.unregisterClassLoader(globalC);
        this.unregisterClassLoader(parent);
        this.unregisterDomain(globalA);
        this.unregisterDomain(globalC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralLevelsOfDomain() throws Exception {
        ClassLoader parent = null;
        ClassLoader cl1B = null;
        ClassLoader cl1C = null;
        ClassLoader cl2B = null;
        ClassLoader cl2C = null;
        ClassLoader cl11A = null;
        ClassLoader cl11B = null;
        ClassLoader cl11C = null;
        ClassLoader cl12A = null;
        ClassLoader cl12B = null;
        ClassLoader cl12C = null;
        try {
            parent = this.createClassLoader("A", true, JAR_A_1);
            Class<?> aFromParent = parent.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)parent, (Object)aFromParent.getClassLoader());
            String domain1 = "1";
            cl1B = this.createChildDomainParentFirstClassLoader("1B", "1", true, JAR_B_1);
            cl1C = this.createChildDomainParentFirstClassLoader("1C", "1", true, JAR_C_1);
            Class<?> aFrom1B = cl1B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> bFrom1B = cl1B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom1B = cl1B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> aFrom1C = cl1C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> bFrom1C = cl1C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom1C = cl1C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom1B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom1C);
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom1B, bFrom1C);
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom1B, cFrom1C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl1B, (Object)bFrom1B.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl1C, (Object)cFrom1B.getClassLoader());
            String domain2 = "2";
            cl2B = this.createChildDomainParentFirstClassLoader("2B", "2", true, JAR_B_1);
            cl2C = this.createChildDomainParentFirstClassLoader("2C", "2", true, JAR_C_1);
            Class<?> aFrom2B = cl2B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> bFrom2B = cl2B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom2B = cl2B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> aFrom2C = cl2C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> bFrom2C = cl2C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom2C = cl2C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom2B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom2C);
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom2B, bFrom2C);
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom2B, cFrom2C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl2B, (Object)bFrom2B.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl2C, (Object)cFrom2B.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(bFrom1B, bFrom2B);
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(bFrom2C, bFrom1C);
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(cFrom2C, cFrom1C);
            String domain11 = "11";
            cl11A = this.createChildDomainParentFirstClassLoader("11A", "11", "1", true, JAR_A_2);
            cl11B = this.createChildDomainParentFirstClassLoader("11B", "11", "1", true, JAR_B_2);
            cl11C = this.createChildDomainParentFirstClassLoader("11C", "11", "1", true, JAR_C_2);
            String domain12 = "12";
            cl12A = this.createChildDomainParentLastClassLoader("12A", "12", "1", true, JAR_A_2);
            cl12B = this.createChildDomainParentLastClassLoader("12B", "12", "1", true, JAR_B_2);
            cl12C = this.createChildDomainParentLastClassLoader("12C", "12", "1", true, JAR_C_2);
            Class<?> aFrom11A = cl11A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFrom11B = cl11B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFrom11C = cl11C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom11A);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom11B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromParent, aFrom11C);
            Class<?> aFrom12A = cl12A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFrom12B = cl12B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFrom12C = cl12C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(aFromParent, aFrom12A);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFrom12A, aFrom12B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFrom12A, aFrom12C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl12A, (Object)aFrom12A.getClassLoader());
            Class<?> bFrom11A = cl11A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> bFrom11B = cl11B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> bFrom11C = cl11C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom11A = cl11A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> cFrom11B = cl11B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> cFrom11C = cl11C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom11A, bFrom11B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom11A, bFrom11C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl1B, (Object)bFrom11B.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom11A, cFrom11B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom11A, cFrom11C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl1C, (Object)cFrom11C.getClassLoader());
            Class<?> bFrom12A = cl12A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> bFrom12B = cl12B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> bFrom12C = cl12C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Class<?> cFrom12A = cl12A.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> cFrom12B = cl12B.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            Class<?> cFrom12C = cl12C.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom12A, bFrom12B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(bFrom12A, bFrom12C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl12B, (Object)bFrom12B.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom12A, cFrom12B);
            ClassLoaderWithRepositorySanityTestCase.assertSame(cFrom12A, cFrom12C);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)cl12C, (Object)cFrom12C.getClassLoader());
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(bFrom11B, bFrom12B);
            ClassLoaderWithRepositorySanityTestCase.assertNotSame(cFrom11C, cFrom12C);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(parent);
            this.unregisterClassLoader(cl1B);
            this.unregisterClassLoader(cl1C);
            this.unregisterClassLoader(cl2B);
            this.unregisterClassLoader(cl2C);
            this.unregisterClassLoader(cl11A);
            this.unregisterClassLoader(cl11B);
            this.unregisterClassLoader(cl11C);
            this.unregisterClassLoader(cl12A);
            this.unregisterClassLoader(cl12B);
            this.unregisterClassLoader(cl12C);
            this.unregisterDomain(cl12A);
            this.unregisterDomain(cl11A);
            this.unregisterDomain(cl2B);
            this.unregisterDomain(cl1B);
            throw throwable;
        }
        this.unregisterClassLoader(parent);
        this.unregisterClassLoader(cl1B);
        this.unregisterClassLoader(cl1C);
        this.unregisterClassLoader(cl2B);
        this.unregisterClassLoader(cl2C);
        this.unregisterClassLoader(cl11A);
        this.unregisterClassLoader(cl11B);
        this.unregisterClassLoader(cl11C);
        this.unregisterClassLoader(cl12A);
        this.unregisterClassLoader(cl12B);
        this.unregisterClassLoader(cl12C);
        this.unregisterDomain(cl12A);
        this.unregisterDomain(cl11A);
        this.unregisterDomain(cl2B);
        this.unregisterDomain(cl1B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclLoaderOrdering() throws Exception {
        ClassLoader globalA = null;
        ClassLoader globalB = null;
        ClassLoader globalC = null;
        try {
            globalA = this.createClassLoader("A1", true, JAR_A_1);
            globalB = this.createClassLoader("A2", true, JAR_A_1);
            globalC = this.createClassLoader("A3", true, JAR_A_1);
            Class<?> aFromA = globalA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFromB = globalB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            Class<?> aFromC = globalC.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromA, aFromB);
            ClassLoaderWithRepositorySanityTestCase.assertSame(aFromA, aFromC);
            ClassLoaderWithRepositorySanityTestCase.assertSame((Object)globalA, (Object)aFromA.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(globalA);
            this.unregisterClassLoader(globalB);
            this.unregisterClassLoader(globalC);
            throw throwable;
        }
        this.unregisterClassLoader(globalA);
        this.unregisterClassLoader(globalB);
        this.unregisterClassLoader(globalC);
    }
}

