/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.support;

import java.io.Closeable;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.util.id.GUID;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class TestVFSClassLoaderPolicyModule
extends VFSClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    URL dynamicClassRoot;
    VirtualFile classes;
    Closeable tempDirectoryHandle;

    public TestVFSClassLoaderPolicyModule(VFSClassLoaderFactory classLoadingMetaData, String contextName) {
        super(classLoadingMetaData, contextName);
    }

    public URL getDynamicClassRoot() {
        this.initDynamicClassRoot();
        return this.dynamicClassRoot;
    }

    protected VirtualFile[] determineVFSRoots() {
        this.initDynamicClassRoot();
        VirtualFile[] roots = super.determineVFSRoots();
        VirtualFile[] newRoots = new VirtualFile[roots.length + 1];
        newRoots[0] = this.classes;
        System.arraycopy(roots, 0, newRoots, 1, roots.length);
        return newRoots;
    }

    private synchronized void initDynamicClassRoot() {
        if (this.dynamicClassRoot == null) {
            try {
                this.classes = VFS.getChild((String)("/" + GUID.asString()));
                this.tempDirectoryHandle = VFS.mountTemp((VirtualFile)this.classes, (TempFileProvider)TempFileProvider.create((String)"classes", (ScheduledExecutorService)Executors.newScheduledThreadPool(2)));
                this.dynamicClassRoot = this.classes.toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void reset() {
        super.reset();
        VFSUtils.safeClose((Closeable)this.tempDirectoryHandle);
    }
}

