/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss5.AopMetaDataDeployerOutput;
import org.jboss.aop.microcontainer.beans.metadata.AspectManagerAwareBeanMetaDataFactory;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAopMetaDataDeployer<T>
extends AbstractSimpleVFSRealDeployer<T> {
    private AspectManager aspectManager;
    private KernelController controller;
    private MyBeanMetaDataDeployer beanMetaDataDeployer = new MyBeanMetaDataDeployer();
    private static int sequence;

    public AbstractAopMetaDataDeployer(Class<T> input) {
        super(input);
        super.setStage(DeploymentStages.POST_CLASSLOADER);
        super.setOutput(AopMetaDataDeployerOutput.class);
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    public void setAspectManager(AspectManager aspectManager) {
        this.aspectManager = aspectManager;
    }

    public void setKernel(Kernel kernel) {
        this.controller = kernel.getController();
    }

    public void deploy(VFSDeploymentUnit unit, T deployment) throws DeploymentException {
        this.log.debug((Object)("Deploying " + unit + " " + deployment));
        AopMetaDataDeployerOutput output = new AopMetaDataDeployerOutput();
        unit.addAttachment(AopMetaDataDeployerOutput.class, (Object)output);
        if (this.extractAopBeanMetaDataFactories(unit, deployment, output)) {
            AspectManager correctManager = (AspectManager)unit.getAttachment(AspectManager.class);
            this.log.debug((Object)("Got AspectManager attachment " + correctManager + " for " + unit));
            if (correctManager != this.aspectManager) {
                int sequence = this.getSequence();
                String scopedManagerName = this.registerScopedManagerBean(sequence, unit, correctManager, output);
                this.massageScopedDeployment(sequence, unit, deployment, output, scopedManagerName);
            }
        }
        try {
            this.deployBeans(unit, output);
        }
        catch (Throwable t) {
            this.unregisterScopedManagerBean(output.getScopedAspectManagerBeanName(), false);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(t);
        }
        this.log.debug((Object)("Finished deploying " + unit));
    }

    public void undeploy(VFSDeploymentUnit unit, T deployment) {
        this.log.debug((Object)("Undeploying " + unit + " " + deployment));
        AopMetaDataDeployerOutput output = (AopMetaDataDeployerOutput)unit.getAttachment(AopMetaDataDeployerOutput.class);
        this.undeployBeans(unit, output);
    }

    protected abstract List<BeanMetaDataFactory> getFactories(T var1);

    private boolean extractAopBeanMetaDataFactories(VFSDeploymentUnit unit, T deployment, AopMetaDataDeployerOutput output) {
        this.log.debug((Object)("Extracting aop bean metadata factories for  " + unit));
        ArrayList<AspectManagerAwareBeanMetaDataFactory> aopFactories = new ArrayList<AspectManagerAwareBeanMetaDataFactory>();
        List<BeanMetaDataFactory> factories = this.getFactories(deployment);
        if (factories != null && factories.size() > 0) {
            Iterator<BeanMetaDataFactory> it = factories.iterator();
            while (it.hasNext()) {
                BeanMetaDataFactory factory = it.next();
                if (!(factory instanceof AspectManagerAwareBeanMetaDataFactory)) continue;
                it.remove();
                aopFactories.add((AspectManagerAwareBeanMetaDataFactory)factory);
            }
        }
        if (aopFactories.size() > 0) {
            output.setFactories(aopFactories);
            return true;
        }
        return false;
    }

    private String registerScopedManagerBean(int sequence, VFSDeploymentUnit unit, AspectManager scopedManager, AopMetaDataDeployerOutput output) throws DeploymentException {
        String name = "ScopedManager_" + this.getSequence() + "_" + unit.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)scopedManager.getClass().getName());
        unit.getMutableMetaData().addMetaData((Object)scopedManager, AspectManager.class);
        try {
            this.controller.install(builder.getBeanMetaData(), (Object)scopedManager);
            return name;
        }
        catch (Throwable e) {
            throw new DeploymentException("Error registering scoped manager" + name + " " + scopedManager, e);
        }
    }

    private synchronized int getSequence() {
        return ++sequence;
    }

    private void unregisterScopedManagerBean(String name, boolean logError) {
        block3: {
            if (name == null) {
                return;
            }
            try {
                this.controller.uninstall((Object)name);
            }
            catch (Throwable t) {
                if (!logError) break block3;
                this.log.debug((Object)("Error unregistering scoped aspect manager " + name), t);
            }
        }
    }

    private void massageScopedDeployment(int sequence, VFSDeploymentUnit unit, T deployment, AopMetaDataDeployerOutput output, String scopedManagerName) throws DeploymentException {
        this.log.debug((Object)("Massaging scoped deployment " + unit + " setting manager to " + scopedManagerName));
        String domainName = this.getDomainName(unit);
        output.setScopedInformation(scopedManagerName, domainName, sequence);
        unit.getMutableMetaData().addAnnotation((Annotation)output.getScopeAnnotation());
    }

    private String getDomainName(VFSDeploymentUnit unit) {
        Module module = (Module)unit.getTopLevel().getAttachment(Module.class);
        if (module != null && !module.getDeterminedDomainName().equals("DefaultDomain")) {
            return module.getDeterminedDomainName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployBeans(VFSDeploymentUnit unit, AopMetaDataDeployerOutput output) throws DeploymentException {
        List<BeanMetaData> aopBeans = output.getBeans();
        ArrayList<BeanMetaData> done = new ArrayList<BeanMetaData>();
        try {
            if (aopBeans != null && aopBeans.size() > 0) {
                for (BeanMetaData bean : aopBeans) {
                    FakeComponentUnit componentUnit = this.deployComponentDeploymentContext(unit, bean);
                    try {
                        this.beanMetaDataDeployer.deploy(componentUnit, bean);
                        done.add(bean);
                    }
                    finally {
                        this.undeployComponentDeploymentContext(componentUnit, bean);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (int i = done.size() - 1; i >= 0; --i) {
                try {
                    this.beanMetaDataDeployer.undeploy((DeploymentUnit)unit, (BeanMetaData)done.get(i));
                    this.controller.uninstall(done.get(i));
                    continue;
                }
                catch (Throwable e) {
                    this.log.debug((Object)("Error undeploying " + done.get(i) + " for " + unit));
                }
            }
            throw new DeploymentException(t);
        }
    }

    private void undeployBeans(VFSDeploymentUnit unit, AopMetaDataDeployerOutput output) {
        List<BeanMetaData> aopBeans;
        if (output != null && (aopBeans = output.getBeans()) != null && aopBeans.size() > 0) {
            for (int i = aopBeans.size() - 1; i >= 0; --i) {
                BeanMetaData bean = aopBeans.get(i);
                this.beanMetaDataDeployer.undeploy((DeploymentUnit)unit, bean);
            }
        }
    }

    private FakeComponentUnit deployComponentDeploymentContext(VFSDeploymentUnit unit, BeanMetaData deployment) {
        return new FakeComponentUnit(unit, deployment);
    }

    private void undeployComponentDeploymentContext(FakeComponentUnit unit, BeanMetaData bean) {
        unit.cleanup();
    }

    private static class FakeComponentUnit {
        VFSDeploymentUnit parent;
        BeanMetaData bmd;
        ScopeKey scope;
        ScopeKey mutableScope;

        FakeComponentUnit(VFSDeploymentUnit parent, BeanMetaData bmd) {
            this.parent = parent;
            this.bmd = bmd;
        }

        ScopeKey getScope() {
            if (this.scope == null) {
                ScopeKey key = this.parent.getScope().clone();
                key.removeScopeLevel(CommonLevels.INSTANCE);
                key.addScope(CommonLevels.INSTANCE, (Object)this.bmd.getName());
            }
            return this.scope;
        }

        ScopeKey getMutableScope() {
            if (this.mutableScope == null) {
                this.mutableScope = new ScopeKey();
                this.mutableScope.addScope(CommonLevels.INSTANCE, (Object)this.bmd.getName());
            }
            return this.mutableScope;
        }

        ClassLoader getClassLoader() {
            return this.parent.getClassLoader();
        }

        String getName() {
            return this.bmd.getName();
        }

        void cleanup() {
            ScopeKey scope;
            MutableMetaDataRepository repository = null;
            VFSDeploymentUnit unit = this.parent;
            while (repository == null && unit != null) {
                repository = (MutableMetaDataRepository)unit.getAttachment(MutableMetaDataRepository.class);
                unit = this.parent.getParent();
            }
            if (repository == null) {
                return;
            }
            try {
                scope = this.getScope();
                repository.removeMetaDataRetrieval(scope);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                scope = this.getMutableScope();
                repository.removeMetaDataRetrieval(scope);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class DeploymentClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;
        private FakeComponentUnit unit;

        public DeploymentClassLoaderMetaData(FakeComponentUnit unit) {
            if (unit == null) {
                throw new IllegalArgumentException("Null unit");
            }
            this.unit = unit;
        }

        public ValueMetaData getClassLoader() {
            return new AbstractValueMetaData((Object)this.unit.getClassLoader());
        }
    }

    private class MyBeanMetaDataDeployer {
        private MyBeanMetaDataDeployer() {
        }

        private void deploy(FakeComponentUnit unit, BeanMetaData deployment) throws DeploymentException {
            AbstractKernelControllerContext context;
            ScopeInfo scopeInfo;
            if (deployment.getClassLoader() == null) {
                try {
                    unit.getClassLoader();
                    deployment.setClassLoader((ClassLoaderMetaData)new DeploymentClassLoaderMetaData(unit));
                }
                catch (Exception e) {
                    AbstractAopMetaDataDeployer.this.log.debug((Object)("Unable to retrieve classloader for deployment: " + unit.getName() + " reason=" + e.toString()));
                }
            }
            if ((scopeInfo = (context = new AbstractKernelControllerContext(null, deployment, null)).getScopeInfo()) != null) {
                this.mergeScopes(scopeInfo.getScope(), unit.getScope());
                this.mergeScopes(scopeInfo.getMutableScope(), unit.getMutableScope());
            }
            try {
                AbstractAopMetaDataDeployer.this.controller.install((ControllerContext)context);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment.getName()), (Throwable)t);
            }
        }

        protected void mergeScopes(ScopeKey contextKey, ScopeKey unitKey) {
            if (contextKey == null) {
                return;
            }
            if (unitKey == null) {
                return;
            }
            Collection unitScopes = unitKey.getScopes();
            if (unitScopes == null || unitScopes.isEmpty()) {
                return;
            }
            for (Scope scope : unitScopes) {
                contextKey.addScope(scope);
            }
        }

        private void undeploy(DeploymentUnit unit, BeanMetaData deployment) {
            try {
                AbstractAopMetaDataDeployer.this.controller.uninstall((Object)deployment.getName());
                ClassLoaderMetaData classLoader = deployment.getClassLoader();
                if (classLoader instanceof DeploymentClassLoaderMetaData) {
                    deployment.setClassLoader(null);
                }
            }
            catch (Throwable t) {
                AbstractAopMetaDataDeployer.this.log.info((Object)("Error undeploying " + deployment + " for " + unit));
            }
        }
    }
}

