package org.jboss.aop.asintegration.jboss5;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;

/**
 * BeanMetaDatadeployer uses AbstractComponentUnit per bean, but that has the overhead of
 * registering things in JMX. Create a Fake one here to encapsulate the methods that we use
 * without registering things in JMX
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 82920 $
 */
class FakeComponentUnit
{
   VFSDeploymentUnit parent;
   BeanMetaData bmd;
   ScopeKey scope;
   ScopeKey mutableScope;
   
   FakeComponentUnit(VFSDeploymentUnit parent, BeanMetaData bmd)
   {
      this.parent = parent;
      this.bmd = bmd;
   }
   
   ScopeKey getScope()
   {
      if (scope == null)
      {
         ScopeKey key = parent.getScope().clone();
         key.removeScopeLevel(CommonLevels.INSTANCE);
         key.addScope(CommonLevels.INSTANCE, bmd.getName());
      }
      return scope;
   }
   
   ScopeKey getMutableScope()
   {
      if (mutableScope == null)
      {
         mutableScope = new ScopeKey();
         mutableScope.addScope(CommonLevels.INSTANCE, bmd.getName());
      }
      return mutableScope;
   }

   ClassLoader getClassLoader()
   {
      return parent.getClassLoader();
   }
   
   String getName()
   {
      return bmd.getName();
   }
   
   BeanMetaData getBeanMetaData()
   {
      return bmd;
   }
   
   void cleanup()
   {
      MutableMetaDataRepository repository = null; 
      DeploymentUnit unit = parent;
      while (repository == null && unit != null)
      {
         repository = unit.getAttachment(MutableMetaDataRepository.class);
         unit = unit.getParent();
      }
      if (repository == null)
      {
         return;
      }
      
      try
      {
         ScopeKey scope = getScope();
         repository.removeMetaDataRetrieval(scope);
      }
      catch (Throwable ignored)
      {
      }

      try
      {
         ScopeKey scope = getMutableScope();
         repository.removeMetaDataRetrieval(scope);
      }
      catch (Throwable ignored)
      {
      }
   }
}