/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.Construction;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructionInfo
extends JoinPointInfo
implements Construction {
    private Constructor<?> constructor;
    private int index;

    public ConstructionInfo() {
    }

    public ConstructionInfo(Class<?> clazz, int index, long constructorHash, Advisor advisor) {
        super(advisor, clazz);
        try {
            this.index = index;
            this.constructor = MethodHashing.findConstructorByHash(clazz, constructorHash);
            this.setAdvisor(advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ConstructionInfo(ConstructionInfo other) {
        super(other);
        this.constructor = other.constructor;
        this.index = other.index;
    }

    @Override
    protected Joinpoint internalGetJoinpoint() {
        return new ConstructorJoinpoint(this.constructor);
    }

    @Override
    public JoinPointInfo copy() {
        return new ConstructionInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Construction");
        sb.append("[");
        sb.append("constructor=" + this.constructor);
        sb.append("]");
        return sb.toString();
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public <T extends Annotation> T resolveAnnotation(Class<T> annotation) {
        T val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveTypedAnnotation(this.constructor, annotation)) != null) {
            return val;
        }
        return null;
    }
}

