/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress;

import java.net.URL;
import org.jboss.test.aop.stress.DefaultScenarioPropertyReader;
import org.jboss.test.aop.stress.FileScenarioPropertyReader;
import org.jboss.test.aop.stress.MutableFileScenatioPropertyLoader;
import org.jboss.test.aop.stress.ScenarioPropertyReader;
import org.jboss.test.aop.stress.SystemScenarioPropertyReader;

public class ScenarioPropertyReaderFactory {
    Class testCaseClass;
    String packageName;
    String baseDirectory;
    ScenarioPropertyReader reader;

    ScenarioPropertyReaderFactory(Class testCaseClass) {
        this.testCaseClass = testCaseClass;
        this.packageName = testCaseClass.getName().substring("org.jboss.test.aop.stress.".length(), testCaseClass.getName().lastIndexOf("."));
        this.packageName.replace('.', '/');
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        System.out.println("class url: " + url);
        String location = url.toString();
        int index = location.indexOf("/output/");
        location = location.substring(0, index);
        this.baseDirectory = location + "/src/resources/test/stress/";
    }

    public ScenarioPropertyReader getPropertyReader(String testName) {
        if (this.reader == null) {
            ScenarioPropertyReader cur = this.reader = new SystemScenarioPropertyReader();
            ScenarioPropertyReader next = new MutableFileScenatioPropertyLoader(this.getConfigFileForTest(testName), false);
            cur.setNext(next);
            cur = next;
            next = new FileScenarioPropertyReader(this.baseDirectory + this.packageName + "/" + this.testCaseClass.getSimpleName() + ".properties", false);
            cur.setNext(next);
            cur = next;
            next = new FileScenarioPropertyReader(this.baseDirectory + "config.properties", true);
            cur.setNext(next);
            cur = next;
            next = new DefaultScenarioPropertyReader();
            cur.setNext(next);
        } else {
            for (ScenarioPropertyReader cur = this.reader; cur != null; cur = cur.getNext()) {
                if (!(cur instanceof MutableFileScenatioPropertyLoader)) continue;
                ((MutableFileScenatioPropertyLoader)cur).updateProperties(this.getConfigFileForTest(testName));
            }
        }
        return this.reader;
    }

    private String getConfigFileForTest(String testName) {
        return this.baseDirectory + this.packageName + "/" + this.testCaseClass.getSimpleName() + "_" + testName + ".properties";
    }
}

