/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.GeneratedAdvisorMethodExecutionTransformer;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.joinpoint.MethodExecution;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class MethodJoinPointGenerator
extends JoinPointGenerator {
    private static final Class INVOCATION_TYPE = MethodInvocation.class;
    private static final Class JOINPOINT_TYPE = MethodExecution.class;
    private static final CtClass INVOCATION_CT_TYPE;
    WeakReference<Class<?>> returnType;
    boolean hasTargetObject;

    public MethodJoinPointGenerator(GeneratedClassAdvisor advisor, MethodInfo info) {
        super(advisor, info, MethodJoinPointGenerator.getParameters(info), info.getMethod().getParameterTypes().length, false);
        if (super.getJoinpointField() != null) {
            if (!info.getUnadvisedMethod().getReturnType().equals(Void.TYPE)) {
                this.returnType = new WeakReference(info.getUnadvisedMethod().getReturnType());
            }
            this.hasTargetObject = !Modifier.isStatic(info.getMethod().getModifiers());
        }
    }

    private static JoinPointGenerator.JoinPointParameters getParameters(MethodInfo info) {
        if (Modifier.isStatic(info.getMethod().getModifiers())) {
            return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
        }
        return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
    }

    protected void initialiseJoinPointNames(JoinPointInfo info) {
        MethodInfo minfo = (MethodInfo)info;
        this.joinpointClassName = MethodJoinPointGenerator.getGeneratedJoinPointClassName(this.advisedMethodName(minfo), this.methodHash(minfo));
        this.joinpointFieldName = MethodJoinPointGenerator.getGeneratedJoinPointFieldName(this.advisedMethodName(minfo), this.methodHash(minfo));
    }

    private String advisedMethodName(MethodInfo info) {
        return info.getMethod().getName();
    }

    private long methodHash(MethodInfo info) {
        return info.getHash();
    }

    protected boolean isVoid() {
        return this.getReturnClassType() == null;
    }

    protected Class getReturnClassType() {
        if (this.returnType == null) {
            return null;
        }
        return (Class)this.returnType.get();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodExecution)joinPoint).getMethod();
        return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), this.hasTargetObject());
    }

    protected boolean hasTargetObject() {
        return this.hasTargetObject;
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, CtMethod wMethod, String miname, String originalMethodName, String wrappedMethodName, long hash) throws CannotCompileException, NotFoundException {
        BaseClassGenerator factory = new BaseClassGenerator(instrumentor, advisedClass, targetMethod, wMethod, miname, originalMethodName, wrappedMethodName, hash);
        return factory.generate();
    }

    protected static String getGeneratedJoinPointFieldName(String methodName, long hash) {
        return "joinpoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
    }

    private static String getGeneratedJoinPointClassName(String methodName, long hash) {
        return "JoinPoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtMethod advisedMethod;
        CtMethod wMethod;
        String miname;
        String originalMethodName;
        String wrappedMethodName;
        long hash;
        boolean hasTargetObject;
        CtMethod targetMethod;
        CtClass jp;
        CtClass[] originalParams;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, CtMethod wMethod, String miname, String originalMethodName, String wrappedMethodName, long hash) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedMethod = targetMethod;
            this.targetMethod = targetMethod;
            this.wMethod = wMethod;
            this.miname = miname;
            this.originalMethodName = originalMethodName;
            this.wrappedMethodName = wrappedMethodName;
            this.hash = hash;
            this.originalParams = targetMethod.getParameterTypes();
            this.params = GeneratedAdvisorMethodExecutionTransformer.addTargetToParamsForNonStaticMethod(advisedClass, targetMethod);
            this.methodInfoClass = instrumentor.forName("org.jboss.aop.MethodInfo");
            this.hasTargetObject = !Modifier.isStatic(this.advisedMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.originalParams, true);
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addDefaultConstructor();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodJoinPointGenerator.getGeneratedJoinPointClassName(this.originalMethodName, this.hash);
            this.jp = TransformerCommon.makeNestedClass(this.advisedClass, className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass methodInvocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(methodInvocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addTypedTargetField() throws CannotCompileException {
            CtField targetField = new CtField(this.advisedClass, "typedTargetObject", this.jp);
            this.jp.addField(targetField);
            targetField.setModifiers(132);
        }

        private void addDefaultConstructor() throws CannotCompileException {
            CtConstructor defaultConstructor = CtNewConstructor.defaultConstructor((CtClass)this.jp);
            this.jp.addConstructor(defaultConstructor);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.methodInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            CtClass[] ctorParams1 = new CtClass[this.params.length + 1];
            CtClass[] ctorParams2 = null;
            ctorParams1[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams1, 1, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            int offset = 1;
            if (this.hasTargetObject) {
                offset = 2;
                ctorParams2 = new CtClass[2];
                System.arraycopy(ctorParams1, 0, ctorParams2, 0, 2);
                body.append("   this.typedTargetObject = $2;");
                body.append("   super.setTargetObject($2);");
            } else {
                ctorParams2 = new CtClass[]{ctorParams1[0]};
            }
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments.toString()), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 1) {
                protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)this.advisedMethod.getReturnType(), (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])JoinPointGenerator.THROWS_THROWABLE, null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            this.jp.addField(infoField);
            infoField.setModifiers(132);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
            if (this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
            this.addInvokeTargetMethod();
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            int offset = this.hasTargetObject ? 1 : 0;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.originalParams.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            String body = !this.hasTargetObject ? "{" + MethodExecutionTransformer.getReturnStr(this.advisedMethod) + this.advisedClass.getName() + "." + this.wrappedMethodName + "(" + parameters + ");}" : "{" + MethodExecutionTransformer.getAopReturnStr(this.advisedMethod) + "$1." + this.wrappedMethodName + "(" + parameters + ");}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedMethod.getReturnType(), (String)"dispatch", (CtClass[])this.params, (CtClass[])this.advisedMethod.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            boolean isVoid = this.advisedMethod.getReturnType().equals(CtClass.voidType);
            String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

