/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.ContainerCacheUtil;
import org.jboss.aop.proxy.container.MarshalledContainerProxy;
import org.jboss.metadata.spi.MetaData;
import org.jboss.util.id.GUID;

public class ContainerProxyCacheKey
implements Serializable {
    private static final long serialVersionUID = 8758283842273747310L;
    private static final WeakReference<Class>[] EMTPY_WR_ARRAY = new WeakReference[0];
    private static final AOPProxyFactoryMixin[] EMPTY_MIXIN_ARRAY = new AOPProxyFactoryMixin[0];
    private String managerFqn;
    private WeakReference<Class> clazzRef;
    private WeakReference<Class>[] addedInterfaces = EMTPY_WR_ARRAY;
    private MetaData metaData;
    private long metaDataIdentityHashCode;
    private AOPProxyFactoryMixin[] addedMixins = EMPTY_MIXIN_ARRAY;
    private int hashcode = 0;
    private GUID guid = MarshalledContainerProxy.GUID;

    public ContainerProxyCacheKey(String managerFqn, Class clazz) {
        this.clazzRef = new WeakReference<Class>(clazz);
        this.managerFqn = managerFqn;
    }

    public ContainerProxyCacheKey(Class clazz) {
        this("/", clazz);
    }

    public ContainerProxyCacheKey(String managerFqn, Class clazz, Class[] addedInterfaces, MetaData metaData) {
        this(managerFqn, clazz);
        this.addedInterfaces = ContainerCacheUtil.getSortedWeakReferenceForInterfaces(addedInterfaces);
        this.metaData = metaData;
    }

    public ContainerProxyCacheKey(String managerFqn, Class clazz, Class[] addedInterfaces, AOPProxyFactoryMixin[] addedMixins, MetaData metaData) {
        this(managerFqn, clazz, addedInterfaces, metaData);
        if (addedMixins != null) {
            this.addedMixins = addedMixins;
            Arrays.sort(this.addedMixins, MixinAlphabetical.singleton);
        }
    }

    public Class getClazz() {
        return (Class)this.clazzRef.get();
    }

    public String getManagerFQN() {
        return this.managerFqn;
    }

    protected GUID getGuid() {
        return this.guid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ContainerProxyCacheKey.class) {
            return false;
        }
        ContainerProxyCacheKey other = (ContainerProxyCacheKey)obj;
        if (!this.managerFqn.equals(other.managerFqn)) {
            return false;
        }
        if (!this.compareMetadataContext(other)) {
            return false;
        }
        if (!this.compareClass(other)) {
            return false;
        }
        if (!this.compareAddedInterfaces(other)) {
            return false;
        }
        if (!this.compareAddedMixins(other)) {
            return false;
        }
        return this.guid.equals((Object)other.guid);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            Class clazz = (Class)this.clazzRef.get();
            StringBuffer sb = new StringBuffer();
            sb.append(this.managerFqn);
            if (clazz != null) {
                sb.append(clazz.getName());
            }
            if (this.addedInterfaces != null) {
                for (int i = 0; i < this.addedInterfaces.length; ++i) {
                    sb.append(";");
                    sb.append(((Class)this.addedInterfaces[i].get()).getName());
                }
            }
            this.hashcode = sb.toString().hashCode();
            if (this.metaData != null) {
                this.hashcode += this.metaData.hashCode();
            }
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ContainerProxyCache");
        buf.append(((Class)this.clazzRef.get()).getName());
        buf.append(";interfaces=");
        if (this.addedInterfaces == null) {
            buf.append("null");
        } else {
            buf.append(Arrays.asList(this.addedInterfaces));
        }
        buf.append(";mixins=");
        if (this.addedMixins == null) {
            buf.append("null");
        } else {
            buf.append(Arrays.asList(this.addedMixins));
        }
        return buf.toString();
    }

    private boolean compareMetadataContext(ContainerProxyCacheKey other) {
        long twoHashCode;
        long oneHashCode;
        if (this.metaData == null && this.metaDataIdentityHashCode == 0L && other.metaData == null && other.metaDataIdentityHashCode == 0L) {
            return true;
        }
        if (this.metaData != null && other.metaData != null) {
            return this.metaData.equals(other.metaData);
        }
        if (this.metaDataIdentityHashCode != 0L && other.metaDataIdentityHashCode != 0L) {
            return this.metaDataIdentityHashCode == other.metaDataIdentityHashCode;
        }
        if (this.metaData != null && other.metaData == null && other.metaDataIdentityHashCode != 0L && (oneHashCode = (long)System.identityHashCode(this.metaData)) == other.metaDataIdentityHashCode) {
            other.metaData = this.metaData;
            return true;
        }
        if (other.metaData != null && this.metaData == null && this.metaDataIdentityHashCode != 0L && (twoHashCode = (long)System.identityHashCode(other.metaData)) == this.metaDataIdentityHashCode) {
            this.metaData = other.metaData;
            return true;
        }
        return false;
    }

    private boolean compareClass(ContainerProxyCacheKey other) {
        return ContainerCacheUtil.compareClassRefs(this.clazzRef, other.clazzRef);
    }

    private boolean compareAddedInterfaces(ContainerProxyCacheKey other) {
        return ContainerCacheUtil.compareInterfaceRefs(this.addedInterfaces, other.addedInterfaces);
    }

    private boolean compareAddedMixins(ContainerProxyCacheKey other) {
        if (this.addedMixins == null && other.addedMixins != null || this.addedMixins == null && other.addedMixins != null) {
            return false;
        }
        if (this.addedMixins != null && other.addedMixins != null) {
            if (this.addedMixins.length != other.addedMixins.length) {
                return false;
            }
            for (int i = 0; i < this.addedMixins.length; ++i) {
                if (this.addedMixins[i].equals(other.addedMixins[i])) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.managerFqn);
        out.writeObject(this.guid);
        out.writeObject(this.clazzRef.get());
        Class[] ifs = null;
        if (this.addedInterfaces != null) {
            ifs = new Class[this.addedInterfaces.length];
            for (int i = 0; i < this.addedInterfaces.length; ++i) {
                ifs[i] = (Class)this.addedInterfaces[i].get();
            }
        }
        out.writeObject(ifs);
        if (this.metaData instanceof Serializable) {
            out.writeObject(this.metaData);
        } else {
            out.writeObject(null);
        }
        out.writeLong(System.identityHashCode(this.metaData));
        out.writeObject(this.addedMixins);
        out.writeInt(this.hashCode());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.managerFqn = in.readUTF();
        this.guid = (GUID)in.readObject();
        this.clazzRef = new WeakReference<Class>((Class)in.readObject());
        Class[] ifs = (Class[])in.readObject();
        if (ifs != null) {
            this.addedInterfaces = new WeakReference[ifs.length];
            for (int i = 0; i < ifs.length; ++i) {
                this.addedInterfaces[i] = new WeakReference<Class>(ifs[i]);
            }
        }
        this.metaData = (MetaData)in.readObject();
        this.metaDataIdentityHashCode = in.readLong();
        this.addedMixins = (AOPProxyFactoryMixin[])in.readObject();
        this.hashcode = in.readInt();
    }

    static class MixinAlphabetical
    implements Comparator {
        static MixinAlphabetical singleton = new MixinAlphabetical();

        MixinAlphabetical() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((AOPProxyFactoryMixin)o1).getMixin().getName();
            String name2 = ((AOPProxyFactoryMixin)o2).getMixin().getName();
            return name1.compareTo(name2);
        }
    }
}

