/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.UnmodifiableEmptyCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPointComparator {
    public static long[] mergeMethodInfoKeys(long[] myKeys, long[] otherKeys) {
        long[] allKeys = null;
        if (myKeys == null || myKeys.length == 0) {
            allKeys = otherKeys;
            Arrays.sort(allKeys);
        } else if (otherKeys == null || otherKeys.length == 0) {
            allKeys = myKeys;
            Arrays.sort(allKeys);
        } else {
            allKeys = new long[myKeys.length + otherKeys.length];
            System.arraycopy(myKeys, 0, allKeys, 0, myKeys.length);
            System.arraycopy(otherKeys, 0, allKeys, myKeys.length, otherKeys.length);
            Arrays.sort(allKeys);
            boolean haveDups = false;
            int i = 0;
            int dup = allKeys.length;
            for (int peek = 1; peek < allKeys.length; ++peek) {
                if (allKeys[i] == allKeys[peek]) {
                    if (!haveDups) {
                        dup = peek;
                        haveDups = true;
                    }
                } else if (haveDups) {
                    allKeys[dup++] = allKeys[peek];
                }
                ++i;
            }
            if (dup != allKeys.length) {
                long[] deduped = new long[dup];
                System.arraycopy(allKeys, 0, deduped, 0, dup);
                allKeys = deduped;
            }
        }
        return allKeys;
    }

    public static int hasSameInterceptorLengths(JoinPointInfo myInfo, JoinPointInfo otherInfo) {
        if (myInfo != null && otherInfo != null) {
            int i;
            if (myInfo.getInterceptors() != null && otherInfo.getInterceptors() != null && (i = JoinPointComparator.compareLengths(JoinPointComparator.getLengthNullAsZero(myInfo), JoinPointComparator.getLengthNullAsZero(otherInfo))) != 0) {
                return i;
            }
        } else if (myInfo != null || otherInfo != null) {
            if (myInfo == null) {
                if (JoinPointComparator.getLengthNullAsZero(otherInfo) > 0) {
                    return 1;
                }
            } else if (JoinPointComparator.getLengthNullAsZero(myInfo) > 0) {
                return -1;
            }
        }
        return 0;
    }

    public static boolean hasSameMethodAspectLength(long[] myKeys, long[] otherKeys, Advisor myAdvisor, Advisor otherAdvisor) {
        long[] keys = JoinPointComparator.mergeMethodInfoKeys(myKeys, otherKeys);
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo otherInfo;
            MethodInfo myInfo = myAdvisor.getMethodInfo(keys[i]);
            if (JoinPointComparator.hasSameInterceptorLengths(myInfo, otherInfo = otherAdvisor.getMethodInfo(keys[i])) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSameConstructorAspectLength(ConstructorInfo[] myInfos, ConstructorInfo[] otherInfos) {
        Map<Constructor<?>, ConstructorInfo> myMap = JoinPointComparator.createConstructorInfoMap(myInfos);
        Map<Constructor<?>, ConstructorInfo> otherMap = JoinPointComparator.createConstructorInfoMap(otherInfos);
        if (myMap.size() == 0 && otherMap.size() == 0) {
            return true;
        }
        if (myMap.size() == 0 && otherMap.size() > 0) {
            if (JoinPointComparator.hasNonNullInfos(otherInfos)) {
                return false;
            }
        } else if (myMap.size() > 0 && otherMap.size() == 0) {
            if (JoinPointComparator.hasNonNullInfos(myInfos)) {
                return false;
            }
        } else {
            HashSet<ConstructorInfo> nonMatches = new HashSet<ConstructorInfo>();
            for (Constructor<?> ctor : myMap.keySet()) {
                ConstructorInfo myInfo = myMap.get(ctor);
                ConstructorInfo otherInfo = otherMap.remove(ctor);
                if (otherInfo != null) {
                    int i = JoinPointComparator.compareLengths(JoinPointComparator.getLengthNullAsZero(myInfo), JoinPointComparator.getLengthNullAsZero(otherInfo));
                    if (i == 0) continue;
                    return false;
                }
                nonMatches.add(myInfo);
            }
            if (otherMap.size() > 0 && JoinPointComparator.hasNonNullInfos(otherMap.values())) {
                return false;
            }
            if (nonMatches.size() > 0 && JoinPointComparator.hasNonNullInfos(nonMatches)) {
                return false;
            }
        }
        return true;
    }

    private static Map<Constructor<?>, ConstructorInfo> createConstructorInfoMap(ConstructorInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return UnmodifiableEmptyCollections.EMPTY_HASHMAP;
        }
        HashMap map = new HashMap(infos.length);
        for (ConstructorInfo info : infos) {
            map.put(info.getConstructor(), info);
        }
        return map;
    }

    private static boolean hasNonNullInfos(JoinPointInfo[] infos) {
        if (infos.length > 0) {
            for (JoinPointInfo info : infos) {
                if (JoinPointComparator.getLengthNullAsZero(info) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasNonNullInfos(Collection<ConstructorInfo> infos) {
        if (infos.size() > 0) {
            for (ConstructorInfo info : infos) {
                if (JoinPointComparator.getLengthNullAsZero(info) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static int compareLengths(int mine, int other) {
        if (mine > other) {
            return -1;
        }
        if (mine == other) {
            return 0;
        }
        return 1;
    }

    private static int getLengthNullAsZero(JoinPointInfo info) {
        Interceptor[] icptrs = info.getInterceptors();
        if (icptrs == null) {
            return 0;
        }
        return icptrs.length;
    }
}

