/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15.dynamic.common;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.test.aop.jdk15.dynamic.common.InterceptionsCount;

public class BindingInterceptor
implements Interceptor {
    private static InterceptionsCount interceptionsCount = new InterceptionsCount();

    public static InterceptionsCount getInterceptionsCount() {
        return interceptionsCount;
    }

    public static void resetCounts() {
        interceptionsCount = new InterceptionsCount();
    }

    public String getName() {
        return "InstanceInterceptor";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Invocation invocation) throws Throwable {
        ++BindingInterceptor.interceptionsCount.total;
        if (invocation instanceof ConstructorInvocation) {
            ++BindingInterceptor.interceptionsCount.constructor;
            return invocation.invokeNext();
        } else if (invocation instanceof FieldInvocation) {
            if (invocation instanceof FieldReadInvocation) {
                ++BindingInterceptor.interceptionsCount.fieldRead;
                return invocation.invokeNext();
            } else {
                if (!(invocation instanceof FieldWriteInvocation)) throw new RuntimeException("Unexpected invocation type invalidates test correction.");
                ++BindingInterceptor.interceptionsCount.fieldWrite;
            }
            return invocation.invokeNext();
        } else {
            if (!(invocation instanceof MethodInvocation)) return invocation.invokeNext();
            ++BindingInterceptor.interceptionsCount.method;
        }
        return invocation.invokeNext();
    }
}

