/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.proxy;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.test.aop.proxy.ProxyFileCreator;

public class OutOfProcessProxyFileCreator
implements ProxyFileCreator {
    String proxyCreatorClass;

    public OutOfProcessProxyFileCreator(String proxyCreatorClass) {
        this.proxyCreatorClass = proxyCreatorClass;
    }

    public File createProxyFile() throws Exception {
        return this.runExternalProcess();
    }

    private File runExternalProcess() throws Exception {
        String debug;
        Properties props = System.getProperties();
        String classPath = props.getProperty("java.class.path");
        String libraryPath = props.getProperty("sun.boot.library.path") + File.separator + "java";
        String java = this.findJava(libraryPath);
        File proxyFile = File.createTempFile("proxy", "err");
        proxyFile.deleteOnExit();
        boolean debugFlag = System.getProperty("jboss.aop.debug.classes", "false").equals("true");
        String string = debug = debugFlag ? "-Djboss.aop.debug.classes=true " : "";
        if (classPath.contains(" ")) {
            throw new RuntimeException("Classpath should not contain the space character for this test. " + classPath);
        }
        String run = java + " -classpath " + classPath + " " + debug + this.proxyCreatorClass + " " + proxyFile.getAbsolutePath().replace('\\', '/');
        Process proc = Runtime.getRuntime().exec(run);
        int result = proc.waitFor();
        InputStream sysout = proc.getInputStream();
        InputStream syserr = proc.getErrorStream();
        this.outputStream("System.out", sysout);
        this.outputStream("System.err", syserr);
        switch (result) {
            case 1: {
                throw new RuntimeException("Too few args passed in");
            }
            case 2: {
                throw new RuntimeException("Too many args passed in");
            }
            case 3: {
                throw new RuntimeException("No file found " + proxyFile);
            }
            case 4: {
                String externalException = this.getExternalException(proxyFile);
                throw new RuntimeException(externalException);
            }
        }
        return proxyFile;
    }

    private void outputStream(String type, InputStream in) throws IOException {
        System.out.println("= = = = = = = = = = Other process " + type);
        int i = in.read();
        while (i != -1) {
            System.out.print((char)i);
            i = in.read();
        }
        System.out.println("= = = = = = = = = = END Other process " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExternalException(File proxyFile) {
        FileReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new FileReader(proxyFile);
            int r = ((Reader)reader).read();
            while (r != -1) {
                sb.append((char)r);
                r = ((Reader)reader).read();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    private String findJava(String classPath) {
        String java = null;
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.endsWith(".jar") || (java = this.getJavaPath(path)) == null) continue;
            return java;
        }
        return null;
    }

    private String getJavaPath(String dirName) {
        if (File.separatorChar == '/') {
            String file;
            if (dirName.contains("jre")) {
                dirName = dirName.substring(0, dirName.indexOf(File.separatorChar + "jre"));
            }
            if ((file = this.getFile(dirName + File.separator + "bin" + File.separator + "java")) != null) {
                return file;
            }
            file = this.getFile(dirName);
            if (file != null) {
                return file;
            }
        } else if (File.separatorChar == '\\') {
            String file = this.getFile(dirName + File.separator + "java.exe");
            if (file != null) {
                return file;
            }
            file = this.getFile(dirName);
            if (file != null) {
                return file;
            }
            file = this.getFile(dirName + ".exe");
            if (file != null) {
                return file;
            }
        } else {
            throw new RuntimeException("Cannot figure out OS");
        }
        return null;
    }

    private String getFile(String java) {
        File file;
        if (java != null && (file = new File(java)).exists() && !file.isDirectory()) {
            System.out.println("Using Java executable: " + java);
            return file.getAbsolutePath();
        }
        return null;
    }
}

