/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedConstructorInvocations
extends OptimizedBehaviourInvocations {
    protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + ".AOP" + constructorIndex + "OptimizedConstructorInvocation";
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        String className = OptimizedConstructorInvocations.getOptimizedInvocationClassName(clazz, index);
        boolean makeInnerClass = true;
        CtClass invocation = OptimizedConstructorInvocations.makeInvocationClassNoCtors(pool, makeInnerClass, clazz, className, conInvocation);
        CtConstructor template = conInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make(template.getParameterTypes(), template.getExceptionTypes(), invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        OptimizedConstructorInvocations.addArgumentFieldsAndAccessors(pool, invocation, params, false);
        OptimizedConstructorInvocations.addDispatch(invocation, "invokeTarget", con);
        OptimizedConstructorInvocations.addCopy(invocation, con.getParameterTypes());
        TransformerCommon.compileOrLoadClass(clazz, invocation);
        return invocation.getName();
    }

    public static final void addDispatch(CtClass invocation, String methodName, CtConstructor constructor) throws NotFoundException, CannotCompileException {
        StringBuffer dispatchLine = new StringBuffer("   result = new ");
        dispatchLine.append(constructor.getDeclaringClass().getName());
        OptimizedBehaviourInvocations.addDispatch(invocation, methodName, constructor.getParameterTypes(), dispatchLine.toString(), "Object result = null;", "   setTargetObject(result);   return result;");
    }

    private static void addCopy(CtClass invocation, CtClass[] params) throws CannotCompileException, NotFoundException {
        CtMethod template = invocation.getSuperclass().getDeclaredMethod("copy");
        StringBuffer code = new StringBuffer("{    ");
        code.append(invocation.getName()).append(" wrapper = new ");
        code.append(invocation.getName()).append("(this.interceptors); ");
        code.append("   wrapper.constructor = this.constructor; ");
        code.append("   wrapper.arguments = this.arguments; ");
        code.append("   wrapper.metadata = this.metadata; ");
        code.append("   wrapper.currentInterceptor = this.currentInterceptor; ");
        for (int i = 0; i < params.length; ++i) {
            code.append("   wrapper.arg" + i + " = this.arg" + i + "; ");
        }
        code.append("   return wrapper; }");
        CtMethod copy = CtNewMethod.make(template.getReturnType(), "copy", template.getParameterTypes(), template.getExceptionTypes(), code.toString(), invocation);
        copy.setModifiers(template.getModifiers());
        invocation.addMethod(copy);
    }
}

