/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature {
    public static final String NO_NAME = "?%NO_NAME%?";
    public static final String[] NO_PARAMETERS = new String[0];
    public static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private String name;
    private String[] parameters;
    private Class<?>[] parameterTypes;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    public static Signature getSignature(Member member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        if (member instanceof Method) {
            Method method = (Method)Method.class.cast(member);
            return new MethodSignature(method);
        }
        if (member instanceof Field) {
            Field field = (Field)Field.class.cast(member);
            return new FieldSignature(field);
        }
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)Constructor.class.cast(member);
            return new ConstructorSignature(constructor);
        }
        throw new IllegalArgumentException("Unknown member: " + member);
    }

    public static Signature getSignature(MemberInfo member) {
        if (member == null) {
            throw new IllegalArgumentException("Null member");
        }
        if (member instanceof MethodInfo) {
            MethodInfo method = (MethodInfo)MethodInfo.class.cast(member);
            return new MethodSignature(method);
        }
        if (member instanceof FieldInfo) {
            FieldInfo field = (FieldInfo)FieldInfo.class.cast(member);
            return new FieldSignature(field);
        }
        if (member instanceof ConstructorInfo) {
            ConstructorInfo constructor = (ConstructorInfo)ConstructorInfo.class.cast(member);
            return new ConstructorSignature(constructor);
        }
        throw new IllegalArgumentException("Unknown member: " + member);
    }

    @Deprecated
    public static String getPrimativeArrayType(String name) {
        return PrimitiveInfo.getPrimativeArrayType(name);
    }

    public static String[] convertParameters(TypeInfo[] typeInfos) {
        if (typeInfos == null || typeInfos.length == 0) {
            return NO_PARAMETERS;
        }
        String[] paramTypes = new String[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getName();
        }
        return paramTypes;
    }

    public static Class<?>[] convertParameterTypes(TypeInfo[] typeInfos) {
        if (typeInfos == null || typeInfos.length == 0) {
            return NO_PARAMETER_TYPES;
        }
        Class[] paramTypes = new Class[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getType();
        }
        return paramTypes;
    }

    private static String[] classesToStrings(Class<?> ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return NO_PARAMETERS;
        }
        String[] result = new String[parameters.length];
        for (int i = 0; i < result.length; ++i) {
            if (parameters[i] == null) {
                throw new IllegalArgumentException("Null class");
            }
            result[i] = parameters[i].getName();
        }
        return result;
    }

    private static Class<?>[] stringsToClasses(Class<?> clazz, String ... parameters) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null && (cl = Class.class.getClassLoader()) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return Signature.stringsToClasses(cl, parameters);
    }

    private static Class<?> loadClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Class<?> primitive = PrimitiveInfo.getPrimativeType(name);
        if (primitive != null) {
            return primitive;
        }
        int index = name.lastIndexOf(91);
        if (index >= 0) {
            Class<?> componentType;
            int arrayDimension = 0;
            while (name.charAt(arrayDimension) == '[') {
                ++arrayDimension;
            }
            if (name.charAt(arrayDimension) == 'L') {
                String arrayType = name.substring(arrayDimension + 1, name.length() - 1);
                componentType = Signature.loadClass(cl, arrayType);
            } else {
                String arrayType = name.substring(arrayDimension);
                componentType = PrimitiveInfo.getPrimativeArrayComponentType(arrayType);
            }
            return Array.newInstance(componentType, new int[arrayDimension]).getClass();
        }
        return Class.forName(name, true, cl);
    }

    private static Class<?>[] stringsToClasses(ClassLoader cl, String ... parameters) {
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (parameters == null || parameters.length == 0) {
            return NO_PARAMETER_TYPES;
        }
        Class[] result = new Class[parameters.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = Signature.loadClass(cl, parameters[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class not found: " + parameters[i], e);
            }
        }
        return result;
    }

    public Signature() {
        this(NO_NAME, NO_PARAMETER_TYPES, NO_PARAMETERS);
    }

    public Signature(String name) {
        this(name, (Class<?>[])null, NO_PARAMETERS);
    }

    public Signature(String ... parameters) {
        this(NO_NAME, (Class<?>[])null, parameters);
    }

    public Signature(Class<?> ... parameters) {
        this(NO_NAME, parameters, (String[])null);
    }

    public Signature(String name, Class<?> ... parameters) {
        this(name, parameters, (String[])null);
    }

    public Signature(String name, String ... parameters) {
        this(name, (Class<?>[])null, parameters);
    }

    private Signature(String name, Class<?>[] parameterTypes, String[] parameters) {
        this.name = name;
        if (name == null) {
            this.name = NO_NAME;
        }
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        if (this.parameters == null) {
            this.parameters = Signature.classesToStrings(this.getParameterTypes());
        }
        return this.parameters;
    }

    protected Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<?>[] getParametersTypes(Class<?> clazz) {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.getParameterTypes();
            if (this.parameterTypes == null) {
                this.parameterTypes = Signature.stringsToClasses(clazz, this.parameters);
            }
        }
        return this.parameterTypes;
    }

    public boolean equals(Object obj) {
        String[] otherParameters;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        String[] thisParameters = this.getParameters();
        if (thisParameters.length != (otherParameters = other.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < thisParameters.length; ++i) {
            if (thisParameters[i].equals(otherParameters[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            this.cachedHashCode = this.toString().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.internalToString(builder);
        return builder.toString();
    }

    protected void internalToString(StringBuilder builder) {
        String[] parameters;
        if (this.name != null) {
            builder.append(this.getName());
        }
        if ((parameters = this.getParameters()) != null) {
            builder.append(Arrays.asList(parameters));
        }
    }
}

