/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.dynamicgenadvisor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.metadata.DynamicSimpleClassMetadataLoader;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.dynamicgenadvisor.Interceptions;
import org.jboss.test.aop.dynamicgenadvisor.MetadataInterceptor;
import org.jboss.test.aop.dynamicgenadvisor.MyInterceptor;
import org.jboss.test.aop.dynamicgenadvisor.POJO;
import org.jboss.test.aop.dynamicgenadvisor.SubPOJO;
import org.jboss.test.aop.dynamicgenadvisor.YourInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("DynamicTester");
        suite.addTestSuite(DynamicTester.class);
        return suite;
    }

    public DynamicTester(String name) {
        super(name);
    }

    public void testNotAdvised() throws Exception {
        System.out.println("TEST NOT ADVISED");
        Interceptions.clear();
        POJO pojo = new POJO();
        pojo.i = 10;
        POJO.j = 20;
        pojo.someMethod(123L);
        pojo.notPrepared();
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    public void testConstructor() throws Exception {
        System.out.println("TEST CONSTRUCTOR");
        Interceptions.clear();
        AdviceBinding binding = new AdviceBinding("execution(org.jboss.test.aop.dynamicgenadvisor.POJO->new())", null);
        String name = binding.getName();
        binding.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding);
        POJO pojo = new POJO();
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyInterceptor", "POJO"), (String)Interceptions.get(0));
        AdviceBinding binding2 = new AdviceBinding("execution(org.jboss.test.aop.dynamicgenadvisor.POJO->new())", null);
        String name2 = binding2.getName();
        AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
        binding2.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
        binding2.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding2);
        Interceptions.clear();
        pojo = new POJO();
        DynamicTester.assertEquals((String)Interceptions.getToString(), (int)3, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyInterceptor", "POJO"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyAspect", "POJO"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyInterceptor", "POJO"), (String)Interceptions.get(2));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name);
        pojo = new POJO();
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyAspect", "POJO"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getConstructorName("MyInterceptor", "POJO"), (String)Interceptions.get(1));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name2);
        pojo = new POJO();
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    public void testConstruction() throws Exception {
        System.out.println("TEST CONSTRUCTION");
        Interceptions.clear();
        AdviceBinding binding = new AdviceBinding("construction(org.jboss.test.aop.dynamicgenadvisor.POJO->new())", null);
        String name = binding.getName();
        binding.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding);
        POJO pojo = new POJO();
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyInterceptor", "POJO"), (String)Interceptions.get(0));
        AdviceBinding binding2 = new AdviceBinding("construction(org.jboss.test.aop.dynamicgenadvisor.POJO->new())", null);
        String name2 = binding2.getName();
        AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
        binding2.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
        binding2.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding2);
        Interceptions.clear();
        pojo = new POJO();
        DynamicTester.assertEquals((int)3, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyInterceptor", "POJO"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyAspect", "POJO"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyInterceptor", "POJO"), (String)Interceptions.get(2));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name);
        pojo = new POJO();
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyAspect", "POJO"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getConstructionName("MyInterceptor", "POJO"), (String)Interceptions.get(1));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name2);
        pojo = new POJO();
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    public void testMethodExecution() throws Exception {
        System.out.println("TEST METHOD");
        Interceptions.clear();
        AdviceBinding binding = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
        String name = binding.getName();
        binding.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding);
        POJO pojo = new POJO();
        pojo.someMethod(123L);
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
        AdviceBinding binding2 = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
        String name2 = binding2.getName();
        AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
        binding2.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
        binding2.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding2);
        Interceptions.clear();
        pojo.someMethod(123L);
        DynamicTester.assertEquals((String)Interceptions.getToString(), (int)3, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(2));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name);
        pojo.someMethod(123L);
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(1));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name2);
        pojo.someMethod(123L);
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    public void testMethodExecutionWithInstanceAdvisorAccess() throws Exception {
        System.out.println("TEST METHOD WITH INSTANCEADVISOR ACCESS");
        AdviceBinding binding = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
        binding.addInterceptor(MetadataInterceptor.class);
        AspectManager.instance().addBinding(binding);
        POJO pojo = new POJO();
        MetadataInterceptor.clear();
        pojo.someMethod(123L);
        DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
        MetadataInterceptor.clear();
        AspectManager.instance().removeBinding(binding.getName());
        pojo.someMethod(123L);
        DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
    }

    public void testFields() throws Exception {
        System.out.println("TEST FIELDS");
        AdviceBinding binding = new AdviceBinding("set(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
        String name = binding.getName();
        binding.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding);
        Interceptions.clear();
        POJO pojo = new POJO();
        pojo.i = 5;
        DynamicTester.assertEquals((int)5, (int)pojo.i);
        POJO.j = 0;
        DynamicTester.assertEquals((int)0, (int)POJO.j);
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        AdviceBinding binding2 = new AdviceBinding("get(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
        String name2 = binding2.getName();
        binding2.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding2);
        Interceptions.clear();
        pojo.i = 5;
        DynamicTester.assertEquals((int)5, (int)pojo.i);
        ++POJO.j;
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
        AdviceBinding binding3 = new AdviceBinding("field(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
        String name3 = binding3.getName();
        AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
        binding3.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
        binding3.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding3);
        Interceptions.clear();
        pojo.i = 20;
        DynamicTester.assertEquals((int)3, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyAspect", "POJO", "i"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(2));
        Interceptions.clear();
        DynamicTester.assertEquals((int)20, (int)pojo.i);
        DynamicTester.assertEquals((int)3, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(2));
        AspectManager.instance().removeBinding(name);
        AspectManager.instance().removeBinding(name2);
        AdviceBinding binding4 = new AdviceBinding("field(static * org.jboss.test.aop.dynamicgenadvisor.POJO->j)", null);
        String name4 = binding4.getName();
        binding4.addInterceptor(MyInterceptor.class);
        AspectManager.instance().addBinding(binding4);
        Interceptions.clear();
        pojo.i = 15;
        DynamicTester.assertEquals((int)15, (int)pojo.i);
        DynamicTester.assertEquals((int)4, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyAspect", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(2));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(3));
        Interceptions.clear();
        DynamicTester.assertEquals((int)2, (int)(++POJO.j));
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "j"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "j"), (String)Interceptions.get(1));
        Interceptions.clear();
        AspectManager.instance().removeBinding(name3);
        AspectManager.instance().removeBinding(name4);
        ++pojo.i;
        ++POJO.j;
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    public void testSimpleInstanceUsingDomainForMethod() throws Exception {
        System.out.println("TEST SIMPLE INSTANCE USING DOMAIN FOR METHOD");
        POJO pojo1 = new POJO();
        POJO pojo2 = new POJO();
        AdviceBinding binding = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
        String name = binding.getName();
        binding.addInterceptor(MyInterceptor.class);
        this.getInstanceDomain(pojo2).addBinding(binding);
        Interceptions.clear();
        pojo1.someMethod(123L);
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
        Interceptions.clear();
        pojo2.someMethod(123L);
        DynamicTester.assertEquals((String)Interceptions.getToString(), (int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
        this.getInstanceDomain(pojo2).removeBinding(name);
        Interceptions.clear();
        pojo1.someMethod(123L);
        pojo2.someMethod(123L);
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstanceUsingDomainForMethod() throws Exception {
        String nameTopB;
        block5: {
            String nameTopA = null;
            nameTopB = null;
            try {
                System.out.println("TEST INSTANCE USING DOMAIN FOR METHOD");
                AdviceBinding bindingTopA = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
                nameTopA = bindingTopA.getName();
                bindingTopA.addInterceptor(MyInterceptor.class);
                AspectManager.instance().addBinding(bindingTopA);
                POJO pojo1 = new POJO();
                POJO pojo2 = new POJO();
                Interceptions.clear();
                pojo1.someMethod(123L);
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(1));
                AdviceBinding bindingA = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
                String nameA = bindingA.getName();
                bindingA.addInterceptor(MyInterceptor.class);
                this.getInstanceDomain(pojo1).addBinding(bindingA);
                AdviceBinding bindingB = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
                String nameB = bindingB.getName();
                AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
                bindingB.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
                this.getInstanceDomain(pojo2).addBinding(bindingB);
                System.out.println("Added instance advices");
                Interceptions.clear();
                pojo1.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(1));
                Interceptions.clear();
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
                POJO pojo3 = new POJO();
                AdviceBinding bindingTopB = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..))", null);
                nameTopB = bindingTopB.getName();
                bindingTopB.addInterceptor(YourInterceptor.class);
                AspectManager.instance().addBinding(bindingTopB);
                System.out.println("Added top level advice");
                Interceptions.clear();
                pojo1.someMethod(123L);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                Interceptions.printInterceptions();
                this.checkInterceptions(this.createExpectedList(Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), Interceptions.getMethodName("YourInterceptor", "POJO", "someMethod"), Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod")));
                Interceptions.clear();
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                this.checkInterceptions(this.createExpectedList(Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), Interceptions.getMethodName("YourInterceptor", "POJO", "someMethod"), Interceptions.getMethodName("MyAspect", "POJO", "someMethod")));
                Interceptions.clear();
                pojo3.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("YourInterceptor", "POJO", "someMethod"), (String)Interceptions.get(1));
                AspectManager.instance().removeBinding(nameTopB);
                Interceptions.clear();
                pojo1.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(1));
                Interceptions.clear();
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
                this.getInstanceDomain(pojo1).removeBinding(nameA);
                Interceptions.clear();
                pojo1.someMethod(123L);
                DynamicTester.assertEquals((int)1, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
                AspectManager.instance().removeBinding(nameTopA);
                Interceptions.clear();
                pojo1.someMethod(123L);
                DynamicTester.assertEquals((int)0, (int)Interceptions.size());
                Interceptions.clear();
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)1, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(0));
                this.getInstanceDomain(pojo2).removeBinding(nameB);
                Interceptions.clear();
                pojo1.someMethod(123L);
                pojo2.someMethod(123L);
                DynamicTester.assertEquals((int)0, (int)Interceptions.size());
                if (nameTopA == null) break block5;
            }
            catch (Throwable throwable) {
                if (nameTopA != null) {
                    AspectManager.instance().removeBinding(nameTopA);
                }
                if (nameTopB != null) {
                    AspectManager.instance().removeBinding(nameTopB);
                }
                throw throwable;
            }
            AspectManager.instance().removeBinding(nameTopA);
        }
        if (nameTopB != null) {
            AspectManager.instance().removeBinding(nameTopB);
        }
    }

    public void testSimpleInstanceUsingDomainForField() throws Exception {
        System.out.println("TEST SIMPLE INSTANCE USING DOMAIN FOR FIELD");
        POJO pojo1 = new POJO();
        POJO pojo2 = new POJO();
        AdviceBinding binding = new AdviceBinding("set(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
        String name = binding.getName();
        AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
        binding.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
        this.getInstanceDomain(pojo2).addBinding(binding);
        Interceptions.clear();
        pojo1.i = 10;
        DynamicTester.assertEquals((int)10, (int)pojo1.i);
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
        Interceptions.clear();
        pojo2.i = 20;
        DynamicTester.assertEquals((int)20, (int)pojo2.i);
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyAspect", "POJO", "i"), (String)Interceptions.get(0));
        AdviceBinding binding2 = new AdviceBinding("get(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
        String name2 = binding2.getName();
        binding2.addInterceptor(MyInterceptor.class);
        this.getInstanceDomain(pojo2).addBinding(binding2);
        Interceptions.clear();
        pojo2.i = 30;
        DynamicTester.assertEquals((int)30, (int)pojo2.i);
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyAspect", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
        this.getInstanceDomain(pojo2).removeBinding(name);
        Interceptions.clear();
        pojo1.i = 15;
        DynamicTester.assertEquals((int)15, (int)pojo1.i);
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
        pojo2.i = 40;
        DynamicTester.assertEquals((int)0, (int)Interceptions.size());
        DynamicTester.assertEquals((int)40, (int)pojo2.i);
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        this.getInstanceDomain(pojo2).removeBinding(name2);
        Interceptions.clear();
        pojo1.i = pojo2.i;
        pojo2.i = pojo2.i;
        DynamicTester.assertTrue((boolean)Interceptions.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstanceUsingDomainForField() throws Exception {
        String nameTopB;
        block5: {
            String nameTopA = null;
            nameTopB = null;
            try {
                System.out.println("TEST INSTANCE USING DOMAIN FOR FIELD");
                AdviceBinding bindingTopA = new AdviceBinding("field(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
                nameTopA = bindingTopA.getName();
                bindingTopA.addInterceptor(MyInterceptor.class);
                AspectManager.instance().addBinding(bindingTopA);
                POJO pojo1 = new POJO();
                POJO pojo2 = new POJO();
                Interceptions.clear();
                pojo1.i = 10;
                pojo2.i = 20;
                DynamicTester.assertEquals((int)10, (int)pojo1.i);
                DynamicTester.assertEquals((int)20, (int)pojo2.i);
                DynamicTester.assertEquals((int)4, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(2));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(3));
                AdviceBinding bindingA = new AdviceBinding("set(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
                String nameA = bindingA.getName();
                bindingA.addInterceptor(MyInterceptor.class);
                this.getInstanceDomain(pojo1).addBinding(bindingA);
                AdviceBinding bindingB = new AdviceBinding("get(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
                String nameB = bindingB.getName();
                AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
                bindingB.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
                this.getInstanceDomain(pojo2).addBinding(bindingB);
                System.out.println("Added instance advices");
                Interceptions.clear();
                pojo1.i = 50;
                DynamicTester.assertEquals((int)50, (int)pojo1.i);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(2));
                Interceptions.clear();
                pojo2.i = 100;
                DynamicTester.assertEquals((int)100, (int)pojo2.i);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(2));
                POJO pojo3 = new POJO();
                AdviceBinding bindingTopB = new AdviceBinding("field(* org.jboss.test.aop.dynamicgenadvisor.POJO->i)", null);
                nameTopB = bindingTopB.getName();
                bindingTopB.addInterceptor(YourInterceptor.class);
                AspectManager.instance().addBinding(bindingTopB);
                System.out.println("Added top level advice");
                Interceptions.clear();
                pojo1.i = 66;
                DynamicTester.assertEquals((int)66, (int)pojo1.i);
                DynamicTester.assertEquals((int)5, (int)Interceptions.size());
                this.checkInterceptions(this.createExpectedList(Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), Interceptions.getFieldReadName("YourInterceptor", "POJO", "i")));
                Interceptions.clear();
                pojo2.i = 99;
                DynamicTester.assertEquals((int)99, (int)pojo2.i);
                DynamicTester.assertEquals((int)5, (int)Interceptions.size());
                this.checkInterceptions(this.createExpectedList(Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), Interceptions.getFieldReadName("MyAspect", "POJO", "i")));
                Interceptions.clear();
                pojo3.i = 12;
                DynamicTester.assertEquals((int)12, (int)pojo3.i);
                DynamicTester.assertEquals((int)4, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(2));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(3));
                AspectManager.instance().removeBinding(nameTopA);
                Interceptions.clear();
                pojo1.i = 50;
                DynamicTester.assertEquals((int)50, (int)pojo1.i);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(2));
                Interceptions.clear();
                pojo2.i = 100;
                DynamicTester.assertEquals((int)100, (int)pojo2.i);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(2));
                System.out.println("================> removing binding");
                this.getInstanceDomain(pojo1).removeBinding(nameA);
                Interceptions.clear();
                pojo1.i = 50;
                DynamicTester.assertEquals((int)50, (int)pojo1.i);
                Interceptions.printInterceptions();
                DynamicTester.assertEquals((int)2, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                Interceptions.clear();
                pojo2.i = 100;
                DynamicTester.assertEquals((int)100, (int)pojo2.i);
                DynamicTester.assertEquals((int)3, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(0));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("YourInterceptor", "POJO", "i"), (String)Interceptions.get(1));
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(2));
                AspectManager.instance().removeBinding(nameTopB);
                Interceptions.clear();
                pojo1.i = 14;
                DynamicTester.assertEquals((int)14, (int)pojo1.i);
                pojo2.i = 100;
                DynamicTester.assertEquals((int)100, (int)pojo2.i);
                DynamicTester.assertEquals((int)1, (int)Interceptions.size());
                DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyAspect", "POJO", "i"), (String)Interceptions.get(0));
                this.getInstanceDomain(pojo2).removeBinding(nameB);
                Interceptions.clear();
                pojo1.i = 123;
                DynamicTester.assertEquals((int)123, (int)pojo1.i);
                pojo2.i = 123;
                DynamicTester.assertEquals((int)123, (int)pojo2.i);
                DynamicTester.assertEquals((int)0, (int)Interceptions.size());
                if (nameTopA == null) break block5;
            }
            catch (Throwable throwable) {
                if (nameTopA != null) {
                    AspectManager.instance().removeBinding(nameTopA);
                }
                if (nameTopB != null) {
                    AspectManager.instance().removeBinding(nameTopB);
                }
                throw throwable;
            }
            AspectManager.instance().removeBinding(nameTopA);
        }
        if (nameTopB != null) {
            AspectManager.instance().removeBinding(nameTopB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstanceUsingOldApiForMethod() throws Exception {
        System.out.println("TEST INSTANCE USING OLD API FOR METHOD");
        POJO pojo1 = new POJO();
        AdviceBinding bindingTopA = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.*POJO->someMethod*(..))", null);
        String nameTopA = bindingTopA.getName();
        try {
            AspectDefinition myAspect = AspectManager.instance().getAspectDefinition("org.jboss.test.aop.dynamicgenadvisor.MyAspect");
            bindingTopA.addInterceptorFactory((InterceptorFactory)new AdviceFactory(myAspect, "intercept"));
            AspectManager.instance().addBinding(bindingTopA);
            Interceptions.clear();
            pojo1.someMethod(123L);
            DynamicTester.assertEquals((int)1, (int)Interceptions.size());
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(0));
            System.out.println("---- Adding more interceptors");
            InstanceAdvisor pojoIa1 = ((Advised)pojo1)._getInstanceAdvisor();
            pojoIa1.insertInterceptor((Interceptor)new MyInterceptor());
            Interceptions.clear();
            pojo1.someMethod(123L);
            DynamicTester.assertEquals((int)2, (int)Interceptions.size());
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
            pojoIa1.appendInterceptor((Interceptor)new YourInterceptor());
            Interceptions.clear();
            pojo1.someMethod(123L);
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
            DynamicTester.assertEquals((String)Interceptions.getMethodName("YourInterceptor", "POJO", "someMethod"), (String)Interceptions.get(2));
            System.out.println("Testing SubPOJO");
            SubPOJO sub1 = new SubPOJO();
            Interceptions.clear();
            sub1.someMethod(123L);
            DynamicTester.assertEquals((int)1, (int)Interceptions.size());
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(0));
            InstanceAdvisor subPojoIa1 = ((Advised)sub1)._getInstanceAdvisor();
            subPojoIa1.insertInterceptor((Interceptor)new MyInterceptor());
            subPojoIa1.appendInterceptor((Interceptor)new YourInterceptor());
            Interceptions.clear();
            sub1.someMethod(123L);
            DynamicTester.assertEquals((int)3, (int)Interceptions.size());
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
            DynamicTester.assertEquals((String)Interceptions.getMethodName("MyAspect", "POJO", "someMethod"), (String)Interceptions.get(1));
            DynamicTester.assertEquals((String)Interceptions.getMethodName("YourInterceptor", "POJO", "someMethod"), (String)Interceptions.get(2));
        }
        finally {
            AspectManager.instance().removeBinding(nameTopA);
        }
    }

    public void testAddAnnotation() throws Exception {
        System.out.println("TEST ADD ANNOTATION TO INSTANCE");
        POJO pojo1 = new POJO();
        POJO pojo2 = new POJO();
        POJO pojo3 = new POJO();
        POJO pojo4 = new POJO();
        AnnotationIntroduction intro1 = AnnotationIntroduction.createClassAnnotationIntroduction((String)"org.jboss.test.aop.dynamicgenadvisor.POJO", (String)"@org.jboss.test.aop.dynamicgenadvisor.MyAnnotation", (boolean)true);
        this.getInstanceDomain(pojo1).addAnnotationOverride(intro1);
        AdviceBinding binding1 = new AdviceBinding("execution(* @org.jboss.test.aop.dynamicgenadvisor.MyAnnotation->someMethod*(..))", null);
        binding1.addInterceptor(MyInterceptor.class);
        this.getInstanceDomain(pojo1).addBinding(binding1);
        AnnotationIntroduction intro2 = AnnotationIntroduction.createFieldAnnotationIntroduction((String)"int org.jboss.test.aop.dynamicgenadvisor.POJO->i", (String)"@org.jboss.test.aop.dynamicgenadvisor.MyAnnotation", (boolean)true);
        this.getInstanceDomain(pojo2).addAnnotationOverride(intro2);
        AdviceBinding binding2 = new AdviceBinding("field(* org.jboss.test.aop.dynamicgenadvisor.POJO->@org.jboss.test.aop.dynamicgenadvisor.MyAnnotation)", null);
        binding2.addInterceptor(MyInterceptor.class);
        this.getInstanceDomain(pojo2).addBinding(binding2);
        AnnotationIntroduction intro3 = AnnotationIntroduction.createMethodAnnotationIntroduction((String)"* org.jboss.test.aop.dynamicgenadvisor.POJO->someMethod(..)", (String)"@org.jboss.test.aop.dynamicgenadvisor.MyAnnotation", (boolean)true);
        this.getInstanceDomain(pojo3).addAnnotationOverride(intro3);
        AdviceBinding binding3 = new AdviceBinding("execution(* org.jboss.test.aop.dynamicgenadvisor.POJO->@org.jboss.test.aop.dynamicgenadvisor.MyAnnotation(..))", null);
        binding3.addInterceptor(MyInterceptor.class);
        this.getInstanceDomain(pojo3).addBinding(binding3);
        System.out.println("--- POJO1");
        Interceptions.clear();
        pojo1.someMethod(123L);
        pojo1.notPrepared();
        pojo1.i = pojo1.i;
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
        System.out.println("--- POJO2");
        Interceptions.clear();
        pojo2.someMethod(123L);
        pojo2.notPrepared();
        pojo2.i = pojo2.i;
        DynamicTester.assertEquals((int)2, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getFieldReadName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(0));
        DynamicTester.assertEquals((String)Interceptions.getFieldWriteName("MyInterceptor", "POJO", "i"), (String)Interceptions.get(1));
        System.out.println("--- POJO3");
        Interceptions.clear();
        pojo3.someMethod(123L);
        pojo3.notPrepared();
        pojo3.i = pojo3.i;
        DynamicTester.assertEquals((int)1, (int)Interceptions.size());
        DynamicTester.assertEquals((String)Interceptions.getMethodName("MyInterceptor", "POJO", "someMethod"), (String)Interceptions.get(0));
        System.out.println("--- POJO4");
        Interceptions.clear();
        pojo4.someMethod(123L);
        pojo4.notPrepared();
        pojo4.i = pojo4.i;
        DynamicTester.assertEquals((int)0, (int)Interceptions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddClassMetadata() throws Exception {
        AdviceBinding binding = null;
        try {
            System.out.println("TEST ADD CLASS METADATA");
            DynamicSimpleClassMetadataLoader loader = new DynamicSimpleClassMetadataLoader("T1", "TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
            loader.addDefaultMetaData("default", (Object)"default");
            loader.addClassMetaData("class", (Object)"class");
            loader.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethod");
            loader.addFieldMetaData("i", "fm", (Object)"i");
            AspectManager.instance().addClassMetaData(loader.getClassMetaDataBinding());
            binding = new AdviceBinding("all(org.jboss.test.aop.dynamicgenadvisor.POJO)", null);
            binding.addInterceptor(MetadataInterceptor.class);
            AspectManager.instance().addBinding(binding);
            POJO pojo = new POJO();
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            pojo.i = 100;
            pojo.notPrepared();
            DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
            DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
            DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
            AspectManager.instance().removeClassMetaData(loader.getClassMetaDataBinding().getName());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            pojo.i = 100;
            pojo.notPrepared();
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastFieldMetadata.size());
            AspectManager.instance().addClassMetaData(loader.getClassMetaDataBinding());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            pojo.i = 100;
            pojo.notPrepared();
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
            DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
            DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
            AspectManager.instance().removeClassMetaData(loader.getClassMetaDataBinding().getName());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            pojo.i = 100;
            pojo.notPrepared();
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastFieldMetadata.size());
            AspectManager.instance().removeBinding(binding.getName());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
        }
        finally {
            if (binding != null) {
                AspectManager.instance().removeBinding(binding.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindingsUpdatedWhenAddMetadata() throws Exception {
        AdviceBinding binding = null;
        try {
            System.out.println("TEST BINDINGS UPDATED WHEN ADD METADATA");
            binding = new AdviceBinding("all(@TEST)", null);
            binding.addInterceptor(MetadataInterceptor.class);
            AspectManager.instance().addBinding(binding);
            MetadataInterceptor.clear();
            POJO pojox = new POJO();
            pojox.someMethod(123L);
            DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
            DynamicSimpleClassMetadataLoader loader = new DynamicSimpleClassMetadataLoader("DA", "TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
            loader.addDefaultMetaData("default", (Object)"default");
            loader.addClassMetaData("class", (Object)"class");
            loader.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethod");
            loader.addFieldMetaData("i", "fm", (Object)"i");
            AspectManager.instance().addClassMetaData(loader.getClassMetaDataBinding());
            MetadataInterceptor.clear();
            POJO pojo = new POJO();
            pojo.someMethod(123L);
            int i = pojo.i;
            DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
            DynamicTester.assertEquals((int)3, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)3, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(2));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(2));
            DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
            DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
            MetadataInterceptor.clear();
            pojox.someMethod(123L);
            DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
            AspectManager.instance().removeClassMetaData("DA");
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            pojo.i = 100;
            DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
            this.getInstanceDomain(pojo).addClassMetaData(loader.getClassMetaDataBinding());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            i = pojo.i;
            DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
            DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
            DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
            DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
            DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
            DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
            DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
            this.getInstanceDomain(pojo).removeClassMetaData(loader.getClassMetaDataBinding().getName());
            AspectManager.instance().removeBinding(binding.getName());
            MetadataInterceptor.clear();
            pojo.someMethod(123L);
            DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
        }
        finally {
            if (binding != null) {
                AspectManager.instance().removeBinding(binding.getName());
            }
        }
    }

    public void testAddInstanceMetadata() throws Exception {
        System.out.println("TEST ADD METADATA TO INSTANCE");
        POJO pojo1 = new POJO();
        POJO pojo2 = new POJO();
        POJO pojo3 = new POJO();
        DynamicSimpleClassMetadataLoader loader1 = new DynamicSimpleClassMetadataLoader("D1", "TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
        loader1.addDefaultMetaData("default", (Object)"default1");
        loader1.addClassMetaData("class", (Object)"class1");
        loader1.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethod1");
        loader1.addFieldMetaData("i", "fm", (Object)"i1");
        DynamicSimpleClassMetadataLoader loader2 = new DynamicSimpleClassMetadataLoader("D1", "TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
        loader2.addDefaultMetaData("default", (Object)"default2");
        loader2.addClassMetaData("class", (Object)"class2");
        loader2.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethod2");
        loader2.addFieldMetaData("i", "fm", (Object)"i2");
        this.getInstanceDomain(pojo1).addClassMetaData(loader1.getClassMetaDataBinding());
        AdviceBinding binding1 = new AdviceBinding("all(@TEST)", null);
        binding1.addInterceptor(MetadataInterceptor.class);
        this.getInstanceDomain(pojo1).addBinding(binding1);
        AdviceBinding binding2 = new AdviceBinding("all(@TEST)", null);
        this.getInstanceDomain(pojo2).addClassMetaData(loader2.getClassMetaDataBinding());
        binding2.addInterceptor(MetadataInterceptor.class);
        this.getInstanceDomain(pojo2).addBinding(binding2);
        AdviceBinding binding3 = new AdviceBinding("all(org.jboss.test.aop.dynamicgenadvisor.POJO)", null);
        binding3.addInterceptor(MetadataInterceptor.class);
        this.getInstanceDomain(pojo3).addBinding(binding3);
        MetadataInterceptor.clear();
        System.out.println("---POJO1 set i");
        pojo1.i = 10;
        System.out.println("---POJO1 someMethod");
        pojo1.someMethod(123L);
        System.out.println("---POJO1 not Prepared");
        pojo1.notPrepared();
        System.out.println("---POJO2 set i");
        pojo2.i = 20;
        System.out.println("---POJO2 someMethod");
        pojo2.someMethod(123L);
        System.out.println("---POJO2 not Prepared");
        pojo2.notPrepared();
        DynamicTester.assertEquals((int)4, (int)MetadataInterceptor.lastDefaultMetadata.size());
        DynamicTester.assertEquals((int)4, (int)MetadataInterceptor.lastClassMetadata.size());
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastMethodMetadata.size());
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastFieldMetadata.size());
        DynamicTester.assertEquals((Object)"default1", MetadataInterceptor.lastDefaultMetadata.get(0));
        DynamicTester.assertEquals((Object)"default1", MetadataInterceptor.lastDefaultMetadata.get(1));
        DynamicTester.assertEquals((Object)"default2", MetadataInterceptor.lastDefaultMetadata.get(2));
        DynamicTester.assertEquals((Object)"default2", MetadataInterceptor.lastDefaultMetadata.get(3));
        DynamicTester.assertEquals((Object)"class1", MetadataInterceptor.lastClassMetadata.get(0));
        DynamicTester.assertEquals((Object)"class1", MetadataInterceptor.lastClassMetadata.get(1));
        DynamicTester.assertEquals((Object)"class2", MetadataInterceptor.lastClassMetadata.get(2));
        DynamicTester.assertEquals((Object)"class2", MetadataInterceptor.lastClassMetadata.get(3));
        DynamicTester.assertEquals((Object)"someMethod1", MetadataInterceptor.lastMethodMetadata.get(0));
        DynamicTester.assertEquals((Object)"someMethod2", MetadataInterceptor.lastMethodMetadata.get(1));
        DynamicTester.assertEquals((Object)"i1", MetadataInterceptor.lastFieldMetadata.get(0));
        DynamicTester.assertEquals((Object)"i2", MetadataInterceptor.lastFieldMetadata.get(1));
        MetadataInterceptor.clear();
        System.out.println("---POJO3 set i");
        pojo3.i = 20;
        System.out.println("---POJO3 someMethod");
        pojo3.someMethod(123L);
        System.out.println("---POJO3 not Prepared");
        pojo3.notPrepared();
        DynamicTester.assertTrue((boolean)MetadataInterceptor.intercepted);
        DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastDefaultMetadata.size());
        DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastClassMetadata.size());
        DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastMethodMetadata.size());
        DynamicTester.assertEquals((int)0, (int)MetadataInterceptor.lastFieldMetadata.size());
    }

    public void testInstanceMetadataOverrides() throws Exception {
        System.out.println("TEST INSTANCE METADATA OVERRIDES");
        MetadataInterceptor.clear();
        POJO pojo = new POJO();
        POJO pojo1 = new POJO();
        pojo.someMethod(123L);
        DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
        AdviceBinding binding1 = new AdviceBinding("all(org.jboss.test.aop.dynamicgenadvisor.POJO)", null);
        binding1.addInterceptor(MetadataInterceptor.class);
        AspectManager.instance().addBinding(binding1);
        DynamicSimpleClassMetadataLoader loader = new DynamicSimpleClassMetadataLoader("TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
        loader.addDefaultMetaData("default", (Object)"default");
        loader.addClassMetaData("class", (Object)"class");
        loader.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethod");
        loader.addFieldMetaData("i", "fm", (Object)"i");
        AspectManager.instance().addClassMetaData(loader.getClassMetaDataBinding());
        DynamicSimpleClassMetadataLoader instanceLoader = new DynamicSimpleClassMetadataLoader("TEST", "org.jboss.test.aop.dynamicgenadvisor.POJO");
        instanceLoader.addDefaultMetaData("default", (Object)"defaultXXX");
        instanceLoader.addClassMetaData("class", (Object)"classXXX");
        instanceLoader.addMethodMetaData("* someMethod(..)", "fm", (Object)"someMethodXXX");
        instanceLoader.addFieldMetaData("i", "fm", (Object)"iXXX");
        this.getInstanceDomain(pojo1).addClassMetaData(instanceLoader.getClassMetaDataBinding());
        MetadataInterceptor.clear();
        pojo.someMethod(123L);
        pojo.i = 1000;
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
        DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
        DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
        DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
        DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
        DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
        DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
        MetadataInterceptor.clear();
        pojo1.someMethod(123L);
        pojo1.i = 1000;
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
        DynamicTester.assertEquals((Object)"defaultXXX", MetadataInterceptor.lastDefaultMetadata.get(0));
        DynamicTester.assertEquals((Object)"defaultXXX", MetadataInterceptor.lastDefaultMetadata.get(1));
        DynamicTester.assertEquals((Object)"classXXX", MetadataInterceptor.lastClassMetadata.get(0));
        DynamicTester.assertEquals((Object)"classXXX", MetadataInterceptor.lastClassMetadata.get(1));
        DynamicTester.assertEquals((Object)"someMethodXXX", MetadataInterceptor.lastMethodMetadata.get(0));
        DynamicTester.assertEquals((Object)"iXXX", MetadataInterceptor.lastFieldMetadata.get(0));
        this.getInstanceDomain(pojo1).removeClassMetaData(instanceLoader.getClassMetaDataBinding().getName());
        MetadataInterceptor.clear();
        pojo1.someMethod(123L);
        pojo1.i = 1000;
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastDefaultMetadata.size());
        DynamicTester.assertEquals((int)2, (int)MetadataInterceptor.lastClassMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastMethodMetadata.size());
        DynamicTester.assertEquals((int)1, (int)MetadataInterceptor.lastFieldMetadata.size());
        DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(0));
        DynamicTester.assertEquals((Object)"default", MetadataInterceptor.lastDefaultMetadata.get(1));
        DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(0));
        DynamicTester.assertEquals((Object)"class", MetadataInterceptor.lastClassMetadata.get(1));
        DynamicTester.assertEquals((Object)"someMethod", MetadataInterceptor.lastMethodMetadata.get(0));
        DynamicTester.assertEquals((Object)"i", MetadataInterceptor.lastFieldMetadata.get(0));
        AspectManager.instance().removeClassMetaData(loader.getClassMetaDataBinding().getName());
        AspectManager.instance().removeBinding(binding1.getName());
        MetadataInterceptor.clear();
        pojo.someMethod(123L);
        DynamicTester.assertFalse((boolean)MetadataInterceptor.intercepted);
    }

    private Domain getInstanceDomain(Object obj) {
        Advised advised = (Advised)obj;
        InstanceAdvisor advisor = advised._getInstanceAdvisor();
        return advisor.getDomain();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DynamicTester.suite());
    }

    private List<String> createExpectedList(String ... elements) {
        return Arrays.asList(elements);
    }

    private void checkInterceptions(List<String> expected) {
        ArrayList<String> buf = new ArrayList<String>();
        buf.addAll(expected);
        DynamicTester.assertEquals((int)buf.size(), (int)Interceptions.size());
        for (int i = 0; i < Interceptions.size(); ++i) {
            String name = Interceptions.get(i);
            boolean found = false;
            Iterator it = buf.iterator();
            while (it.hasNext()) {
                String expectedName = (String)it.next();
                if (expectedName.equals(name)) {
                    it.remove();
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            DynamicTester.fail((String)("Unexpected interception " + name));
        }
    }
}

