/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.unit.classpool.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.aop.util.ClassLoaderUtils;

public class ClassLoaderUtilsTestCase
extends TestCase {
    public static Test suite() {
        return new TestSuite(ClassLoaderUtilsTestCase.class);
    }

    public ClassLoaderUtilsTestCase(String name) {
        super(name);
    }

    public void testClassResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test.class", (String)name);
    }

    public void testInnerClassResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test$Inner");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test$Inner.class", (String)name);
    }

    public void testClassArrayResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test[]");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test.class", (String)name);
    }

    public void testInnerClassArrayResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test$Inner[]");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test$Inner.class", (String)name);
    }

    public void testClass2DArrayResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test[][]");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test.class", (String)name);
    }

    public void testInnerClass2DArrayResourceName() {
        String name = ClassLoaderUtils.getResourceName((String)"org.acme.Test$Inner[][]");
        ClassLoaderUtilsTestCase.assertEquals((String)"org/acme/Test$Inner.class", (String)name);
    }

    public void testClassPackageName() {
        String name = ClassLoaderUtils.getPackageName((String)"org.acme.Test");
        ClassLoaderUtilsTestCase.assertEquals((String)"org.acme", (String)name);
    }

    public void testInnerClassPackageName() {
        String name = ClassLoaderUtils.getPackageName((String)"org.acme.Test$Inner");
        ClassLoaderUtilsTestCase.assertEquals((String)"org.acme", (String)name);
    }
}

