/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPCLassPoolSearchStrategy;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.aop.util.ClassLoaderUtils;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPClassPool
extends ScopedClassPool {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final ConcurrentHashMap<String, String> generatedClasses = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Boolean> localResources = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Boolean> loadedButNotWovenClasses = new ConcurrentHashMap();
    public static final Class<SearchAllRegisteredLoadersSearchStrategy> SEARCH_ALL_STRATEGY = SearchAllRegisteredLoadersSearchStrategy.class;
    public static final Class<SearchLocalLoaderLoaderSearchStrategy> SEARCH_LOCAL_ONLY_STRATEGY = SearchLocalLoaderLoaderSearchStrategy.class;
    private final AOPCLassPoolSearchStrategy searchStrategy;

    public AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected AOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        this(null, src, repository, true);
    }

    private AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        this(cl, src, repository, SEARCH_ALL_STRATEGY, isTemp);
    }

    public AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, Class<? extends AOPCLassPoolSearchStrategy> searchStrategy) {
        this(cl, src, repository, searchStrategy, false);
    }

    public AOPClassPool(ClassPool src, ScopedClassPoolRepository repository, Class<? extends AOPCLassPoolSearchStrategy> searchStrategy) {
        this(null, src, repository, searchStrategy, true);
    }

    private AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, Class<? extends AOPCLassPoolSearchStrategy> searchStrategy, boolean isTemp) {
        super(cl, src, repository, isTemp);
        if (searchStrategy == SEARCH_ALL_STRATEGY) {
            this.searchStrategy = new SearchAllRegisteredLoadersSearchStrategy();
        } else if (searchStrategy == SEARCH_LOCAL_ONLY_STRATEGY) {
            this.searchStrategy = new SearchLocalLoaderLoaderSearchStrategy();
        } else {
            try {
                this.searchStrategy = searchStrategy.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating search strategy class " + searchStrategy, e);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this + " creating pool for loader " + cl + " searchStrategy:" + this.searchStrategy + " isTemp:" + isTemp);
        }
    }

    public void registerGeneratedClass(String className) {
        this.generatedClasses.put(className, className);
    }

    public boolean isGeneratedClass(String className) {
        return this.generatedClasses.containsKey(className);
    }

    public void doneGeneratingClass(String className) {
        this.generatedClasses.remove(className);
    }

    @Override
    public void close() {
        super.close();
        AOPClassPoolRepository.getInstance().perfomUnregisterClassLoader(this.getClassLoader());
    }

    @Override
    public CtClass getCached(String classname) {
        return this.searchStrategy.getCached(classname);
    }

    @Override
    public CtClass createCtClass(String classname, boolean useCache) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace(this + " attempting to create CtClass " + classname);
        }
        CtClass clazz = super.createCtClass(classname, useCache);
        if (trace) {
            this.logger.trace(this + " created CtClass " + this.getClassPoolLogStringForClass(clazz));
        }
        return clazz;
    }

    @Override
    public void cacheCtClass(String classname, CtClass c, boolean dynamic) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace(this + " caching " + classname);
        }
        super.cacheCtClass(classname, c, dynamic);
        if (dynamic) {
            if (trace) {
                this.logger.trace(this + " registering dynamic class " + classname);
            }
            this.doneGeneratingClass(classname);
            String resourcename = this.getResourceName(classname);
            this.localResources.put(resourcename, Boolean.TRUE);
        }
    }

    protected boolean includeInGlobalSearch() {
        return true;
    }

    protected String getResourceName(String classname) {
        return ClassLoaderUtils.getResourceName(classname);
    }

    protected final boolean isLocalResource(String resourceName, boolean trace) {
        String classResourceName = resourceName;
        Boolean isLocal = this.localResources.get(classResourceName);
        if (isLocal != null) {
            if (trace) {
                this.logger.trace(this + " " + resourceName + " is local " + isLocal);
            }
            return isLocal;
        }
        boolean localResource = this.isLocalClassLoaderResource(classResourceName);
        this.localResources.put(classResourceName, localResource ? Boolean.TRUE : Boolean.FALSE);
        if (trace) {
            this.logger.trace(this + " " + resourceName + " is local " + localResource);
        }
        return localResource;
    }

    protected boolean isLocalClassLoaderResource(String classResourceName) {
        return this.getClassLoader().getResource(classResourceName) != null;
    }

    @Override
    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace(this + " attempting local get for " + classname);
        }
        this.softcache.remove(classname);
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (trace && clazz != null) {
            this.logger.trace(this + " found " + classname + " in cache");
        }
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            this.lockInCache(clazz);
        }
        return clazz;
    }

    @Override
    protected CtClass getCachedLocally(String classname) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this + " checking local cache for " + classname);
        }
        return super.getCachedLocally(classname);
    }

    @Override
    public void lockInCache(CtClass c) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this + " locking in cache " + c.getName());
        }
        super.lockInCache(c);
    }

    public void setClassLoadedButNotWoven(String classname) {
        this.loadedButNotWovenClasses.put(classname, Boolean.TRUE);
    }

    public boolean isClassLoadedButNotWoven(String classname) {
        return this.loadedButNotWovenClasses.get(classname) == Boolean.TRUE;
    }

    public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(cl, src, repository);
    }

    public static AOPClassPool createAOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(src, repository);
    }

    @Override
    public String toString() {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoader();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this.getClass().getName() + "@" + System.identityHashCode(this) + " " + super.toString() + " - dcl:" + cl;
    }

    public CtClass internalGet0(String classname, boolean useCache) throws NotFoundException {
        return super.get0(classname, useCache);
    }

    protected String getClassPoolLogStringForClass(CtClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getClassPool() == null) {
            return null;
        }
        return clazz.getClassPool().toString();
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }

    private class SearchLocalLoaderLoaderSearchStrategy
    implements AOPCLassPoolSearchStrategy {
        Logger logger = Logger.getLogger(this.getClass());

        private SearchLocalLoaderLoaderSearchStrategy() {
        }

        public CtClass getCached(String classname) {
            boolean trace = this.logger.isTraceEnabled();
            if (trace) {
                this.logger.trace(this + " " + AOPClassPool.this + " searching just this pool for " + classname);
            }
            CtClass clazz = AOPClassPool.this.getCachedLocally(classname);
            if (trace) {
                this.logger.trace(this + " " + AOPClassPool.this + " found " + classname + " in pool" + AOPClassPool.this.getClassPoolLogStringForClass(clazz));
            }
            return clazz;
        }
    }

    private class SearchAllRegisteredLoadersSearchStrategy
    implements AOPCLassPoolSearchStrategy {
        Logger logger = Logger.getLogger(this.getClass());

        private SearchAllRegisteredLoadersSearchStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CtClass getCached(String classname) {
            CtClass clazz;
            boolean trace = this.logger.isTraceEnabled();
            if (trace) {
                this.logger.trace(this + " " + AOPClassPool.this + " searching all pools for " + classname);
            }
            if ((clazz = AOPClassPool.this.getCachedLocally(classname)) == null) {
                String o;
                boolean isLocal = false;
                ClassLoader cl = AOPClassPool.this.getClassLoader0();
                if (cl != null) {
                    isLocal = AOPClassPool.this.isLocalResource(AOPClassPool.this.getResourceName(classname), trace);
                }
                if (!isLocal && (o = AOPClassPool.this.generatedClasses.get(classname)) == null) {
                    Map<ClassLoader, ClassPool> registeredCLs;
                    Map<ClassLoader, ClassPool> map = registeredCLs = AspectManager.getRegisteredCLs();
                    synchronized (map) {
                        for (ClassPool pl : AspectManager.getRegisteredCLs().values()) {
                            AOPClassPool pool = (AOPClassPool)pl;
                            if (pool.isUnloadedClassLoader()) {
                                if (trace) {
                                    this.logger.trace(this + " pool is unloaded " + pool);
                                }
                                AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                                continue;
                            }
                            if (!pool.includeInGlobalSearch()) {
                                if (!trace) continue;
                                this.logger.trace(this + " pool is scoped " + pool);
                                continue;
                            }
                            if (trace) {
                                this.logger.trace(this + " " + AOPClassPool.this + " searching for " + classname + " in " + pool);
                            }
                            if ((clazz = pool.getCachedLocally(classname)) == null) continue;
                            break;
                        }
                    }
                }
            }
            if (trace) {
                this.logger.trace(this + " " + AOPClassPool.this + " found " + classname + " in pool" + AOPClassPool.this.getClassPoolLogStringForClass(clazz));
            }
            return clazz;
        }
    }
}

