/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.array;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.array.ArrayReference;
import org.jboss.aop.array.ArrayRegistry;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.array.ClassForReference;
import org.jboss.test.aop.array.TestArrayElementInterceptor;

public class ArrayReferenceTestCase
extends AOPTestWithSetup {
    public ArrayReferenceTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ArrayReferenceTestCase");
        suite.addTestSuite(ArrayReferenceTestCase.class);
        return suite;
    }

    public void testSimpleFieldReference() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        obj.fieldA = arr;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNull((Object)reference.getNestedArrayIndices());
        obj.fieldA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleFieldReferencesSameRootObjects() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        obj.fieldA = arr;
        obj.fieldB = arr;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<String> fields = new HashSet<String>();
        fields.add("fieldA");
        fields.add("fieldB");
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertEquals((Object)obj, (Object)owner);
            ArrayReferenceTestCase.assertTrue((String)("Expeced 'fieldA' or 'fieldB'; was " + ref.getRootField()), (ref.getRootField() == "fieldA" || ref.getRootField() == "fieldB" ? 1 : 0) != 0);
            ArrayReferenceTestCase.assertNull((Object)ref.getNestedArrayIndices());
            fields.remove(ref.getRootField());
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + fields), (fields.size() == 0 ? 1 : 0) != 0);
        obj.fieldA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldB", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNull((Object)reference.getNestedArrayIndices());
        obj.fieldB = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleFieldReferencesDifferentRootObjects() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        ClassForReference obj2 = new ClassForReference();
        obj.fieldA = arr;
        obj2.fieldB = arr;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<ClassForReference> rootObjects = new HashSet<ClassForReference>();
        rootObjects.add(obj);
        rootObjects.add(obj2);
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertTrue((String)("Expected " + obj + " or " + obj2 + "; was" + owner), (owner == obj || owner == obj2 ? 1 : 0) != 0);
            if (owner == obj) {
                ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)ref.getRootField());
            } else if (owner == obj2) {
                ArrayReferenceTestCase.assertEquals((String)"fieldB", (String)ref.getRootField());
            }
            ArrayReferenceTestCase.assertNull((Object)ref.getNestedArrayIndices());
            rootObjects.remove(owner);
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + rootObjects), (rootObjects.size() == 0 ? 1 : 0) != 0);
        obj.fieldA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj2, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldB", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNull((Object)reference.getNestedArrayIndices());
        obj2.fieldB = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleFieldReferencesStatic() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference.staticA = arr;
        ClassForReference.staticB = arr;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<String> fields = new HashSet<String>();
        fields.add("staticA");
        fields.add("staticB");
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)owner);
            ArrayReferenceTestCase.assertTrue((String)("Expected 'staticA' or 'staticB'; was " + ref.getRootField()), (ref.getRootField() == "staticA" || ref.getRootField() == "staticB" ? 1 : 0) != 0);
            ArrayReferenceTestCase.assertNull((Object)ref.getNestedArrayIndices());
            fields.remove(ref.getRootField());
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + fields), (fields.size() == 0 ? 1 : 0) != 0);
        ClassForReference.staticA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"staticB", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNull((Object)reference.getNestedArrayIndices());
        ClassForReference.staticB = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleFieldReferencesStaticAndNonStatic() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        obj.fieldA = arr;
        ClassForReference.staticA = arr;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<Object> rootObjects = new HashSet<Object>();
        rootObjects.add(obj);
        rootObjects.add(ClassForReference.class);
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertTrue((String)("Expected " + obj + " or " + ClassForReference.class + "; was" + owner), (owner == obj || owner == ClassForReference.class ? 1 : 0) != 0);
            if (owner == obj) {
                ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)ref.getRootField());
            } else if (owner == ClassForReference.class) {
                ArrayReferenceTestCase.assertEquals((String)"staticA", (String)ref.getRootField());
            }
            ArrayReferenceTestCase.assertNull((Object)ref.getNestedArrayIndices());
            rootObjects.remove(owner);
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + rootObjects), (rootObjects.size() == 0 ? 1 : 0) != 0);
        obj.fieldA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"staticA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNull((Object)reference.getNestedArrayIndices());
        ClassForReference.staticA = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testSimpleElementReferences() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        obj.fieldA = new Object[]{arr};
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertNotNull((Object)reference.getNestedArrayIndices());
        ArrayReferenceTestCase.assertEquals((int)1, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(0), reference.getNestedArrayIndices().get(0));
        obj.fieldA[0] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleElementReferencesSameArraySameRootObject() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        obj.fieldA = new Object[]{arr, null, arr};
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<Integer> indeces = new HashSet<Integer>();
        indeces.add(new Integer(0));
        indeces.add(new Integer(2));
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertEquals((Object)obj, (Object)owner);
            ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)ref.getRootField());
            ArrayReferenceTestCase.assertNotNull((Object)ref.getNestedArrayIndices());
            ArrayReferenceTestCase.assertEquals((int)1, (int)ref.getNestedArrayIndices().size());
            indeces.remove(ref.getNestedArrayIndices().get(0));
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + indeces), (indeces.size() == 0 ? 1 : 0) != 0);
        obj.fieldA[2] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)1, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(0), reference.getNestedArrayIndices().get(0));
        obj.fieldA[0] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleElementReferencesSameArrayDifferentRootObject() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference obj = new ClassForReference();
        ClassForReference obj2 = new ClassForReference();
        obj.fieldA = new Object[]{arr};
        obj2.fieldA = new Object[]{arr};
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<ClassForReference> owners = new HashSet<ClassForReference>();
        owners.add(obj);
        owners.add(obj2);
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)ref.getRootField());
            ArrayReferenceTestCase.assertNotNull((Object)ref.getNestedArrayIndices());
            ArrayReferenceTestCase.assertEquals((int)1, (int)ref.getNestedArrayIndices().size());
            ArrayReferenceTestCase.assertEquals((Object)new Integer(0), ref.getNestedArrayIndices().get(0));
            owners.remove(owner);
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + owners), (owners.size() == 0 ? 1 : 0) != 0);
        obj.fieldA[0] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj2, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)1, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(0), reference.getNestedArrayIndices().get(0));
        obj2.fieldA[0] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testMultipleElementReferencesStatic() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        Object[] arr = new Object[]{"1", "2", "3"};
        ClassForReference.staticA = new Object[]{arr};
        ClassForReference.staticB = new Object[]{null, arr};
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        HashSet<String> elements = new HashSet<String>();
        elements.add("staticA0");
        elements.add("staticB1");
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)owner);
            ArrayReferenceTestCase.assertNotNull((Object)ref.getNestedArrayIndices());
            ArrayReferenceTestCase.assertEquals((int)1, (int)ref.getNestedArrayIndices().size());
            elements.remove(ref.getRootField() + ref.getNestedArrayIndices().get(0));
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + elements), (elements.size() == 0 ? 1 : 0) != 0);
        ClassForReference.staticA[0] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"staticB", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)1, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(1), reference.getNestedArrayIndices().get(0));
        ClassForReference.staticB[1] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testNestedMultipleReferences() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        int[] arr = new int[]{1, 2, 3};
        ClassForReference obj = new ClassForReference();
        Object[][][][] fieldA = new Object[][][][]{null, null, {null, {null, null, {null, null, null, arr}}}};
        obj.fieldA = fieldA;
        Object[][][] staticA = new Object[][][]{{null, {null, null, {null, null, arr}}}, null};
        ClassForReference.staticA = staticA;
        String FIELDA = "fieldA2123";
        String STATICA = "staticA0122";
        HashSet<String> elements = new HashSet<String>();
        elements.add("fieldA2123");
        elements.add("staticA0122");
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)2, (int)references.size());
        for (ArrayReference ref : references) {
            Object owner = ref.getRootObject();
            ArrayReferenceTestCase.assertNotNull((Object)ref.getNestedArrayIndices());
            StringBuffer elem = new StringBuffer(ref.getRootField());
            List indices = ref.getNestedArrayIndices();
            for (Integer index : indices) {
                elem.append(index);
            }
            System.out.println("----> elem " + elem.toString());
            elements.remove(elem.toString());
            if (elem.toString().equals("staticA0122")) {
                ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)owner);
                continue;
            }
            if (!elem.toString().equals("fieldA2123")) continue;
            ArrayReferenceTestCase.assertEquals((Object)obj, (Object)owner);
        }
        ArrayReferenceTestCase.assertTrue((String)("Did not find all references " + elements), (elements.size() == 0 ? 1 : 0) != 0);
        fieldA[2][1][2][3] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals(ClassForReference.class, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"staticA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)4, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(0), reference.getNestedArrayIndices().get(0));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(1), reference.getNestedArrayIndices().get(1));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(2));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(3));
        ((Object[])staticA[0][1][2])[2] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testNestedReferencesRemoveAtHigherLevel() {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        int[] arr = new int[]{1, 2, 3};
        ClassForReference obj = new ClassForReference();
        Object[][][][] fieldA = new Object[][][][]{null, null, {null, {null, null, {null, null, null, arr}}}};
        obj.fieldA = fieldA;
        List references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertEquals((int)1, (int)references.size());
        ArrayReference reference = (ArrayReference)references.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)4, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(0));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(1), reference.getNestedArrayIndices().get(1));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(2));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(3), reference.getNestedArrayIndices().get(3));
        fieldA[2][1] = null;
        references = registry.getArrayOwners((Object)arr);
        ArrayReferenceTestCase.assertNull((Object)references);
    }

    public void testArrayReferenceFromInvocation() {
        ClassForReference obj = new ClassForReference();
        int[] arr = new int[]{1, 2, 3};
        Object[][][][] fieldA = new Object[][][][]{null, null, {null, {null, null, {null, null, null, null}}}};
        obj.fieldA = fieldA;
        TestArrayElementInterceptor.clear();
        fieldA[2][1][2][3] = "X";
        ArrayReferenceTestCase.assertEquals((int)1, (int)TestArrayElementInterceptor.owners.size());
        ArrayReference reference = TestArrayElementInterceptor.owners.get(0);
        ArrayReferenceTestCase.assertEquals((Object)obj, (Object)reference.getRootObject());
        ArrayReferenceTestCase.assertEquals((String)"fieldA", (String)reference.getRootField());
        ArrayReferenceTestCase.assertEquals((int)3, (int)reference.getNestedArrayIndices().size());
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(0));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(1), reference.getNestedArrayIndices().get(1));
        ArrayReferenceTestCase.assertEquals((Object)new Integer(2), reference.getNestedArrayIndices().get(2));
    }
}

