/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.dynamicgenadvisor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Interceptions {
    private static ArrayList interceptions = new ArrayList();

    public static void printInterceptions() {
        System.out.println(interceptions);
    }

    public static void clear() {
        interceptions.clear();
    }

    public static boolean isEmpty() {
        return interceptions.isEmpty();
    }

    public static int size() {
        return interceptions.size();
    }

    public static String get(int index) {
        return (String)interceptions.get(index);
    }

    public static void addConstructorInterception(Class aspect, Constructor c) {
        interceptions.add(Interceptions.getConstructorName(Interceptions.getClassName(aspect), c));
    }

    public static void addConstructionInterception(Class aspect, Constructor c) {
        interceptions.add(Interceptions.getConstructionName(Interceptions.getClassName(aspect), c));
    }

    public static void addMethodInterception(Class aspect, Method m) {
        interceptions.add(Interceptions.getMethodName(Interceptions.getClassName(aspect), m));
    }

    public static void addFieldReadInterception(Class aspect, Field f) {
        interceptions.add(Interceptions.getFieldReadName(Interceptions.getClassName(aspect), f));
    }

    public static void addFieldWriteInterception(Class aspect, Field f) {
        interceptions.add(Interceptions.getFieldWriteName(Interceptions.getClassName(aspect), f));
    }

    public static String getConstructorName(String aspect, String clazz) {
        return aspect + " : " + clazz + ".new";
    }

    public static String getConstructionName(String aspect, String clazz) {
        return aspect + " : " + clazz + ".new...";
    }

    public static String getMethodName(String aspect, String clazz, String m) {
        return aspect + " : " + clazz + "." + m;
    }

    public static String getFieldReadName(String aspect, String clazz, String f) {
        return aspect + " : " + clazz + ".r_" + f;
    }

    public static String getFieldWriteName(String aspect, String clazz, String f) {
        return aspect + " : " + clazz + ".w_" + f;
    }

    private static String getConstructorName(String aspect, Constructor con) {
        return Interceptions.getConstructorName(aspect, Interceptions.getClassName(con));
    }

    private static String getConstructionName(String aspect, Constructor con) {
        return Interceptions.getConstructionName(aspect, Interceptions.getClassName(con));
    }

    private static String getMethodName(String aspect, Method m) {
        return Interceptions.getMethodName(aspect, Interceptions.getClassName(m), m.getName());
    }

    private static String getFieldReadName(String aspect, Field f) {
        return Interceptions.getFieldReadName(aspect, Interceptions.getClassName(f), f.getName());
    }

    private static String getFieldWriteName(String aspect, Field f) {
        return Interceptions.getFieldWriteName(aspect, Interceptions.getClassName(f), f.getName());
    }

    private static String getClassName(Constructor c) {
        return Interceptions.getClassName(c.getDeclaringClass().getName());
    }

    private static String getClassName(Method m) {
        return Interceptions.getClassName(m.getDeclaringClass().getName());
    }

    private static String getClassName(Field f) {
        return Interceptions.getClassName(f.getDeclaringClass().getName());
    }

    private static String getClassName(Class clazz) {
        return Interceptions.getClassName(clazz.getName());
    }

    private static String getClassName(String s) {
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String getToString() {
        return interceptions.toString();
    }
}

