/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.rebuildingchain;

import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.test.aop.rebuildingchain.RebuildingChainTestCase;
import org.jboss.test.aop.rebuildingchain.SyncInterceptor;

public class RebuildThread
extends Thread {
    private volatile boolean done = false;
    private String pointcutExpression;
    private String bindingPrefix;

    public RebuildThread(String pointcutExpression, String bindingPrefix) {
        this.pointcutExpression = pointcutExpression;
        this.bindingPrefix = bindingPrefix;
    }

    public void run() {
        try {
            for (int i = 0; i < 30; ++i) {
                this.linkNewAdvice(this.bindingPrefix + i);
                this.unlinkAdvice(this.bindingPrefix + i);
                if (!this.isDone()) continue;
                return;
            }
        }
        catch (Exception e) {
            System.out.println("An exception occurred: " + e);
            e.printStackTrace();
            RebuildingChainTestCase.setTestFailed();
        }
    }

    public void linkNewAdvice() throws ParseException {
        this.linkNewAdvice(this.bindingPrefix + "Base");
    }

    public void unlinkAdvice() {
        this.unlinkAdvice(this.bindingPrefix + "Base");
    }

    private void linkNewAdvice(String name) throws ParseException {
        AdviceBinding binding1 = new AdviceBinding(this.pointcutExpression, null);
        binding1.addInterceptor(SyncInterceptor.class);
        binding1.setName(name);
        AspectManager.instance().addBinding(binding1);
    }

    private void unlinkAdvice(String name) {
        AspectManager.instance().removeBinding(name);
    }

    public void setDone(boolean b) {
        this.done = b;
    }

    private boolean isDone() {
        return this.done;
    }
}

