/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.regression.jbaop484superproxyadvised;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.aop.regression.jbaop484superproxyadvised.Base;
import org.jboss.test.aop.regression.jbaop484superproxyadvised.Child;
import org.jboss.test.aop.regression.jbaop484superproxyadvised.ChildInterface;
import org.jboss.test.aop.regression.jbaop484superproxyadvised.TestInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperClassIsAdvisedByProxyTestCase
extends TestCase {
    AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();

    public static void main(String[] args) {
        TestRunner.run((Test)SuperClassIsAdvisedByProxyTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SuperClassIsAdvisedByProxyTestCase");
        suite.addTestSuite(SuperClassIsAdvisedByProxyTestCase.class);
        return suite;
    }

    public SuperClassIsAdvisedByProxyTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassAdvisorAndNotInstanceAdvisor() throws Exception {
        Object proxy;
        System.out.println("== Testing proxy");
        Base base = new Base();
        SuperClassIsAdvisedByProxyTestCase.assertFalse((boolean)(base instanceof Advised));
        String name = this.addBinding("execution(* org.jboss.test.aop.regression.jbaop484superproxyadvised.Base->*(..))", TestInterceptor.class);
        try {
            proxy = this.createProxy(base);
            SuperClassIsAdvisedByProxyTestCase.assertTrue((boolean)(proxy instanceof AspectManaged));
            SuperClassIsAdvisedByProxyTestCase.assertFalse((boolean)(proxy instanceof Advised));
            TestInterceptor.reset();
            base.baseOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)0, (int)TestInterceptor.interceptions);
            TestInterceptor.reset();
            base.baseOverridden();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)0, (int)TestInterceptor.interceptions);
            TestInterceptor.reset();
            ((Base)proxy).baseOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
            SuperClassIsAdvisedByProxyTestCase.assertNotNull((Object)TestInterceptor.invoked);
            SuperClassIsAdvisedByProxyTestCase.assertEquals((String)"baseOnly", (String)TestInterceptor.invoked.getName());
            TestInterceptor.reset();
            ((Base)proxy).baseOverridden();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
            SuperClassIsAdvisedByProxyTestCase.assertNotNull((Object)TestInterceptor.invoked);
            SuperClassIsAdvisedByProxyTestCase.assertEquals((String)"baseOverridden", (String)TestInterceptor.invoked.getName());
        }
        finally {
            this.removeBinding(name);
        }
        System.out.println("== Testing advised child");
        name = this.addBinding("execution(* org.jboss.test.aop.regression.jbaop484superproxyadvised.Base->*(..))", TestInterceptor.class);
        try {
            Child plainChild = new Child();
            SuperClassIsAdvisedByProxyTestCase.assertTrue((boolean)(plainChild instanceof Advised));
            SuperClassIsAdvisedByProxyTestCase.assertFalse((boolean)(plainChild instanceof AspectManaged));
            TestInterceptor.reset();
            plainChild.baseOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)0, (int)TestInterceptor.interceptions);
            TestInterceptor.reset();
            plainChild.childOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
            TestInterceptor.reset();
            plainChild.baseOverridden();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
        }
        finally {
            this.removeBinding(name);
        }
        System.out.println("== Testing proxied child");
        name = this.addBinding("execution(* org.jboss.test.aop.regression.jbaop484superproxyadvised.Base->*(..))", TestInterceptor.class);
        proxy = null;
        try {
            Child proxiedChild = new Child();
            SuperClassIsAdvisedByProxyTestCase.assertTrue((boolean)(proxiedChild instanceof Advised));
            SuperClassIsAdvisedByProxyTestCase.assertFalse((boolean)(proxiedChild instanceof AspectManaged));
            proxy = this.createProxy(proxiedChild, new Class[]{ChildInterface.class});
            TestInterceptor.reset();
            ((Child)proxy).baseOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
            SuperClassIsAdvisedByProxyTestCase.assertNotNull((Object)TestInterceptor.invoked);
            SuperClassIsAdvisedByProxyTestCase.assertEquals((String)"baseOnly", (String)TestInterceptor.invoked.getName());
            TestInterceptor.reset();
            ((Child)proxy).childOnly();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)2, (int)TestInterceptor.interceptions);
            SuperClassIsAdvisedByProxyTestCase.assertNotNull((Object)TestInterceptor.invoked);
            SuperClassIsAdvisedByProxyTestCase.assertEquals((String)"childOnly", (String)TestInterceptor.invoked.getName());
            TestInterceptor.reset();
            ((Child)proxy).baseOverridden();
            SuperClassIsAdvisedByProxyTestCase.assertEquals((int)2, (int)TestInterceptor.interceptions);
            SuperClassIsAdvisedByProxyTestCase.assertNotNull((Object)TestInterceptor.invoked);
            SuperClassIsAdvisedByProxyTestCase.assertEquals((String)"baseOverridden", (String)TestInterceptor.invoked.getName());
        }
        finally {
            this.removeBinding(name);
        }
        TestInterceptor.reset();
        ((Child)proxy).baseOnly();
        SuperClassIsAdvisedByProxyTestCase.assertEquals((int)1, (int)TestInterceptor.interceptions);
    }

    private String addBinding(String pointcut, Class<?> interceptor) throws ParseException {
        AdviceBinding binding = new AdviceBinding(pointcut, null);
        String name = binding.getName();
        binding.addInterceptor(interceptor);
        AspectManager.instance().addBinding(binding);
        return name;
    }

    private void removeBinding(String name) {
        AspectManager.instance().removeBinding(name);
    }

    private Object createProxy(Object target) {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object createProxy(Object target, Class<?>[] interfaces) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setInterfaces((Class[])interfaces);
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }
}

