/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress.methodinvocation;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jboss.test.aop.stress.AbstractScenario;
import org.jboss.test.aop.stress.ScenarioTest;
import org.jboss.test.aop.stress.methodinvocation.POJO;
import org.jboss.test.aop.stress.methodinvocation.PlainAspect;
import org.jboss.test.aop.stress.methodinvocation.PlainInterceptor;

public class MethodInvocationTestCase
extends ScenarioTest {
    public static void main(String[] args) {
        TestRunner.run(MethodInvocationTestCase.class);
    }

    public MethodInvocationTestCase(String name) throws Exception {
        super(name);
    }

    public void testStaticWovenNoAdvice() throws Exception {
        this.getRunner().executeScenario(new StaticWovenNoAdviceScenario(), (TestCase)this);
    }

    public void testNonStaticWovenNoAdvice() throws Exception {
        this.getRunner().executeScenario(new NonStaticWovenNoAdviceScenario(), (TestCase)this);
    }

    public void testNonStaticWithOneInterceptor() throws Exception {
        POJO pojo = new POJO();
        PlainInterceptor.called = 0;
        pojo.oneInterceptor();
        MethodInvocationTestCase.assertEquals((int)1, (int)PlainInterceptor.called);
        this.getRunner().executeScenario(new NonStaticWithOneInterceptorScenario(), (TestCase)this);
    }

    public void testNonStaticWithFiveInterceptors() throws Exception {
        POJO pojo = new POJO();
        PlainInterceptor.called = 0;
        pojo.fiveInterceptors();
        MethodInvocationTestCase.assertEquals((int)5, (int)PlainInterceptor.called);
        this.getRunner().executeScenario(new NonStaticWithFiveInterceptorsScenario(), (TestCase)this);
    }

    public void testNonStaticWithOneAdvice() throws Exception {
        POJO pojo = new POJO();
        PlainAspect.called = 0;
        pojo.oneAdvice();
        MethodInvocationTestCase.assertEquals((int)1, (int)PlainAspect.called);
        this.getRunner().executeScenario(new NonStaticWithOneAdviceScenario(), (TestCase)this);
    }

    public void testNonStaticWithFiveAdvices() throws Exception {
        POJO pojo = new POJO();
        PlainAspect.called = 0;
        pojo.fiveAdvices();
        MethodInvocationTestCase.assertEquals((int)5, (int)PlainAspect.called);
        this.getRunner().executeScenario(new NonStaticWithFiveAdvicesScenario(), (TestCase)this);
    }

    private class NonStaticWithFiveAdvicesScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private NonStaticWithFiveAdvicesScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.fiveAdvices();
        }
    }

    private class NonStaticWithOneAdviceScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private NonStaticWithOneAdviceScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.oneAdvice();
        }
    }

    private class NonStaticWithFiveInterceptorsScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private NonStaticWithFiveInterceptorsScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.fiveInterceptors();
        }
    }

    private class NonStaticWithOneInterceptorScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private NonStaticWithOneInterceptorScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.oneInterceptor();
        }
    }

    private class NonStaticWovenNoAdviceScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private NonStaticWovenNoAdviceScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.nonStaticMethodNoAdvice();
        }
    }

    private class StaticWovenNoAdviceScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private StaticWovenNoAdviceScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            POJO.staticMethodNoAdvice();
        }
    }
}

