/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress.perinstancemethodinvocation;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jboss.test.aop.stress.AbstractScenario;
import org.jboss.test.aop.stress.ScenarioTest;
import org.jboss.test.aop.stress.perinstancemethodinvocation.POJO;
import org.jboss.test.aop.stress.perinstancemethodinvocation.PerInstanceAspect;
import org.jboss.test.aop.stress.perinstancemethodinvocation.PerInstanceInterceptor;

public class PerInstanceTestCase
extends ScenarioTest {
    public static void main(String[] args) {
        TestRunner.run(PerInstanceTestCase.class);
    }

    public PerInstanceTestCase(String name) {
        super(name);
    }

    public void testPerInstanceInterceptor() throws Exception {
        POJO pojo = new POJO();
        PerInstanceInterceptor.called = 0;
        pojo.method1();
        PerInstanceTestCase.assertEquals((int)1, (int)PerInstanceInterceptor.called);
        this.getRunner().executeScenario(new PerInstanceInterceptorScenario(), (TestCase)this);
    }

    public void testPerInstanceAspect() throws Exception {
        POJO pojo = new POJO();
        PerInstanceAspect.called = 0;
        pojo.method2();
        PerInstanceTestCase.assertEquals((int)1, (int)PerInstanceAspect.called);
        this.getRunner().executeScenario(new PerInstanceAspectScenario(), (TestCase)this);
    }

    public void testPerInstanceInterceptorRepeatInstantiation() throws Exception {
        POJO pojo = new POJO();
        PerInstanceInterceptor.called = 0;
        pojo.method1();
        pojo.method1();
        PerInstanceTestCase.assertEquals((int)2, (int)PerInstanceInterceptor.called);
        this.getRunner().executeScenario(new PerInstanceInterceptorRepeatInstantiationScenario(), (TestCase)this);
    }

    public void testPerInstanceAspectRepeatInstantiation() throws Exception {
        POJO pojo = new POJO();
        PerInstanceAspect.called = 0;
        pojo.method2();
        PerInstanceTestCase.assertEquals((int)1, (int)PerInstanceAspect.called);
        this.getRunner().executeScenario(new PerInstanceAspectRepeatInstantiationScenario(), (TestCase)this);
    }

    private class PerInstanceAspectRepeatInstantiationScenario
    extends AbstractScenario {
        private PerInstanceAspectRepeatInstantiationScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            POJO pojo = new POJO();
            pojo.method2();
            pojo.method2();
        }
    }

    private class PerInstanceInterceptorRepeatInstantiationScenario
    extends AbstractScenario {
        private PerInstanceInterceptorRepeatInstantiationScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            POJO pojo = new POJO();
            pojo.method1();
        }
    }

    private class PerInstanceAspectScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private PerInstanceAspectScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.method2();
        }
    }

    private class PerInstanceInterceptorScenario
    extends AbstractScenario {
        POJO pojo = new POJO();

        private PerInstanceInterceptorScenario() {
        }

        public void execute(int thread, int loop) throws Exception {
            this.pojo.method1();
        }
    }
}

