/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.override;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.override.CountingAspect;
import org.jboss.test.aop.override.CountingInterceptor;
import org.jboss.test.aop.override.MetadataInterceptor;
import org.jboss.test.aop.override.POJO;
import org.jboss.test.aop.override.SubPOJO;
import org.jboss.test.aop.override.SubSubPOJO;

public class OverrideTestCase
extends AOPTestWithSetup {
    POJO pojo = new POJO();
    SubPOJO subPojo = new SubPOJO();
    SubSubPOJO subSubPojo = new SubSubPOJO();

    public OverrideTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OverrideTestCase");
        suite.addTestSuite(OverrideTestCase.class);
        return suite;
    }

    public void testPOJOSuperOnlyMetadata() throws Exception {
        System.out.println("TEST POJO SUPERONLY METADATA");
        MetadataInterceptor.metadata = null;
        this.pojo.superOnly();
        OverrideTestCase.assertEquals((String)"pojo.superOnly", (String)MetadataInterceptor.metadata);
    }

    public void testPOJOSuperOnlyChain() throws Exception {
        System.out.println("TEST POJO SUPERONLY CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.pojo.superOnly();
        OverrideTestCase.assertEquals((int)4, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)2, (int)CountingAspect.interceptions);
    }

    public void testPOJOSuperOnlyNoSubMetadata() throws Exception {
        System.out.println("TEST POJO SUPERONLYNOSUB METADATA");
        MetadataInterceptor.metadata = null;
        this.pojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((String)"pojo.superOnlyNoSub", (String)MetadataInterceptor.metadata);
    }

    public void testPOJOSuperOnlyNoSubChain() throws Exception {
        System.out.println("TEST POJO SUPERONLYNOSUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.pojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((int)2, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)1, (int)CountingAspect.interceptions);
    }

    public void testSubSuperOnlyNoSubMetadata() throws Exception {
        System.out.println("TEST SUB SUPERONLYNOSUB METADATA");
        MetadataInterceptor.metadata = null;
        this.subPojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((String)"pojo.superOnlyNoSub", (String)MetadataInterceptor.metadata);
    }

    public void testSubSubSuperOnlyNoSubMetadata() throws Exception {
        System.out.println("TEST SUB SUB SUPERONLYNOSUB METADATA");
        MetadataInterceptor.metadata = null;
        this.subSubPojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((String)"pojo.superOnlyNoSub", (String)MetadataInterceptor.metadata);
    }

    public void testSubSuperOnlyNoSubChain() throws Exception {
        System.out.println("TEST SUB SUPERONLYNOSUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subPojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((int)2, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)1, (int)CountingAspect.interceptions);
    }

    public void testSubSubSuperOnlyNoSubChain() throws Exception {
        System.out.println("TEST SUB SUB SUPERONLYNOSUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subPojo.superOnlyNoSub();
        OverrideTestCase.assertEquals((int)2, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)1, (int)CountingAspect.interceptions);
    }

    public void testPOJOOverriddenMetadata() throws Exception {
        System.out.println("TEST POJO OVERRIDDEN METADATA");
        MetadataInterceptor.metadata = null;
        this.pojo.overridden();
        OverrideTestCase.assertEquals((String)"pojo.overridden", (String)MetadataInterceptor.metadata);
    }

    public void testPOJOOverriddenChain() throws Exception {
        System.out.println("TEST POJO OVERRIDDEN CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.pojo.overridden();
        OverrideTestCase.assertEquals((int)2, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)3, (int)CountingAspect.interceptions);
    }

    public void testSubOverriddenMetadata() throws Exception {
        System.out.println("TEST SUB OVERRIDDEN METADATA");
        MetadataInterceptor.metadata = null;
        this.subPojo.overridden();
        OverrideTestCase.assertEquals((String)"subpojo.overridden", (String)MetadataInterceptor.metadata);
    }

    public void testSubSubOverriddenMetadata() throws Exception {
        System.out.println("TEST SUB SUB OVERRIDDEN METADATA");
        MetadataInterceptor.metadata = null;
        this.subSubPojo.overridden();
        OverrideTestCase.assertEquals((String)"subsubpojo.overridden", (String)MetadataInterceptor.metadata);
    }

    public void testSubOverriddenChain() throws Exception {
        System.out.println("TEST SUB OVERRIDDEN CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subPojo.overridden();
        OverrideTestCase.assertEquals((int)1, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)1, (int)CountingAspect.interceptions);
    }

    public void testSubSubOverriddenChain() throws Exception {
        System.out.println("TEST SUB SUB OVERRIDDEN CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subSubPojo.overridden();
        OverrideTestCase.assertEquals((int)2, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)1, (int)CountingAspect.interceptions);
    }

    public void testPOJOOverriddenNoSubMetadata() throws Exception {
        System.out.println("TEST POJO OVERRIDDEN NO SUB METADATA");
        MetadataInterceptor.metadata = null;
        this.pojo.overriddenNoSub();
        OverrideTestCase.assertEquals((String)"pojo.overriddenNoSub", (String)MetadataInterceptor.metadata);
    }

    public void testPOJOOverriddenNoSubChain() throws Exception {
        System.out.println("TEST POJO OVERRIDDEN NO SUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.pojo.overriddenNoSub();
        OverrideTestCase.assertEquals((int)5, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)3, (int)CountingAspect.interceptions);
    }

    public void testSubOverriddenNoSubMetadata() throws Exception {
        System.out.println("TEST SUB OVERRIDDEN NO SUB METADATA");
        MetadataInterceptor.metadata = null;
        this.subPojo.overriddenNoSub();
        OverrideTestCase.assertEquals(null, (String)MetadataInterceptor.metadata);
    }

    public void testSubSubOverriddenNoSubMetadata() throws Exception {
        System.out.println("TEST SUB SUB OVERRIDDEN NO SUB METADATA");
        MetadataInterceptor.metadata = null;
        this.subSubPojo.overriddenNoSub();
        OverrideTestCase.assertEquals(null, (String)MetadataInterceptor.metadata);
    }

    public void testSubOverriddenNoSubChain() throws Exception {
        System.out.println("TEST SUB OVERRIDDEN NO SUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subPojo.overriddenNoSub();
        OverrideTestCase.assertEquals((int)0, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)0, (int)CountingAspect.interceptions);
    }

    public void testSubSubOverriddenNoSubChain() throws Exception {
        System.out.println("TEST SUB SUB OVERRIDDEN NO SUB CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subSubPojo.overriddenNoSub();
        OverrideTestCase.assertEquals((int)0, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)0, (int)CountingAspect.interceptions);
    }

    public void testSubSubOnlyChain() throws Exception {
        System.out.println("TEST SUB SUB ONLY CHAIN");
        CountingInterceptor.reset();
        CountingAspect.reset();
        this.subPojo.subOnly();
        OverrideTestCase.assertEquals((int)3, (int)CountingInterceptor.interceptions);
        OverrideTestCase.assertEquals((int)2, (int)CountingAspect.interceptions);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)OverrideTestCase.suite());
    }
}

