/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.proxy;

import java.io.Externalizable;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceDomain;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.proxy.Proxy;
import org.jboss.aop.proxy.ProxyFactory;
import org.jboss.aop.proxy.ProxyMixin;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.proxy.AnnotatedPOJO;
import org.jboss.test.aop.proxy.Annotation;
import org.jboss.test.aop.proxy.AnnotationImpl;
import org.jboss.test.aop.proxy.EchoInterceptor;
import org.jboss.test.aop.proxy.Mixin;
import org.jboss.test.aop.proxy.MixinInterface;
import org.jboss.test.aop.proxy.OverrideObjectClass;
import org.jboss.test.aop.proxy.OverrideObjectInterface;
import org.jboss.test.aop.proxy.POJO;
import org.jboss.test.aop.proxy.POJOWithFinalMethods;
import org.jboss.test.aop.proxy.POJOWithIntroduction;
import org.jboss.test.aop.proxy.SomeAnnotation;
import org.jboss.test.aop.proxy.SomeAnnotationImpl;
import org.jboss.test.aop.proxy.SomeInterface;
import org.jboss.test.aop.proxy.TestInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)ProxyTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ProxyTester");
        suite.addTestSuite(ProxyTestCase.class);
        return suite;
    }

    public ProxyTestCase(String name) {
        super(name);
    }

    public void testProxy() throws Exception {
        Class[] mixIntfs = new Class[]{MixinInterface.class};
        ProxyMixin mixin = new ProxyMixin((Object)new Mixin(), mixIntfs);
        ProxyMixin[] mixins = new ProxyMixin[]{mixin};
        Class[] intfs = new Class[]{SomeInterface.class};
        ClassInstanceAdvisor advisor = new ClassInstanceAdvisor();
        advisor.insertInterceptor((Interceptor)new EchoInterceptor());
        Proxy proxy = ProxyFactory.createInterfaceProxy((ClassLoader)Thread.currentThread().getContextClassLoader(), (Class[])intfs, (ProxyMixin[])mixins, (InstanceAdvisor)advisor);
        MixinInterface mi = (MixinInterface)proxy;
        ProxyTestCase.assertEquals((String)mi.hello("mixin"), (String)"mixin");
        SomeInterface si = (SomeInterface)proxy;
        ProxyTestCase.assertEquals((String)si.helloWorld(), (String)"echoed");
        MarshalledObject<Proxy> mo = new MarshalledObject<Proxy>(proxy);
        proxy = mo.get();
        mi = (MixinInterface)proxy;
        ProxyTestCase.assertEquals((String)mi.hello("mixin"), (String)"mixin");
        si = (SomeInterface)proxy;
        ProxyTestCase.assertEquals((String)si.helloWorld(), (String)"echoed");
    }

    public void testClassProxy() throws Exception {
        Class[] mixIntfs = new Class[]{MixinInterface.class};
        ProxyMixin mixin = new ProxyMixin((Object)new Mixin(), mixIntfs);
        ProxyMixin[] mixins = new ProxyMixin[]{mixin};
        ClassInstanceAdvisor advisor = new ClassInstanceAdvisor();
        advisor.insertInterceptor((Interceptor)new EchoInterceptor());
        POJO proxy = (POJO)ClassProxyFactory.newInstance(POJO.class, (ProxyMixin[])mixins, (InstanceAdvisor)advisor);
        MixinInterface mi = (MixinInterface)((Object)proxy);
        ProxyTestCase.assertEquals((String)mi.hello("mixin"), (String)"mixin");
        MarshalledObject<POJO> mo = new MarshalledObject<POJO>(proxy);
        proxy = mo.get();
        mi = (MixinInterface)((Object)proxy);
        ProxyTestCase.assertEquals((String)mi.hello("mixin"), (String)"mixin");
        ProxyTestCase.assertEquals((String)proxy.helloWorld(), (String)"echoed");
    }

    public void testContainerProxyCacheKey() throws Exception {
        ContainerProxyCacheKey key1 = new ContainerProxyCacheKey("/", ((Object)((Object)this)).getClass(), new Class[]{Serializable.class, InputStream.class, Externalizable.class}, null);
        ContainerProxyCacheKey key2 = new ContainerProxyCacheKey("/", ((Object)((Object)this)).getClass(), new Class[]{Serializable.class, Externalizable.class}, null);
        ContainerProxyCacheKey key3 = new ContainerProxyCacheKey("/", ((Object)((Object)this)).getClass(), new Class[]{Externalizable.class, InputStream.class, Serializable.class}, null);
        ContainerProxyCacheKey key4 = new ContainerProxyCacheKey("/some/fqn", ((Object)((Object)this)).getClass(), new Class[]{Serializable.class, Externalizable.class}, null);
        ContainerProxyCacheKey key5 = new ContainerProxyCacheKey("/some/fqn", ((Object)((Object)this)).getClass(), new Class[]{Serializable.class, Externalizable.class}, null);
        ProxyTestCase.assertFalse((boolean)key1.equals((Object)key2));
        ProxyTestCase.assertTrue((boolean)key1.equals((Object)key3));
        ProxyTestCase.assertFalse((boolean)key2.equals((Object)key4));
        ProxyTestCase.assertTrue((boolean)key4.equals((Object)key5));
        ProxyTestCase.assertFalse((key1.hashCode() == key2.hashCode() ? 1 : 0) != 0);
        ProxyTestCase.assertTrue((key1.hashCode() == key3.hashCode() ? 1 : 0) != 0);
        ProxyTestCase.assertFalse((key2.hashCode() == key4.hashCode() ? 1 : 0) != 0);
        ProxyTestCase.assertTrue((key4.hashCode() == key5.hashCode() ? 1 : 0) != 0);
    }

    public void testContainerCacheClassAdvisor() throws Exception {
        AspectManager manager = AspectManager.instance();
        ContainerCache cache1 = ContainerCache.initialise((AspectManager)manager, String.class, null, (boolean)true);
        ContainerCache cache2 = ContainerCache.initialise((AspectManager)manager, String.class, null, (boolean)true);
        ProxyTestCase.assertSame((Object)cache1.getClassAdvisor(), (Object)cache2.getClassAdvisor());
        ContainerCache cache3 = ContainerCache.initialise((AspectManager)manager, Integer.class, null, (boolean)true);
        ProxyTestCase.assertNotSame((Object)cache1.getClassAdvisor(), (Object)cache3.getClassAdvisor());
    }

    public void testContainerProxy() throws Exception {
        InstanceDomain domain = new InstanceDomain(AspectManager.instance(), "blah", false);
        InterfaceIntroduction intro = new InterfaceIntroduction("intro", "*", null);
        String[] intfs = new String[]{MixinInterface.class.getName()};
        InterfaceIntroduction.Mixin mixin = new InterfaceIntroduction.Mixin(Mixin.class.getName(), intfs, null, false);
        intro.getMixins().add(mixin);
        domain.addInterfaceIntroduction(intro);
        AspectDefinition def = new AspectDefinition("aspect", Scope.PER_VM, (AspectFactory)new GenericAspectFactory(EchoInterceptor.class.getName(), null));
        domain.addAspectDefinition(def);
        AdviceFactory advice = new AdviceFactory(def, "invoke");
        domain.addInterceptorFactory(advice.getName(), (InterceptorFactory)advice);
        PointcutExpression pointcut = new PointcutExpression("pointcut", "execution(java.lang.String " + POJO.class.getName() + "->helloWorld(..))");
        domain.addPointcut((Pointcut)pointcut);
        InterceptorFactory[] interceptors = new InterceptorFactory[]{advice};
        AdviceBinding binding = new AdviceBinding("pojo-binding", (Pointcut)pointcut, null, null, interceptors);
        domain.addBinding(binding);
        pointcut = new PointcutExpression("mixin-pointcut", "execution(java.lang.String $instanceof{" + MixinInterface.class.getName() + "}->intercepted(..))");
        domain.addPointcut((Pointcut)pointcut);
        interceptors = new InterceptorFactory[]{advice};
        binding = new AdviceBinding("mixin-binding", (Pointcut)pointcut, null, null, interceptors);
        domain.addBinding(binding);
        Class proxyClass = ContainerProxyFactory.getProxyClass(POJO.class, (AspectManager)domain);
        ClassProxyContainer container = new ClassProxyContainer("test", (AspectManager)domain);
        domain.setAdvisor((Advisor)container);
        container.setClass(proxyClass);
        container.initializeClassContainer();
        POJO proxy = (POJO)proxyClass.newInstance();
        AspectManaged cp = (AspectManaged)proxy;
        cp.setAdvisor((Advisor)container);
        Delegate delegate = (Delegate)cp;
        delegate.setDelegate((Object)new POJO());
        MixinInterface mi = (MixinInterface)((Object)proxy);
        System.out.println("--- mixin");
        ProxyTestCase.assertEquals((String)mi.hello("mixin"), (String)"mixin");
        System.out.println("--- hw");
        ProxyTestCase.assertEquals((String)"echoed", (String)proxy.helloWorld());
        System.out.println("--- icptd");
        ProxyTestCase.assertEquals((String)"echoed", (String)mi.intercepted("error"));
    }

    public void testContainerProxyWithFinalMethods() throws Exception {
        InstanceDomain domain = new InstanceDomain(AspectManager.instance(), "test", false);
        AspectDefinition def = new AspectDefinition("aspect", Scope.PER_VM, (AspectFactory)new GenericAspectFactory(EchoInterceptor.class.getName(), null));
        domain.addAspectDefinition(def);
        AdviceFactory advice = new AdviceFactory(def, "invoke");
        domain.addInterceptorFactory(advice.getName(), (InterceptorFactory)advice);
        PointcutExpression pointcut = new PointcutExpression("pointcut", "execution(* " + POJOWithFinalMethods.class.getName() + "->*(..))");
        domain.addPointcut((Pointcut)pointcut);
        InterceptorFactory[] interceptors = new InterceptorFactory[]{advice};
        AdviceBinding binding = new AdviceBinding("pojo-binding", (Pointcut)pointcut, null, null, interceptors);
        domain.addBinding(binding);
        Class proxyClass = ContainerProxyFactory.getProxyClass(POJOWithFinalMethods.class, (AspectManager)domain);
        ClassProxyContainer container = new ClassProxyContainer("test", (AspectManager)domain);
        domain.setAdvisor((Advisor)container);
        container.setClass(proxyClass);
        container.initializeClassContainer();
        POJOWithFinalMethods proxy = (POJOWithFinalMethods)proxyClass.newInstance();
        AspectManaged cp = (AspectManaged)proxy;
        cp.setAdvisor((Advisor)container);
        Delegate delegate = (Delegate)cp;
        delegate.setDelegate((Object)new POJOWithFinalMethods());
        EchoInterceptor.intercepted = false;
        proxy.method();
        ProxyTestCase.assertTrue((boolean)EchoInterceptor.intercepted);
        EchoInterceptor.intercepted = false;
        proxy.finalMethod();
        ProxyTestCase.assertFalse((boolean)EchoInterceptor.intercepted);
    }

    public void testHollowProxyWithInterfaceContainingObjectMethods() throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setObjectAsSuperClass(true);
        params.setInterfaces(new Class[]{OverrideObjectInterface.class});
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Object o = factory.createAdvisedProxy(params);
        ProxyTestCase.assertTrue((boolean)(o instanceof OverrideObjectInterface));
        ProxyTestCase.assertTrue((boolean)o.equals(o));
        ProxyTestCase.assertEquals((int)o.hashCode(), (int)o.hashCode());
        ProxyTestCase.assertEquals((String)o.toString(), (String)o.toString());
        OverrideObjectClass tgt = new OverrideObjectClass();
        ProxyTestCase.assertNotNull((Object)tgt);
        ((Delegate)o).setDelegate((Object)tgt);
        Object target = ((Delegate)o).getDelegate();
        ProxyTestCase.assertSame((Object)tgt, (Object)target);
        ProxyTestCase.assertFalse((boolean)tgt.invokedEquals);
        ProxyTestCase.assertFalse((boolean)tgt.invokedHashCode);
        ProxyTestCase.assertFalse((boolean)tgt.invokedToString);
        ProxyTestCase.assertTrue((boolean)o.equals(o));
        ProxyTestCase.assertTrue((boolean)tgt.invokedEquals);
        ProxyTestCase.assertEquals((int)o.hashCode(), (int)o.hashCode());
        ProxyTestCase.assertTrue((boolean)tgt.invokedHashCode);
        ProxyTestCase.assertEquals((String)o.toString(), (String)o.toString());
        ProxyTestCase.assertTrue((boolean)tgt.invokedToString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyWithPerInstanceAspects() throws Exception {
        AspectManager manager = AspectManager.instance();
        AspectDefinition def = new AspectDefinition("perinstanceaspect", Scope.PER_INSTANCE, (AspectFactory)new GenericAspectFactory(TestInterceptor.class.getName(), null));
        AdviceFactory advice = new AdviceFactory(def, "invoke");
        PointcutExpression pointcut = new PointcutExpression("perinstancepointcut", "execution(* $instanceof{" + SomeInterface.class.getName() + "}->*(..))");
        InterceptorFactory[] interceptors = new InterceptorFactory[]{advice};
        AdviceBinding binding = new AdviceBinding("perinstancebinding", (Pointcut)pointcut, null, null, interceptors);
        try {
            manager.addAspectDefinition(def);
            manager.addInterceptorFactory(advice.getName(), (InterceptorFactory)advice);
            manager.addPointcut((Pointcut)pointcut);
            manager.addBinding(binding);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            params.setInterfaces(new Class[]{SomeInterface.class});
            params.setTarget((Object)new POJO());
            GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
            SomeInterface si = (SomeInterface)factory.createAdvisedProxy(params);
            si.helloWorld();
            ProxyTestCase.assertTrue((boolean)TestInterceptor.invoked);
        }
        finally {
            manager.removeBinding("perinstancebinding");
            manager.removePointcut("perinstancepointcut");
            manager.removeInterceptorFactory("perinstanceaspect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyWithPerJoinpointAspects() throws Exception {
        AspectManager manager = AspectManager.instance();
        AspectDefinition def = new AspectDefinition("perinstanceaspect", Scope.PER_JOINPOINT, (AspectFactory)new GenericAspectFactory(TestInterceptor.class.getName(), null));
        AdviceFactory advice = new AdviceFactory(def, "invoke");
        PointcutExpression pointcut = new PointcutExpression("perinstancepointcut", "execution(* $instanceof{" + SomeInterface.class.getName() + "}->*(..))");
        InterceptorFactory[] interceptors = new InterceptorFactory[]{advice};
        AdviceBinding binding = new AdviceBinding("perinstancebinding", (Pointcut)pointcut, null, null, interceptors);
        try {
            manager.addAspectDefinition(def);
            manager.addInterceptorFactory(advice.getName(), (InterceptorFactory)advice);
            manager.addPointcut((Pointcut)pointcut);
            manager.addBinding(binding);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            params.setInterfaces(new Class[]{SomeInterface.class});
            params.setTarget((Object)new POJO());
            GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
            SomeInterface si = (SomeInterface)factory.createAdvisedProxy(params);
            si.helloWorld();
            ProxyTestCase.assertTrue((boolean)TestInterceptor.invoked);
        }
        finally {
            manager.removeBinding("perinstancebinding");
            manager.removePointcut("perinstancepointcut");
            manager.removeInterceptorFactory("perinstanceaspect");
        }
    }

    public void testAnnotationsExistInProxy() throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setInterfaces(new Class[]{SomeInterface.class});
        params.setTarget(new AnnotatedPOJO());
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        AnnotatedPOJO pojo = (AnnotatedPOJO)factory.createAdvisedProxy(params);
        Class<?> proxyClass = pojo.getClass();
        ProxyTestCase.assertNotSame(AnnotatedPOJO.class, proxyClass);
        ProxyTestCase.assertEquals(AnnotatedPOJO.class, proxyClass.getSuperclass());
        this.checkExpectedAnnotations(AnnotatedPOJO.class);
        this.checkExpectedAnnotations(proxyClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyWithMetaData() throws Exception {
        AspectManager manager = AspectManager.instance();
        AspectDefinition def = new AspectDefinition("aspect", Scope.PER_INSTANCE, (AspectFactory)new GenericAspectFactory(TestInterceptor.class.getName(), null));
        AdviceFactory advice = new AdviceFactory(def, "invoke");
        PointcutExpression pointcut = new PointcutExpression("pointcut", "execution(* " + java.lang.annotation.Annotation.class.getName() + "->*(..))");
        InterceptorFactory[] interceptors = new InterceptorFactory[]{advice};
        AdviceBinding binding = new AdviceBinding("binding", (Pointcut)pointcut, null, null, interceptors);
        try {
            manager.addAspectDefinition(def);
            manager.addInterceptorFactory(advice.getName(), (InterceptorFactory)advice);
            manager.addPointcut((Pointcut)pointcut);
            manager.addBinding(binding);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            params.setTarget((Object)new POJO());
            GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
            POJO plain = (POJO)factory.createAdvisedProxy(params);
            ProxyTestCase.assertFalse((boolean)(plain instanceof AspectManaged));
            MetaData someAnnMD = this.setupMetaData(POJO.class, new SomeAnnotationImpl());
            params.setMetaData(someAnnMD);
            params.setMetaDataHasInstanceLevelData(true);
            params.setContainerCache(null);
            POJO instanceAnnotationWithNoBindings = (POJO)factory.createAdvisedProxy(params);
            ProxyTestCase.assertFalse((boolean)(instanceAnnotationWithNoBindings instanceof AspectManaged));
            MetaData annMD = this.setupMetaData(POJO.class, new AnnotationImpl());
            params.setMetaData(annMD);
            params.setMetaDataHasInstanceLevelData(true);
            params.setContainerCache(null);
            POJO instanceAnnotationWithBindings = (POJO)factory.createAdvisedProxy(params);
            ProxyTestCase.assertFalse((boolean)(instanceAnnotationWithBindings instanceof AspectManaged));
            ProxyTestCase.assertTrue((boolean)TestInterceptor.invoked);
            InterfaceIntroduction intro = new InterfaceIntroduction("intro", "@" + SomeAnnotation.class.getName(), new String[]{SomeInterface.class.getName()});
            manager.addInterfaceIntroduction(intro);
            params.setMetaData(someAnnMD);
            params.setContainerCache(null);
            POJO introduced = (POJO)factory.createAdvisedProxy(params);
            ProxyTestCase.assertTrue((boolean)(introduced instanceof AspectManaged));
            ProxyTestCase.assertTrue((boolean)(introduced instanceof SomeInterface));
        }
        finally {
            manager.removeBinding("binding");
            manager.removePointcut("pointcut");
            manager.removeInterceptorFactory("aspect");
            manager.removeInterfaceIntroduction("intro");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyWithOnlyIntroductions() throws Exception {
        AspectManager manager = AspectManager.instance();
        InterfaceIntroduction intro = new InterfaceIntroduction("intro", POJOWithIntroduction.class.getName(), new String[]{Serializable.class.getName()});
        try {
            manager.addInterfaceIntroduction(intro);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            params.setTarget((Object)new POJOWithIntroduction());
            GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
            POJOWithIntroduction pojo = (POJOWithIntroduction)factory.createAdvisedProxy(params);
            ProxyTestCase.assertTrue((boolean)(pojo instanceof AspectManaged));
            this.assertInstanceOf(pojo, Serializable.class);
        }
        finally {
            manager.removeInterfaceIntroduction(intro.getName());
        }
    }

    private MetaData setupMetaData(Class<?> clazz, java.lang.annotation.Annotation ... annotations) {
        BasicMetaDataRepository repository = new BasicMetaDataRepository();
        ScopeKey scopeKey = ScopeKey.DEFAULT_SCOPE.clone();
        scopeKey.addScope(CommonLevels.INSTANCE, (Object)"Test");
        scopeKey.addScope(CommonLevels.CLASS, (Object)clazz.getName());
        scopeKey.addScope(CommonLevels.WORK, (Object)String.valueOf(((Object)((Object)this)).hashCode()));
        ScopeKey mutableScope = new ScopeKey(CommonLevels.INSTANCE, (Object)"Test".toString());
        MemoryMetaDataLoader mutable = new MemoryMetaDataLoader(mutableScope);
        repository.addMetaDataRetrieval((MetaDataRetrieval)mutable);
        this.addClassAnnotations(clazz, mutable, annotations);
        MetaDataRetrievalToMetaDataBridge metadata = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)mutable);
        return metadata;
    }

    private void addClassAnnotations(Class<?> clazz, MemoryMetaDataLoader mutable, java.lang.annotation.Annotation[] extraAnnotations) {
        java.lang.annotation.Annotation[] anns;
        for (java.lang.annotation.Annotation ann : anns = clazz.getAnnotations()) {
            mutable.addAnnotation(ann);
        }
        for (java.lang.annotation.Annotation ann : extraAnnotations) {
            mutable.addAnnotation(ann);
        }
    }

    private void checkExpectedAnnotations(Class<?> clazz) throws Exception {
        Annotation ann = clazz.getAnnotation(Annotation.class);
        ProxyTestCase.assertNotNull((Object)ann);
        Method getter = clazz.getMethod("getX", new Class[0]);
        ProxyTestCase.assertNotNull((Object)getter.getAnnotation(Annotation.class));
        Method setter = clazz.getMethod("setX", Object.class);
        ProxyTestCase.assertNotNull((Object)setter.getAnnotation(Annotation.class));
        ProxyTestCase.assertEquals((int)1, (int)setter.getParameterTypes().length);
        ProxyTestCase.assertEquals((int)1, (int)setter.getParameterAnnotations().length);
        ProxyTestCase.assertEquals((int)1, (int)setter.getParameterAnnotations()[0].length);
        ProxyTestCase.assertEquals(Annotation.class, setter.getParameterAnnotations()[0][0].annotationType());
    }
}

