/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotatedAdviceParams;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotatedAdviceParams.CallType;
import org.jboss.test.aop.annotatedAdviceParams.POJOException;
import org.jboss.test.aop.annotatedAdviceParams.TargetAspect;
import org.jboss.test.aop.annotatedAdviceParams.TargetCallerPOJO;

public class TargetTestCase
extends AOPTestWithSetup {
    private TargetCallerPOJO pojo;

    public static void main(String[] args) {
        TestRunner.run((Test)TargetTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("TargetTestCase");
        suite.addTestSuite(TargetTestCase.class);
        return suite;
    }

    public TargetTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        TargetAspect.clear();
        this.pojo = new TargetCallerPOJO();
    }

    public void test1() {
        new TargetCallerPOJO(1);
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test2() {
        boolean thrown = false;
        try {
            new TargetCallerPOJO(1, "test2");
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(null, thrown);
    }

    public void test3() {
        this.pojo.field1 = 0;
        this.assertAllAdvices(false);
        this.assertTarget(this.pojo, false);
    }

    public void test4() {
        int test = this.pojo.field1;
        this.assertAllAdvices(false);
        this.assertTarget(this.pojo, false);
    }

    public void test5() {
        TargetCallerPOJO.field2 = 5;
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test6() {
        int test = TargetCallerPOJO.field2;
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test7() {
        this.pojo.method1();
        this.assertAllAdvices(false);
        this.assertTarget(this.pojo, false);
    }

    public void test8() {
        TargetCallerPOJO.method2();
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test9() {
        boolean thrown = false;
        try {
            this.pojo.method3();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(this.pojo, thrown);
    }

    public void test10() {
        boolean thrown = false;
        try {
            TargetCallerPOJO.method4();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(null, thrown);
    }

    public void test11() {
        this.pojo.method5();
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test12() {
        boolean thrown = false;
        try {
            this.pojo.method6();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(null, thrown);
    }

    public void test13() {
        this.pojo.method7();
        this.assertAllAdvices(false);
        this.assertTarget(false);
    }

    public void test14() {
        this.pojo.method8();
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test15() {
        boolean thrown = false;
        try {
            this.pojo.method9();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(thrown);
    }

    public void test16() {
        boolean thrown = false;
        try {
            this.pojo.method10();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(null, thrown);
    }

    public void test17() {
        TargetCallerPOJO.method11();
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test18() {
        TargetCallerPOJO.method12();
        this.assertAllAdvices(false);
        this.assertTarget(false);
    }

    public void test19() {
        TargetCallerPOJO.method13();
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test20() {
        boolean thrown = false;
        try {
            TargetCallerPOJO.method14();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(thrown);
    }

    public void test21() {
        boolean thrown = false;
        try {
            TargetCallerPOJO.method15();
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(thrown);
        this.assertTarget(null, thrown);
    }

    public void test22() throws POJOException {
        new TargetCallerPOJO(CallType.CONSTRUCTOR, false);
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test23() {
        boolean thrown = false;
        try {
            new TargetCallerPOJO(CallType.CONSTRUCTOR, true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(true);
        this.assertTarget(null, true);
    }

    public void test24() throws POJOException {
        new TargetCallerPOJO(CallType.METHOD, false);
        this.assertAllAdvices(false);
        this.assertTarget(false);
    }

    public void test25() {
        boolean thrown = false;
        try {
            new TargetCallerPOJO(CallType.METHOD, true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(true);
        this.assertTarget(true);
    }

    public void test26() throws POJOException {
        new TargetCallerPOJO(CallType.STATIC_METHOD, false);
        this.assertAllAdvices(false);
        this.assertTarget(null, false);
    }

    public void test27() {
        boolean thrown = false;
        try {
            new TargetCallerPOJO(CallType.STATIC_METHOD, true);
        }
        catch (POJOException e) {
            thrown = true;
        }
        TargetTestCase.assertTrue((boolean)thrown);
        this.assertAllAdvices(true);
        this.assertTarget(null, true);
    }

    private void assertAllAdvices(boolean error) {
        TargetTestCase.assertTrue((boolean)TargetAspect.before1);
        TargetTestCase.assertTrue((boolean)TargetAspect.before2);
        TargetTestCase.assertTrue((boolean)TargetAspect.around1);
        TargetTestCase.assertTrue((boolean)TargetAspect.around2);
        TargetTestCase.assertEquals((!error ? 1 : 0) != 0, (boolean)TargetAspect.after1);
        TargetTestCase.assertEquals((!error ? 1 : 0) != 0, (boolean)TargetAspect.after2);
        TargetTestCase.assertEquals((boolean)error, (boolean)TargetAspect.throwing1);
        TargetTestCase.assertEquals((boolean)error, (boolean)TargetAspect.throwing2);
        TargetTestCase.assertTrue((boolean)TargetAspect.finally1);
        TargetTestCase.assertTrue((boolean)TargetAspect.finally2);
    }

    private void assertTarget(boolean error) {
        TargetTestCase.assertNotNull((Object)TargetAspect.before2Target);
        this.assertSameTarget(error);
    }

    private void assertTarget(Object target, boolean error) {
        TargetTestCase.assertSame((Object)target, (Object)TargetAspect.before2Target);
        this.assertSameTarget(error);
    }

    private void assertSameTarget(boolean error) {
        TargetTestCase.assertSame((Object)TargetAspect.before2Target, (Object)TargetAspect.around2Target);
        if (error) {
            TargetTestCase.assertSame((Object)TargetAspect.around2Target, (Object)TargetAspect.throwing1Target);
            TargetTestCase.assertNull((Object)TargetAspect.after2Target);
        } else {
            TargetTestCase.assertSame((Object)TargetAspect.around2Target, (Object)TargetAspect.after2Target);
            TargetTestCase.assertNull((Object)TargetAspect.throwing1Target);
        }
        TargetTestCase.assertSame((Object)TargetAspect.around2Target, (Object)TargetAspect.finally2Target);
    }
}

