/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.joinpointcomparator;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.JoinPointComparator;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.joinpointcomparator.MockJoinPointInfo;
import org.jboss.test.aop.joinpointcomparator.POJO;
import org.jboss.test.aop.joinpointcomparator.TestInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPointComparatorTestCase
extends AOPTestWithSetup {
    private static final Constructor<?> CTOR1;
    private static final Constructor<?> CTOR2;
    private static final Constructor<?> CTOR3;

    public static void main(String[] args) {
        TestRunner.run((Test)JoinPointComparatorTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("JoinPointComparatorTestCase");
        suite.addTestSuite(JoinPointComparatorTestCase.class);
        return suite;
    }

    public JoinPointComparatorTestCase(String name) {
        super(name);
    }

    public void testMergeMethodKeys() {
        long[] l1 = new long[]{4L, 3L, 2L, 1L};
        long[] l2 = new long[]{4L, 3L, 2L, 1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{4L, 3L, 2L, 1L};
        l2 = new long[]{};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{};
        l2 = new long[]{4L, 3L, 2L, 1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{4L, 3L, 2L, 1L};
        l2 = null;
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = null;
        l2 = new long[]{4L, 3L, 2L, 1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{4L, 3L, 2L, 1L};
        l2 = new long[]{1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{4L};
        l2 = new long[]{4L, 3L, 2L, 1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{4L, 3L, 2L, 1L};
        l2 = new long[]{1L, 5L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L, 5L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
        l1 = new long[]{5L, 4L};
        l2 = new long[]{4L, 3L, 2L, 1L};
        this.assertArray(new long[]{1L, 2L, 3L, 4L, 5L}, JoinPointComparator.mergeMethodInfoKeys((long[])l1, (long[])l2));
    }

    public void testEqualInterceptors() {
        MockJoinPointInfo a = new MockJoinPointInfo(new TestInterceptor());
        MockJoinPointInfo b = new MockJoinPointInfo(new TestInterceptor());
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testBothNullInterceptors() {
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths(null, null));
    }

    public void testBothZeroLengthChains() {
        MockJoinPointInfo a = new MockJoinPointInfo(new Interceptor[0]);
        JoinPointComparatorTestCase.assertNotNull((Object)a.getInterceptors());
        MockJoinPointInfo b = new MockJoinPointInfo(new Interceptor[0]);
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testBothNullChains() {
        MockJoinPointInfo a = new MockJoinPointInfo(new Interceptor[0]);
        a.setInterceptors(null);
        MockJoinPointInfo b = new MockJoinPointInfo(new Interceptor[0]);
        a.setInterceptors(null);
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testNotEqualInterceptorsA() {
        MockJoinPointInfo a = new MockJoinPointInfo(new TestInterceptor(), new TestInterceptor());
        MockJoinPointInfo b = new MockJoinPointInfo(new TestInterceptor());
        JoinPointComparatorTestCase.assertEquals((int)-1, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testNotEqualInterceptorsB() {
        MockJoinPointInfo a = new MockJoinPointInfo(new TestInterceptor());
        MockJoinPointInfo b = new MockJoinPointInfo(new TestInterceptor(), new TestInterceptor());
        JoinPointComparatorTestCase.assertEquals((int)1, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testNullA() {
        JoinPointInfo a = null;
        MockJoinPointInfo b = new MockJoinPointInfo(new TestInterceptor());
        JoinPointComparatorTestCase.assertEquals((int)1, (int)JoinPointComparator.hasSameInterceptorLengths(a, (JoinPointInfo)b));
    }

    public void testNullB() {
        MockJoinPointInfo a = new MockJoinPointInfo(new TestInterceptor());
        JoinPointInfo b = null;
        JoinPointComparatorTestCase.assertEquals((int)-1, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, b));
    }

    public void testNullAZeroLengthB() {
        MockJoinPointInfo a = new MockJoinPointInfo(new Interceptor[0]);
        a.setInterceptors(null);
        MockJoinPointInfo b = new MockJoinPointInfo(new Interceptor[0]);
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testNullBZeroLengthA() {
        MockJoinPointInfo a = new MockJoinPointInfo(new Interceptor[0]);
        MockJoinPointInfo b = new MockJoinPointInfo(new Interceptor[0]);
        b.setInterceptors(null);
        JoinPointComparatorTestCase.assertEquals((int)0, (int)JoinPointComparator.hasSameInterceptorLengths((JoinPointInfo)a, (JoinPointInfo)b));
    }

    public void testEqualConstructorChains() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR3, 3, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 3, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertTrue((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testDifferentConstructorLengthsAEqualChains() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 0, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertTrue((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testDifferentConstructorLengthsAEqualChainsNull() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 0, true), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertTrue((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testDifferentConstructorLengthsBEqualChains() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 0, false), this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertTrue((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testDifferentConstructorLengthsBEqualChainsNull() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 0, true), this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertTrue((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testDifferentConstructorChains() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR1, 1, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR3, 4, false)};
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 3, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertFalse((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, (ConstructorInfo[])b));
    }

    public void testNullConstructorChainA() {
        ConstructorInfo[] a = null;
        ConstructorInfo[] b = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 3, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        JoinPointComparatorTestCase.assertFalse((boolean)JoinPointComparator.hasSameConstructorAspectLength(a, (ConstructorInfo[])b));
    }

    public void testNullConstructorChainB() {
        ConstructorInfo[] a = new ConstructorInfo[]{this.createConstructorInfo(CTOR3, 3, false), this.createConstructorInfo(CTOR2, 2, false), this.createConstructorInfo(CTOR1, 1, false)};
        ConstructorInfo[] b = null;
        JoinPointComparatorTestCase.assertFalse((boolean)JoinPointComparator.hasSameConstructorAspectLength((ConstructorInfo[])a, b));
    }

    private void assertArray(long[] expected, long[] actual) {
        if (expected.length != actual.length) {
            throw new AssertionFailedError("Expected " + Arrays.asList(new long[][]{expected}) + " had " + Arrays.asList(new long[][]{actual}));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            throw new AssertionFailedError("Expected " + Arrays.asList(new long[][]{expected}) + " had " + Arrays.asList(new long[][]{actual}));
        }
    }

    private ConstructorInfo createConstructorInfo(Constructor<?> ctor, int length, boolean nullIcptrs) {
        ConstructorInfo info = new ConstructorInfo();
        info.setConstructor(ctor);
        if (length > 0 && nullIcptrs) {
            throw new IllegalStateException("Cannot have both 0 length and null interceptors");
        }
        if (nullIcptrs) {
            info.setInterceptors(null);
        } else {
            Interceptor[] interceptors = new Interceptor[length];
            for (int i = 0; i < length; ++i) {
                interceptors[i] = new TestInterceptor();
            }
            info.setInterceptors(interceptors);
        }
        return info;
    }

    static {
        try {
            CTOR1 = POJO.class.getConstructor(new Class[0]);
            CTOR2 = POJO.class.getConstructor(Integer.TYPE);
            CTOR3 = POJO.class.getConstructor(Long.TYPE);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

