/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.precedence;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.precedence.Interceptions;
import org.jboss.test.aop.precedence.NoPrecedencePOJO;

public class NoPrecedenceTestCase
extends AOPTestWithSetup {
    private NoPrecedencePOJO pojo;

    public static Test suite() {
        TestSuite suite = new TestSuite("NoPrecedenceTestCase");
        suite.addTestSuite(NoPrecedenceTestCase.class);
        return suite;
    }

    public NoPrecedenceTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pojo = new NoPrecedencePOJO();
        Interceptions.reset();
    }

    public void testConstructor() throws Exception {
        System.out.println("*** Invoke constructor");
        new NoPrecedencePOJO();
        this.checkInterceptions("SimpleInterceptor4", "SimpleInterceptor5", "SimpleInterceptor7", "SimpleInterceptor8", "TestAspect4.advice", "TestAspect5.advice", "TestAspect7.advice", "TestAspect8.advice");
    }

    public void testFieldRead() {
        System.out.println("*** Invoke field read");
        int i = this.pojo.var;
        this.checkInterceptions("SimpleInterceptor8", "SimpleInterceptor7", "SimpleInterceptor6", "SimpleInterceptor5", "SimpleInterceptor4", "TestAspect6.advice", "TestAspect4.advice", "TestAspect5.advice", "TestAspect7.advice", "TestAspect8.advice");
    }

    public void testFieldWrite() {
        System.out.println("*** Invoke field write");
        Interceptions.reset();
        this.pojo.var = 1;
        this.checkInterceptions("SimpleInterceptor8", "SimpleInterceptor7", "SimpleInterceptor6", "SimpleInterceptor5", "SimpleInterceptor4", "TestAspect6.advice", "TestAspect4.advice", "TestAspect5.advice", "TestAspect7.advice", "TestAspect8.advice");
    }

    public void testOneMethodExecution() {
        System.out.println("*** Invoke oneMethod");
        this.pojo.oneMethod();
        this.checkInterceptions("SimpleInterceptor4", "TestAspect6.advice", "SimpleInterceptor5", "TestAspect4.advice", "SimpleInterceptor6", "TestAspect5.advice", "SimpleInterceptor7", "TestAspect7.advice", "SimpleInterceptor8", "TestAspect8.advice");
    }

    public void testTwoMethodExecution() {
        this.pojo.twoMethod();
        this.checkInterceptions("TestAspect4.advice", "TestAspect4.advice2", "TestAspect4.advice3", "TestAspect5.advice", "TestAspect7.advice", "TestAspect8.advice", "SimpleInterceptor4", "SimpleInterceptor5", "SimpleInterceptor6");
    }

    public void testThreeMethodExecution() {
        this.pojo.threeMethod();
        this.checkInterceptions("SimpleInterceptor5", "SimpleInterceptor4", "TestAspect4.advice", "TestAspect4.advice2", "TestAspect4.advice3", "TestAspect7.advice", "TestAspect8.advice");
    }

    public void testFiveMethodCall() {
        this.pojo.fourMethod();
        this.checkInterceptions("TestAspect4.advice", "TestAspect4.advice2", "TestAspect4.advice3", "TestAspect5.advice", "TestAspect7.advice", "TestAspect8.advice", "SimpleInterceptor4", "SimpleInterceptor5", "SimpleInterceptor6");
    }

    public void testConstructorCall() {
        NoPrecedencePOJO.factoryMethod();
        this.checkInterceptions("SimpleInterceptor5", "SimpleInterceptor4", "TestAspect4.advice", "TestAspect4.advice2", "TestAspect4.advice3", "TestAspect7.advice", "TestAspect8.advice");
    }

    private void checkInterceptions(String ... expected) {
        ArrayList<String> intercepted = Interceptions.intercepted;
        NoPrecedenceTestCase.assertEquals((String)"Wrong number of interceptions", (int)expected.length, (int)intercepted.size());
        for (int i = 0; i < expected.length; ++i) {
            NoPrecedenceTestCase.assertEquals((String)("Wrong interception at index " + i), (String)expected[i], (String)((String)intercepted.get(i)));
        }
    }
}

