/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.reflectprototype;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.reflectprototype.JavassistAopTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.test.aop.AOPTestWithSetup;

public class JavassistAopTypeInfoFactoryImplTestCase
extends AOPTestWithSetup {
    public JavassistAopTypeInfoFactoryImplTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("JavassistAopTypeInfoFactoryImplTestCase");
        suite.addTestSuite(JavassistAopTypeInfoFactoryImplTestCase.class);
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void testJavassistCtClass() {
        ClassPool pool = ClassPool.getDefault();
        try {
            CtClass pojo = pool.get("org.jboss.test.aop.reflectprototype.POJO");
            JavassistAopTypeInfoFactoryImplTestCase.assertFalse((String)"POJO shouldnt be frozen", (boolean)pojo.isFrozen());
            JavassistAopTypeInfoFactoryImpl typeInfoFactory = new JavassistAopTypeInfoFactoryImpl();
            JavassistTypeInfo pojoTypeInfo = (JavassistTypeInfo)typeInfoFactory.get(pojo);
            MethodInfo[] methodInfos = pojoTypeInfo.getDeclaredMethods();
            JavassistAopTypeInfoFactoryImplTestCase.assertEquals((String)"It should be one method in POJO", (int)methodInfos.length, (int)1);
            try {
                CtMethod bar = CtNewMethod.make((String)"public void bar() {}", (CtClass)pojo);
                pojo.addMethod(bar);
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
            JavassistTypeInfo pojoTypeInfo2 = (JavassistTypeInfo)typeInfoFactory.get(pojo);
            JavassistAopTypeInfoFactoryImplTestCase.assertEquals((String)"It should be two methods in POJO", (int)pojoTypeInfo2.getDeclaredMethods().length, (int)2);
            JavassistAopTypeInfoFactoryImplTestCase.assertFalse((String)"POJO shouldnt be frozen", (boolean)pojo.isFrozen());
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }
}

